/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.content.Context;
import android.os.Parcel;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.client.zzg;
import com.google.android.gms.ads.internal.client.zzj;
import com.google.android.gms.ads.zza;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.zzeo;

@zzeo
public final class AdSizeParcel
implements SafeParcelable {
    public static final zzg CREATOR = new zzg();
    public final int versionCode;
    public final String zzpX;
    public final int height;
    public final int heightPixels;
    public final boolean zzpY;
    public final int width;
    public final int widthPixels;
    public final AdSizeParcel[] zzpZ;
    public final boolean zzqa;

    public static int zza(DisplayMetrics displayMetrics) {
        return displayMetrics.widthPixels;
    }

    public static int zzb(DisplayMetrics displayMetrics) {
        return (int)((float)AdSizeParcel.zzc(displayMetrics) * displayMetrics.density);
    }

    private static int zzc(DisplayMetrics displayMetrics) {
        int n = (int)((float)displayMetrics.heightPixels / displayMetrics.density);
        if (n <= 400) {
            return 32;
        }
        if (n <= 720) {
            return 50;
        }
        return 90;
    }

    public AdSizeParcel() {
        this(2, "interstitial_mb", 0, 0, true, 0, 0, null, false);
    }

    public AdSizeParcel(Context context, AdSize adSize) {
        this(context, new AdSize[]{adSize});
    }

    public AdSizeParcel(Context context, AdSize[] adSizes) {
        int n;
        AdSize adSize = adSizes[0];
        this.versionCode = 2;
        this.zzpY = false;
        this.width = adSize.getWidth();
        this.height = adSize.getHeight();
        boolean bl = this.width == -1;
        boolean bl2 = this.height == -2;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        if (bl) {
            this.widthPixels = zzj.zzbJ().zzE(context) && zzj.zzbJ().zzF(context) ? AdSizeParcel.zza(displayMetrics) - zzj.zzbJ().zzG(context) : AdSizeParcel.zza(displayMetrics);
            n = (int)((float)this.widthPixels / displayMetrics.density);
        } else {
            n = this.width;
            this.widthPixels = zzj.zzbJ().zza(displayMetrics, this.width);
        }
        int n2 = bl2 ? AdSizeParcel.zzc(displayMetrics) : this.height;
        this.heightPixels = zzj.zzbJ().zza(displayMetrics, n2);
        this.zzpX = bl || bl2 ? n + "x" + n2 + "_as" : adSize.toString();
        if (adSizes.length > 1) {
            this.zzpZ = new AdSizeParcel[adSizes.length];
            for (int i = 0; i < adSizes.length; ++i) {
                this.zzpZ[i] = new AdSizeParcel(context, adSizes[i]);
            }
        } else {
            this.zzpZ = null;
        }
        this.zzqa = false;
    }

    public AdSizeParcel(AdSizeParcel adSize, AdSizeParcel[] supportedAdSizes) {
        this(2, adSize.zzpX, adSize.height, adSize.heightPixels, adSize.zzpY, adSize.width, adSize.widthPixels, supportedAdSizes, adSize.zzqa);
    }

    AdSizeParcel(int versionCode, String formatString, int height, int heightPixels, boolean isInterstitial, int width, int widthPixels, AdSizeParcel[] supportedAdSizes, boolean isNative) {
        this.versionCode = versionCode;
        this.zzpX = formatString;
        this.height = height;
        this.heightPixels = heightPixels;
        this.zzpY = isInterstitial;
        this.width = width;
        this.widthPixels = widthPixels;
        this.zzpZ = supportedAdSizes;
        this.zzqa = isNative;
    }

    public int describeContents() {
        return 0;
    }

    public AdSize zzbH() {
        return zza.zza(this.width, this.height, this.zzpX);
    }

    public void writeToParcel(Parcel out, int flags) {
        zzg.zza(this, out, flags);
    }
}

