/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.doubleclick;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import com.google.android.gms.ads.internal.client.zzt;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.common.internal.zzv;
import java.util.Date;
import java.util.List;
import java.util.Set;

public final class PublisherAdRequest {
    public static final int ERROR_CODE_INTERNAL_ERROR = 0;
    public static final int ERROR_CODE_INVALID_REQUEST = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 2;
    public static final int ERROR_CODE_NO_FILL = 3;
    public static final int GENDER_UNKNOWN = 0;
    public static final int GENDER_MALE = 1;
    public static final int GENDER_FEMALE = 2;
    public static final String DEVICE_ID_EMULATOR = zzt.DEVICE_ID_EMULATOR;
    private final zzt zzlY;

    private PublisherAdRequest(Builder builder) {
        this.zzlY = new zzt(builder.zzlZ);
    }

    public Date getBirthday() {
        return this.zzlY.getBirthday();
    }

    public String getContentUrl() {
        return this.zzlY.getContentUrl();
    }

    public int getGender() {
        return this.zzlY.getGender();
    }

    public Set<String> getKeywords() {
        return this.zzlY.getKeywords();
    }

    public Location getLocation() {
        return this.zzlY.getLocation();
    }

    public boolean getManualImpressionsEnabled() {
        return this.zzlY.getManualImpressionsEnabled();
    }

    @Deprecated
    public <T extends NetworkExtras> T getNetworkExtras(Class<T> networkExtrasClass) {
        return this.zzlY.getNetworkExtras(networkExtrasClass);
    }

    public <T extends MediationAdapter> Bundle getNetworkExtrasBundle(Class<T> adapterClass) {
        return this.zzlY.getNetworkExtrasBundle(adapterClass);
    }

    public <T extends CustomEvent> Bundle getCustomEventExtrasBundle(Class<T> adapterClass) {
        return this.zzlY.getCustomEventExtrasBundle(adapterClass);
    }

    public String getPublisherProvidedId() {
        return this.zzlY.getPublisherProvidedId();
    }

    public boolean isTestDevice(Context context) {
        return this.zzlY.isTestDevice(context);
    }

    public Bundle getCustomTargeting() {
        return this.zzlY.getCustomTargeting();
    }

    public static void updateCorrelator() {
        zzt.updateCorrelator();
    }

    public zzt zzac() {
        return this.zzlY;
    }

    public static final class Builder {
        private final zzt.zza zzlZ = new zzt.zza();

        public Builder addKeyword(String keyword) {
            this.zzlZ.zzt(keyword);
            return this;
        }

        public Builder addNetworkExtras(NetworkExtras networkExtras) {
            this.zzlZ.zza(networkExtras);
            return this;
        }

        public Builder addNetworkExtrasBundle(Class<? extends MediationAdapter> adapterClass, Bundle networkExtras) {
            this.zzlZ.zza(adapterClass, networkExtras);
            return this;
        }

        public Builder addCustomEventExtrasBundle(Class<? extends CustomEvent> adapterClass, Bundle customEventExtras) {
            this.zzlZ.zzb(adapterClass, customEventExtras);
            return this;
        }

        public Builder addTestDevice(String deviceId) {
            this.zzlZ.zzu(deviceId);
            return this;
        }

        public PublisherAdRequest build() {
            return new PublisherAdRequest(this);
        }

        public Builder setBirthday(Date birthday) {
            this.zzlZ.zza(birthday);
            return this;
        }

        public Builder setContentUrl(String contentUrl) {
            zzv.zzb((Object)contentUrl, (Object)"Content URL must be non-null.");
            zzv.zzh((String)contentUrl, (Object)"Content URL must be non-empty.");
            zzv.zzb((contentUrl.length() <= 512 ? 1 : 0) != 0, (String)"Content URL must not exceed %d in length.  Provided length was %d.", (Object[])new Object[]{512, contentUrl.length()});
            this.zzlZ.zzw(contentUrl);
            return this;
        }

        public Builder setGender(int gender) {
            this.zzlZ.zzi(gender);
            return this;
        }

        public Builder setLocation(Location location) {
            this.zzlZ.zza(location);
            return this;
        }

        public Builder setManualImpressionsEnabled(boolean manualImpressionsEnabled) {
            this.zzlZ.zzk(manualImpressionsEnabled);
            return this;
        }

        public Builder setPublisherProvidedId(String publisherProvidedId) {
            this.zzlZ.zzx(publisherProvidedId);
            return this;
        }

        public Builder setRequestAgent(String requestAgent) {
            this.zzlZ.zzy(requestAgent);
            return this;
        }

        public Builder tagForChildDirectedTreatment(boolean tagForChildDirectedTreatment) {
            this.zzlZ.zzl(tagForChildDirectedTreatment);
            return this;
        }

        public Builder addCustomTargeting(String key, String value) {
            this.zzlZ.zzc(key, value);
            return this;
        }

        public Builder addCustomTargeting(String key, List<String> values) {
            if (values != null) {
                this.zzlZ.zzc(key, com.google.android.gms.common.internal.zzt.zzbR((String)",").zza(values));
            }
            return this;
        }

        public Builder addCategoryExclusion(String categoryExclusion) {
            this.zzlZ.zzz(categoryExclusion);
            return this;
        }
    }
}

