/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.MutableContextWrapper;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.google.android.gms.internal.zzab;
import com.google.android.gms.internal.zzba;
import com.google.android.gms.internal.zzbe;
import com.google.android.gms.internal.zzeg;
import com.google.android.gms.internal.zzel;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzhx;
import com.google.android.gms.internal.zzhy;
import com.google.android.gms.internal.zzic;
import com.google.android.gms.internal.zzid;
import com.google.android.gms.internal.zzk;
import com.google.android.gms.internal.zzme;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzgi
public class zzif
extends WebView
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzic {
    private final zzid zzvy;
    private final zza zzAa;
    private final Object zznh = new Object();
    private final zzk zzwg;
    private final zzhy zznl;
    private zzel zzAb;
    private zzba zzsF;
    private boolean zzAc;
    private boolean zzAd;
    private boolean zzAe;
    private boolean zzAf;
    private boolean zzAg;
    private Boolean zzyV;
    private int zzAh;
    boolean zzAi;
    private int zztJ = -1;
    private int zztI = -1;
    private int zztL = -1;
    private int zztM = -1;
    private final WindowManager zznu;

    static zzif zzb(Context context, zzba zzba2, boolean bl, boolean bl2, zzk zzk2, zzhy zzhy2) {
        zza zza2 = new zza(context);
        return new zzif(zza2, zzba2, bl, bl2, zzk2, zzhy2);
    }

    protected zzif(zza zza2, zzba zzba2, boolean bl, boolean bl2, zzk zzk2, zzhy zzhy2) {
        super((Context)zza2);
        this.zzAa = zza2;
        this.zzsF = zzba2;
        this.zzAe = bl;
        this.zzAg = false;
        this.zzAh = -1;
        this.zzwg = zzk2;
        this.zznl = zzhy2;
        this.zznu = (WindowManager)this.getContext().getSystemService("window");
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(0);
        }
        zzab.zzaM().zza((Context)zza2, zzhy2.zzzH, webSettings);
        zzab.zzaO().zza(this.getContext(), webSettings);
        this.setDownloadListener(this);
        this.zzvy = zzab.zzaO().zzb(this, bl2);
        this.setWebViewClient(this.zzvy);
        this.setWebChromeClient(zzab.zzaO().zzb(this));
        this.zzeW();
    }

    @Override
    public WebView getWebView() {
        return this;
    }

    public boolean zzeS() {
        int n;
        int n2;
        if (!this.zzeG().zzba()) {
            return false;
        }
        DisplayMetrics displayMetrics = zzab.zzaM().zza(this.zznu);
        int n3 = zzbe.zzbD().zzb(displayMetrics, displayMetrics.widthPixels);
        int n4 = zzbe.zzbD().zzb(displayMetrics, displayMetrics.heightPixels);
        Activity activity = this.zzeD();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            int[] nArray = zzab.zzaM().zzg(activity);
            n2 = zzbe.zzbD().zzb(displayMetrics, nArray[0]);
            n = zzbe.zzbD().zzb(displayMetrics, nArray[1]);
        }
        if (this.zztI == n3 && this.zztJ == n4 && this.zztL == n2 && this.zztM == n) {
            return false;
        }
        boolean bl = this.zztI != n3 || this.zztJ != n4;
        this.zztI = n3;
        this.zztJ = n4;
        this.zztL = n2;
        this.zztM = n;
        new zzeg(this).zza(n3, n4, n2, n, displayMetrics.density, this.zznu.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public void zzb(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzab.zzaM().zzw(map);
        }
        catch (JSONException jSONException) {
            zzhx.zzac("Could not convert parameters to JSON.");
            return;
        }
        this.zzb(string2, jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateJavascript(String script, ValueCallback<String> resultCallback) {
        Object object = this.zznh;
        synchronized (object) {
            if (this.isDestroyed()) {
                zzhx.zzac("The webview is destroyed. Ignoring action.");
                if (resultCallback != null) {
                    resultCallback.onReceiveValue(null);
                }
                return;
            }
            super.evaluateJavascript(script, resultCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzad(String string2) {
        Object object = this.zznh;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.loadUrl(string2);
            } else {
                zzhx.zzac("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadData(String data, String mimeType, String encoding) {
        Object object = this.zznh;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadData(data, mimeType, encoding);
            } else {
                zzhx.zzac("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        Object object = this.zznh;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
            } else {
                zzhx.zzac("The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zza(String string2, ValueCallback<String> valueCallback) {
        Object object = this.zznh;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.evaluateJavascript(string2, valueCallback);
            } else {
                zzhx.zzac("The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
            }
        }
    }

    protected void zzae(String string2) {
        if (zzme.zzkj()) {
            if (this.zzek() == null) {
                this.zzeT();
            }
            if (this.zzek().booleanValue()) {
                this.zza(string2, (ValueCallback<String>)null);
            } else {
                this.zzad("javascript:" + string2);
            }
        } else {
            this.zzad("javascript:" + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzeT() {
        Object object = this.zznh;
        synchronized (object) {
            this.zzyV = zzab.zzaP().zzek();
            if (this.zzyV == null) {
                try {
                    String string2 = "(function(){})()";
                    this.evaluateJavascript(string2, null);
                    this.zzb(true);
                }
                catch (IllegalStateException illegalStateException) {
                    this.zzb(false);
                }
            }
        }
    }

    void zzb(Boolean bl) {
        this.zzyV = bl;
        zzab.zzaP().zzb(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Boolean zzek() {
        Object object = this.zznh;
        synchronized (object) {
            return this.zzyV;
        }
    }

    @Override
    public void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        this.zzb(string2, string3);
    }

    @Override
    public void zzb(String string2, String string3) {
        String string4 = string2 + "(" + string3 + ");";
        this.zzae(string4);
    }

    @Override
    public void zzb(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AFMA_ReceiveMessage('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        zzhx.zzab("Dispatching AFMA event: " + stringBuilder.toString());
        this.zzae(stringBuilder.toString());
    }

    @Override
    public void zzp(int n) {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zznl.zzzH);
        this.zzb("onhide", hashMap);
    }

    @Override
    public void zzdh() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zznl.zzzH);
        this.zzb("onshow", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzel zzeF() {
        Object object = this.zznh;
        synchronized (object) {
            return this.zzAb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzba zzad() {
        Object object = this.zznh;
        synchronized (object) {
            return this.zzsF;
        }
    }

    @Override
    public zzid zzeG() {
        return this.zzvy;
    }

    @Override
    public boolean zzeH() {
        return this.zzAc;
    }

    @Override
    public zzk zzeI() {
        return this.zzwg;
    }

    @Override
    public zzhy zzeJ() {
        return this.zznl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzeK() {
        Object object = this.zznh;
        synchronized (object) {
            return this.zzAe;
        }
    }

    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long size) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)url), mimeType);
            this.getContext().startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzhx.zzY("Couldn't find an Activity to view url/mimetype: " + url + " / " + mimeType);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.zzwg != null) {
            this.zzwg.zza(event);
        }
        return super.onTouchEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Object object = this.zznh;
        synchronized (object) {
            if (this.isInEditMode() || this.zzAe) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                return;
            }
            if (this.zzsF.zzpb) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                this.zznu.getDefaultDisplay().getMetrics(displayMetrics);
                this.setMeasuredDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
                return;
            }
            int n = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int n2 = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int n3 = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int n4 = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int n5 = Integer.MAX_VALUE;
            if (n == Integer.MIN_VALUE || n == 0x40000000) {
                n5 = n2;
            }
            int n6 = Integer.MAX_VALUE;
            if (n3 == Integer.MIN_VALUE || n3 == 0x40000000) {
                n6 = n4;
            }
            if (this.zzsF.widthPixels > n5 || this.zzsF.heightPixels > n6) {
                float f = this.zzAa.getResources().getDisplayMetrics().density;
                zzhx.zzac("Not enough space to show ad. Needs " + (int)((float)this.zzsF.widthPixels / f) + "x" + (int)((float)this.zzsF.heightPixels / f) + " dp, but only has " + (int)((float)n2 / f) + "x" + (int)((float)n4 / f) + " dp.");
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.zzsF.widthPixels, this.zzsF.heightPixels);
            }
        }
    }

    public void onGlobalLayout() {
        boolean bl = this.zzeS();
        zzel zzel2 = this.zzeF();
        if (zzel2 != null && bl) {
            zzel2.zzdg();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(Context context, zzba zzba2) {
        Object object = this.zznh;
        synchronized (object) {
            this.zzeU();
            this.setContext(context);
            this.zzAb = null;
            this.zzsF = zzba2;
            this.zzAe = false;
            this.zzAc = false;
            this.zzAh = -1;
            zzab.zzaO().zzb(this);
            this.loadUrl("about:blank");
            this.zzvy.reset();
            this.setOnTouchListener(null);
            this.setOnClickListener(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(zzel zzel2) {
        Object object = this.zznh;
        synchronized (object) {
            this.zzAb = zzel2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(zzba zzba2) {
        Object object = this.zznh;
        synchronized (object) {
            this.zzsF = zzba2;
            this.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzA(boolean bl) {
        Object object = this.zznh;
        synchronized (object) {
            this.zzAe = bl;
            this.zzeW();
        }
    }

    private void zzeU() {
        Activity activity = this.zzeD();
        if (this.zzAg && activity != null) {
            zzab.zzaO().zzb(activity, this);
            this.zzAg = false;
        }
    }

    void zzeV() {
        Activity activity = this.zzeD();
        if (!this.zzAg && activity != null && this.zzAi) {
            zzab.zzaM().zza(activity, this);
            this.zzAg = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzeL() {
        Object object = this.zznh;
        synchronized (object) {
            this.zzeV();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAttachedToWindow() {
        Object object = this.zznh;
        synchronized (object) {
            super.onAttachedToWindow();
            this.zzAi = true;
            if (this.zzvy.zzba()) {
                this.zzeV();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDetachedFromWindow() {
        Object object = this.zznh;
        synchronized (object) {
            this.zzeU();
            this.zzAi = false;
            super.onDetachedFromWindow();
        }
    }

    @Override
    public void setContext(Context context) {
        this.zzAa.setBaseContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzB(boolean bl) {
        Object object = this.zznh;
        synchronized (object) {
            if (this.zzAb != null) {
                this.zzAb.zza(this.zzvy.zzba(), bl);
            } else {
                this.zzAc = bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRequestedOrientation() {
        Object object = this.zznh;
        synchronized (object) {
            return this.zzAh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequestedOrientation(int requestedOrientation) {
        Object object = this.zznh;
        synchronized (object) {
            this.zzAh = requestedOrientation;
            if (this.zzAb != null) {
                this.zzAb.setRequestedOrientation(this.zzAh);
            }
        }
    }

    @Override
    public Activity zzeD() {
        return this.zzAa.zzeD();
    }

    @Override
    public Context zzeE() {
        return this.zzAa.zzeE();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzeW() {
        Object object = this.zznh;
        synchronized (object) {
            if (this.zzAe || this.zzsF.zzpb) {
                if (Build.VERSION.SDK_INT < 14) {
                    zzhx.zzY("Disabling hardware acceleration on an overlay.");
                    this.zzeX();
                } else {
                    zzhx.zzY("Enabling hardware acceleration on an overlay.");
                    this.zzeY();
                }
            } else if (Build.VERSION.SDK_INT < 18) {
                zzhx.zzY("Disabling hardware acceleration on an AdView.");
                this.zzeX();
            } else {
                zzhx.zzY("Enabling hardware acceleration on an AdView.");
                this.zzeY();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzeX() {
        Object object = this.zznh;
        synchronized (object) {
            if (!this.zzAf) {
                zzab.zzaO().zzk((View)this);
            }
            this.zzAf = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzeY() {
        Object object = this.zznh;
        synchronized (object) {
            if (this.zzAf) {
                zzab.zzaO().zzj((View)this);
            }
            this.zzAf = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.zznh;
        synchronized (object) {
            this.zzeU();
            if (this.zzAb != null) {
                this.zzAb.close();
                this.zzAb.onDestroy();
                this.zzAb = null;
            }
            this.zzvy.reset();
            if (this.zzAd) {
                return;
            }
            this.zzAd = true;
            super.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDestroyed() {
        Object object = this.zznh;
        synchronized (object) {
            return this.zzAd;
        }
    }

    protected void onDraw(Canvas canvas) {
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
    }

    public void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onPause();
        }
        catch (Exception exception) {
            zzhx.zzb("Could not pause webview.", exception);
        }
    }

    public void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onResume();
        }
        catch (Exception exception) {
            zzhx.zzb("Could not resume webview.", exception);
        }
    }

    @Override
    public void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.stopLoading();
        }
        catch (Exception exception) {
            zzhx.zzb("Could not stop loading webview.", exception);
        }
    }

    @zzgi
    public static class zza
    extends MutableContextWrapper {
        private Activity zzAj;
        private Context zznk;
        private Context zzAk;

        public zza(Context context) {
            super(context);
            this.setBaseContext(context);
        }

        public void setBaseContext(Context base) {
            this.zznk = base.getApplicationContext();
            this.zzAj = base instanceof Activity ? (Activity)base : null;
            this.zzAk = base;
            super.setBaseContext(this.zznk);
        }

        public void startActivity(Intent intent) {
            if (this.zzAj != null && !zzme.zzkk()) {
                this.zzAj.startActivity(intent);
            } else {
                intent.setFlags(0x10000000);
                this.zznk.startActivity(intent);
            }
        }

        public Activity zzeD() {
            return this.zzAj;
        }

        public Object getSystemService(String service) {
            return this.zzAk.getSystemService(service);
        }

        public Context zzeE() {
            return this.zzAk;
        }
    }
}

