/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.internal.zzba;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzhx;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;

@zzgi
public class zzhw {
    public static final Handler zzzG = new Handler(Looper.getMainLooper());

    public int zzb(Context context, int n) {
        return this.zza(context.getResources().getDisplayMetrics(), n);
    }

    public int zza(DisplayMetrics displayMetrics, int n) {
        return (int)TypedValue.applyDimension((int)1, (float)n, (DisplayMetrics)displayMetrics);
    }

    public int zzc(Context context, int n) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        return this.zzb(displayMetrics, n);
    }

    public int zzb(DisplayMetrics displayMetrics, int n) {
        return Math.round((float)n / displayMetrics.density);
    }

    public void zza(ViewGroup viewGroup, zzba zzba2, String string2, String string3) {
        zzhx.zzac(string3);
        this.zza(viewGroup, zzba2, string2, -65536, -16777216);
    }

    public void zza(ViewGroup viewGroup, zzba zzba2, String string2) {
        this.zza(viewGroup, zzba2, string2, -16777216, -1);
    }

    private void zza(ViewGroup viewGroup, zzba zzba2, String string2, int n, int n2) {
        if (viewGroup.getChildCount() != 0) {
            return;
        }
        Context context = viewGroup.getContext();
        TextView textView = new TextView(context);
        textView.setGravity(17);
        textView.setText((CharSequence)string2);
        textView.setTextColor(n);
        textView.setBackgroundColor(n2);
        FrameLayout frameLayout = new FrameLayout(context);
        frameLayout.setBackgroundColor(n);
        int n3 = this.zzb(context, 3);
        frameLayout.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(zzba2.widthPixels - n3, zzba2.heightPixels - n3, 17));
        viewGroup.addView((View)frameLayout, zzba2.widthPixels, zzba2.heightPixels);
    }

    public String zzz(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        String string2 = contentResolver == null ? null : Settings.Secure.getString((ContentResolver)contentResolver, (String)"android_id");
        return this.zzX(string2 == null || this.zzeB() ? "emulator" : string2);
    }

    public boolean zzeB() {
        return Build.DEVICE.startsWith("generic");
    }

    public boolean zzeC() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public String zzX(String string2) {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(string2.getBytes());
                return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest()));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
        }
        return null;
    }

    public boolean zzA(Context context) {
        return 0 == GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)context);
    }
}

