/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.internal.zzab;
import com.google.android.gms.internal.zzbe;
import com.google.android.gms.internal.zzgi;
import java.util.Locale;

@zzgi
public final class zzhb {
    public final int zzxY;
    public final boolean zzxZ;
    public final boolean zzya;
    public final String zzyb;
    public final String zzyc;
    public final boolean zzyd;
    public final boolean zzye;
    public final boolean zzyf;
    public final String zzyg;
    public final String zzyh;
    public final int zzyi;
    public final int zzyj;
    public final int zzyk;
    public final int zzyl;
    public final int zzym;
    public final int zzyn;
    public final float zzwz;
    public final int zzwx;
    public final int zzwy;
    public final double zzyo;
    public final boolean zzyp;
    public final boolean zzyq;
    public final int zzyr;

    public zzhb(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        Locale locale = Locale.getDefault();
        PackageManager packageManager = context.getPackageManager();
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = context.registerReceiver(null, intentFilter);
        this.zzxY = audioManager.getMode();
        this.zzxZ = zzhb.zza(packageManager, "geo:0,0?q=donuts") != null;
        this.zzya = zzhb.zza(packageManager, "http://www.google.com") != null;
        this.zzyb = telephonyManager.getNetworkOperator();
        this.zzyc = locale.getCountry();
        this.zzyd = zzbe.zzbD().zzeB();
        this.zzye = audioManager.isMusicActive();
        this.zzyf = audioManager.isSpeakerphoneOn();
        this.zzyg = locale.getLanguage();
        this.zzyh = zzhb.zza(packageManager);
        this.zzyi = audioManager.getStreamVolume(3);
        this.zzyj = zzhb.zza(context, connectivityManager, packageManager);
        this.zzyk = telephonyManager.getNetworkType();
        this.zzyl = telephonyManager.getPhoneType();
        this.zzym = audioManager.getRingerMode();
        this.zzyn = audioManager.getStreamVolume(2);
        this.zzwz = displayMetrics.density;
        this.zzwx = displayMetrics.widthPixels;
        this.zzwy = displayMetrics.heightPixels;
        if (intent != null) {
            int n = intent.getIntExtra("status", -1);
            int n2 = intent.getIntExtra("level", -1);
            int n3 = intent.getIntExtra("scale", -1);
            this.zzyo = (float)n2 / (float)n3;
            this.zzyp = n == 2 || n == 5;
        } else {
            this.zzyo = -1.0;
            this.zzyp = false;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.zzyq = connectivityManager.isActiveNetworkMetered();
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            this.zzyr = networkInfo != null ? connectivityManager.getActiveNetworkInfo().getDetailedState().ordinal() : -1;
        } else {
            this.zzyq = false;
            this.zzyr = -1;
        }
    }

    private static String zza(PackageManager packageManager) {
        ResolveInfo resolveInfo = zzhb.zza(packageManager, "market://details?id=com.google.android.gms.ads");
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null) {
            return null;
        }
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(activityInfo.packageName, 0);
            return packageInfo != null ? packageInfo.versionCode + "." + activityInfo.packageName : null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static int zza(Context context, ConnectivityManager connectivityManager, PackageManager packageManager) {
        int n = -2;
        if (zzab.zzaM().zza(packageManager, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            n = networkInfo != null ? networkInfo.getType() : -1;
        }
        return n;
    }

    private static ResolveInfo zza(PackageManager packageManager, String string2) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
        return packageManager.resolveActivity(intent, 65536);
    }
}

