/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.location.Location;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.internal.zzab;
import com.google.android.gms.internal.zzax;
import com.google.android.gms.internal.zzba;
import com.google.android.gms.internal.zzbs;
import com.google.android.gms.internal.zzbv;
import com.google.android.gms.internal.zzca;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzgo;
import com.google.android.gms.internal.zzgq;
import com.google.android.gms.internal.zzgw;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzhk;
import com.google.android.gms.internal.zzhx;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzgi
public final class zzgx {
    private static final SimpleDateFormat zzxu = new SimpleDateFormat("yyyyMMdd");

    public static JSONObject zza(zzgo zzgo2, zzhb zzhb2, Location location, zzbv zzbv2) {
        try {
            CharSequence charSequence;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            List<String> list = zzbv2.zzbW();
            if (list.size() > 0) {
                hashMap.put("eid", TextUtils.join((CharSequence)",", list));
            }
            if (zzgo2.zzwm != null) {
                hashMap.put("ad_pos", zzgo2.zzwm);
            }
            zzgx.zza(hashMap, zzgo2.zzwn);
            hashMap.put("format", zzgo2.zzlV.zzpa);
            if (zzgo2.zzlV.width == -1) {
                hashMap.put("smart_w", "full");
            }
            if (zzgo2.zzlV.height == -2) {
                hashMap.put("smart_h", "auto");
            }
            if (zzgo2.zzlV.zzpc != null) {
                charSequence = new StringBuilder();
                for (zzba zzba2 : zzgo2.zzlV.zzpc) {
                    if (charSequence.length() != 0) {
                        charSequence.append("|");
                    }
                    charSequence.append(zzba2.width == -1 ? (int)((float)zzba2.widthPixels / zzhb2.zzwz) : zzba2.width);
                    charSequence.append("x");
                    charSequence.append(zzba2.height == -2 ? (int)((float)zzba2.heightPixels / zzhb2.zzwz) : zzba2.height);
                }
                hashMap.put("sz", charSequence);
            }
            if (zzgo2.zzwt != 0) {
                hashMap.put("native_version", zzgo2.zzwt);
                hashMap.put("native_templates", zzgo2.zzmf);
            }
            hashMap.put("slotname", zzgo2.zzlM);
            hashMap.put("pn", zzgo2.applicationInfo.packageName);
            if (zzgo2.zzwo != null) {
                hashMap.put("vc", zzgo2.zzwo.versionCode);
            }
            hashMap.put("ms", zzgo2.zzwp);
            hashMap.put("seq_num", zzgo2.zzwq);
            hashMap.put("session_id", zzgo2.zzwr);
            hashMap.put("js", zzgo2.zzlP.zzzH);
            zzgx.zza(hashMap, zzhb2);
            hashMap.put("fdz", new Integer(zzbv2.zzbX()));
            if (zzgo2.zzwn.versionCode >= 2 && zzgo2.zzwn.zzoT != null) {
                zzgx.zza(hashMap, zzgo2.zzwn.zzoT);
            }
            if (zzgo2.versionCode >= 2) {
                hashMap.put("quality_signals", zzgo2.zzws);
            }
            if (zzgo2.versionCode >= 4 && zzgo2.zzwv) {
                hashMap.put("forceHttps", zzgo2.zzwv);
            }
            if (zzgo2.versionCode >= 4 && zzgo2.zzwu != null) {
                hashMap.put("content_info", zzgo2.zzwu);
            }
            if (zzgo2.versionCode >= 5) {
                hashMap.put("u_sd", Float.valueOf(zzgo2.zzwz));
                hashMap.put("sh", zzgo2.zzwy);
                hashMap.put("sw", zzgo2.zzwx);
            } else {
                hashMap.put("u_sd", Float.valueOf(zzhb2.zzwz));
                hashMap.put("sh", zzhb2.zzwy);
                hashMap.put("sw", zzhb2.zzwx);
            }
            if (zzgo2.versionCode >= 6) {
                if (!TextUtils.isEmpty((CharSequence)zzgo2.zzwA)) {
                    try {
                        hashMap.put("view_hierarchy", new JSONObject(zzgo2.zzwA));
                    }
                    catch (JSONException jSONException) {
                        zzhx.zzd("Problem serializing view hierarchy to JSON", jSONException);
                    }
                }
                if (zzca.zzqL.get().booleanValue() && zzgo2.zzwB) {
                    hashMap.put("ga_hid", zzgo2.zzwC);
                    hashMap.put("ga_cid", zzgo2.zzwD);
                }
                hashMap.put("correlation_id", zzgo2.zzwE);
            }
            if (zzgo2.versionCode >= 7) {
                hashMap.put("request_id", zzgo2.zzwF);
            }
            if (zzhx.zzA(2)) {
                charSequence = zzab.zzaM().zzw(hashMap).toString(2);
                zzhx.zzab("Ad Request JSON: " + (String)charSequence);
            }
            return zzab.zzaM().zzw(hashMap);
        }
        catch (JSONException jSONException) {
            zzhx.zzac("Problem serializing ad request to JSON: " + jSONException.getMessage());
            return null;
        }
    }

    private static void zza(HashMap<String, Object> hashMap, zzax zzax2) {
        String string2 = zzhk.zzep();
        if (string2 != null) {
            hashMap.put("abf", string2);
        }
        if (zzax2.zzoL != -1L) {
            hashMap.put("cust_age", zzxu.format(new Date(zzax2.zzoL)));
        }
        if (zzax2.extras != null) {
            hashMap.put("extras", zzax2.extras);
        }
        if (zzax2.zzoM != -1) {
            hashMap.put("cust_gender", zzax2.zzoM);
        }
        if (zzax2.zzoN != null) {
            hashMap.put("kw", zzax2.zzoN);
        }
        if (zzax2.zzoP != -1) {
            hashMap.put("tag_for_child_directed_treatment", zzax2.zzoP);
        }
        if (zzax2.zzoO) {
            hashMap.put("adtest", "on");
        }
        if (zzax2.versionCode >= 2) {
            if (zzax2.zzoQ) {
                hashMap.put("d_imp_hdr", 1);
            }
            if (!TextUtils.isEmpty((CharSequence)zzax2.zzoR)) {
                hashMap.put("ppid", zzax2.zzoR);
            }
            if (zzax2.zzoS != null) {
                zzgx.zza(hashMap, zzax2.zzoS);
            }
        }
        if (zzax2.versionCode >= 3 && zzax2.zzoU != null) {
            hashMap.put("url", zzax2.zzoU);
        }
        if (zzax2.versionCode >= 5) {
            if (zzax2.zzoW != null) {
                hashMap.put("custom_targeting", zzax2.zzoW);
            }
            if (zzax2.zzoX != null) {
                hashMap.put("category_exclusions", zzax2.zzoX);
            }
            if (zzax2.zzoY != null) {
                hashMap.put("request_agent", zzax2.zzoY);
            }
        }
    }

    private static void zza(HashMap<String, Object> hashMap, zzhb zzhb2) {
        hashMap.put("am", zzhb2.zzxY);
        hashMap.put("cog", zzgx.zzw(zzhb2.zzxZ));
        hashMap.put("coh", zzgx.zzw(zzhb2.zzya));
        if (!TextUtils.isEmpty((CharSequence)zzhb2.zzyb)) {
            hashMap.put("carrier", zzhb2.zzyb);
        }
        hashMap.put("gl", zzhb2.zzyc);
        if (zzhb2.zzyd) {
            hashMap.put("simulator", 1);
        }
        hashMap.put("ma", zzgx.zzw(zzhb2.zzye));
        hashMap.put("sp", zzgx.zzw(zzhb2.zzyf));
        hashMap.put("hl", zzhb2.zzyg);
        if (!TextUtils.isEmpty((CharSequence)zzhb2.zzyh)) {
            hashMap.put("mv", zzhb2.zzyh);
        }
        hashMap.put("muv", zzhb2.zzyi);
        if (zzhb2.zzyj != -2) {
            hashMap.put("cnt", zzhb2.zzyj);
        }
        hashMap.put("gnt", zzhb2.zzyk);
        hashMap.put("pt", zzhb2.zzyl);
        hashMap.put("rm", zzhb2.zzym);
        hashMap.put("riv", zzhb2.zzyn);
        Bundle bundle = new Bundle();
        bundle.putInt("active_network_state", zzhb2.zzyr);
        bundle.putBoolean("active_network_metered", zzhb2.zzyq);
        hashMap.put("connectivity", bundle);
        Bundle bundle2 = new Bundle();
        bundle2.putBoolean("is_charging", zzhb2.zzyp);
        bundle2.putDouble("battery_level", zzhb2.zzyo);
        hashMap.put("battery", bundle2);
    }

    private static void zza(HashMap<String, Object> hashMap, Location location) {
        HashMap<String, Number> hashMap2 = new HashMap<String, Number>();
        Float f = Float.valueOf(location.getAccuracy() * 1000.0f);
        Long l = location.getTime() * 1000L;
        Long l2 = (long)(location.getLatitude() * 1.0E7);
        Long l3 = (long)(location.getLongitude() * 1.0E7);
        hashMap2.put("radius", f);
        hashMap2.put("lat", l2);
        hashMap2.put("long", l3);
        hashMap2.put("time", l);
        hashMap.put("uule", hashMap2);
    }

    private static void zza(HashMap<String, Object> hashMap, zzbs zzbs2) {
        String string2;
        String string3;
        if (Color.alpha((int)zzbs2.zzpN) != 0) {
            hashMap.put("acolor", zzgx.zzy(zzbs2.zzpN));
        }
        if (Color.alpha((int)zzbs2.backgroundColor) != 0) {
            hashMap.put("bgcolor", zzgx.zzy(zzbs2.backgroundColor));
        }
        if (Color.alpha((int)zzbs2.zzpO) != 0 && Color.alpha((int)zzbs2.zzpP) != 0) {
            hashMap.put("gradientto", zzgx.zzy(zzbs2.zzpO));
            hashMap.put("gradientfrom", zzgx.zzy(zzbs2.zzpP));
        }
        if (Color.alpha((int)zzbs2.zzpQ) != 0) {
            hashMap.put("bcolor", zzgx.zzy(zzbs2.zzpQ));
        }
        hashMap.put("bthick", Integer.toString(zzbs2.zzpR));
        switch (zzbs2.zzpS) {
            case 0: {
                string3 = "none";
                break;
            }
            case 1: {
                string3 = "dashed";
                break;
            }
            case 2: {
                string3 = "dotted";
                break;
            }
            case 3: {
                string3 = "solid";
                break;
            }
            default: {
                string3 = null;
            }
        }
        if (string3 != null) {
            hashMap.put("btype", string3);
        }
        switch (zzbs2.zzpT) {
            case 2: {
                string2 = "dark";
                break;
            }
            case 0: {
                string2 = "light";
                break;
            }
            case 1: {
                string2 = "medium";
                break;
            }
            default: {
                string2 = null;
            }
        }
        if (string2 != null) {
            hashMap.put("callbuttoncolor", string2);
        }
        if (zzbs2.zzpU != null) {
            hashMap.put("channel", zzbs2.zzpU);
        }
        if (Color.alpha((int)zzbs2.zzpV) != 0) {
            hashMap.put("dcolor", zzgx.zzy(zzbs2.zzpV));
        }
        if (zzbs2.zzpW != null) {
            hashMap.put("font", zzbs2.zzpW);
        }
        if (Color.alpha((int)zzbs2.zzpX) != 0) {
            hashMap.put("hcolor", zzgx.zzy(zzbs2.zzpX));
        }
        hashMap.put("headersize", Integer.toString(zzbs2.zzpY));
        if (zzbs2.zzpZ != null) {
            hashMap.put("q", zzbs2.zzpZ);
        }
    }

    private static Integer zzw(boolean bl) {
        return bl ? 1 : 0;
    }

    private static String zzy(int n) {
        return String.format(Locale.US, "#%06x", n & 0xFFFFFF);
    }

    public static zzgq zza(Context context, zzgo zzgo2, String string2) {
        try {
            List<String> list;
            List<String> list2;
            List<String> list3;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("ad_base_url", null);
            String string4 = jSONObject.optString("ad_url", null);
            String string5 = jSONObject.optString("ad_size", null);
            String string6 = jSONObject.optString("ad_html", null);
            long l = -1L;
            String string7 = jSONObject.optString("debug_dialog", null);
            long l2 = jSONObject.has("interstitial_timeout") ? (long)(jSONObject.getDouble("interstitial_timeout") * 1000.0) : -1L;
            String string8 = jSONObject.optString("orientation", null);
            int n = -1;
            if ("portrait".equals(string8)) {
                n = zzab.zzaO().zzey();
            } else if ("landscape".equals(string8)) {
                n = zzab.zzaO().zzex();
            }
            zzgq zzgq2 = null;
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    zzhx.zzac("Could not parse the mediation config: Missing required ad_base_url field");
                    return new zzgq(0);
                }
            } else if (!TextUtils.isEmpty((CharSequence)string4)) {
                zzgq2 = zzgw.zza(context, zzgo2.zzlP.zzzH, string4, null, null);
                string3 = zzgq2.zzus;
                string6 = zzgq2.zzwG;
                l = zzgq2.zzwM;
            } else {
                zzhx.zzac("Could not parse the mediation config: Missing required ad_html or ad_url field.");
                return new zzgq(0);
            }
            JSONArray jSONArray = jSONObject.optJSONArray("click_urls");
            List<String> list4 = list3 = zzgq2 == null ? null : zzgq2.zzst;
            if (jSONArray != null) {
                if (list3 == null) {
                    list3 = new LinkedList<String>();
                }
                for (int i = 0; i < jSONArray.length(); ++i) {
                    list3.add(jSONArray.getString(i));
                }
            }
            JSONArray jSONArray2 = jSONObject.optJSONArray("impression_urls");
            List<String> list5 = list2 = zzgq2 == null ? null : zzgq2.zzsu;
            if (jSONArray2 != null) {
                if (list2 == null) {
                    list2 = new LinkedList<String>();
                }
                for (int i = 0; i < jSONArray2.length(); ++i) {
                    list2.add(jSONArray2.getString(i));
                }
            }
            JSONArray jSONArray3 = jSONObject.optJSONArray("manual_impression_urls");
            List<String> list6 = list = zzgq2 == null ? null : zzgq2.zzwK;
            if (jSONArray3 != null) {
                if (list == null) {
                    list = new LinkedList<String>();
                }
                for (int i = 0; i < jSONArray3.length(); ++i) {
                    list.add(jSONArray3.getString(i));
                }
            }
            if (zzgq2 != null) {
                if (zzgq2.orientation != -1) {
                    n = zzgq2.orientation;
                }
                if (zzgq2.zzwH > 0L) {
                    l2 = zzgq2.zzwH;
                }
            }
            String string9 = jSONObject.optString("active_view");
            String string10 = null;
            boolean bl = jSONObject.optBoolean("ad_is_javascript", false);
            if (bl) {
                string10 = jSONObject.optString("ad_passback_url", null);
            }
            boolean bl2 = jSONObject.optBoolean("mediation", false);
            boolean bl3 = jSONObject.optBoolean("custom_render_allowed", false);
            boolean bl4 = jSONObject.optBoolean("native", false);
            boolean bl5 = jSONObject.optBoolean("content_url_opted_out", false);
            boolean bl6 = jSONObject.optBoolean("prefetch", false);
            long l3 = jSONObject.optLong("refresh_interval_milliseconds", -1L);
            long l4 = jSONObject.optLong("mediation_config_cache_time_milliseconds", -1L);
            return new zzgq(string3, string6, list3, list2, l2, bl2, l4, list, l3, n, string5, l, string7, bl, string10, string9, bl3, bl4, zzgo2.zzwv, bl5, bl6);
        }
        catch (JSONException jSONException) {
            zzhx.zzac("Could not parse the mediation config: " + jSONException.getMessage());
            return new zzgq(0);
        }
    }
}

