/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzah;
import com.google.android.gms.internal.zzai;
import com.google.android.gms.internal.zzcn;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzgu;
import com.google.android.gms.internal.zzgv;
import com.google.android.gms.internal.zzhe;
import com.google.android.gms.internal.zzhq;
import com.google.android.gms.internal.zzhr;
import com.google.android.gms.internal.zzht;
import com.google.android.gms.internal.zzhx;
import com.google.android.gms.internal.zzic;
import com.google.android.gms.internal.zzlz;
import com.google.android.gms.internal.zzt;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzgi
public class zzgt
implements Callable<zzhe> {
    private final Context mContext;
    private final zzht zzwV;
    private final zzt zzrv;
    private final zzai zzwW;
    private final Object zznh = new Object();
    private final zzhe.zza zzvN;
    private boolean zzwX;
    private int zzvR;
    private List<String> zzwY;

    public zzgt(Context context, zzt zzt2, zzai zzai2, zzht zzht2, zzhe.zza zza2) {
        this.mContext = context;
        this.zzrv = zzt2;
        this.zzwV = zzht2;
        this.zzwW = zzai2;
        this.zzvN = zza2;
        this.zzwX = false;
        this.zzvR = -2;
        this.zzwY = null;
    }

    public zzhe zzdM() {
        try {
            zzah zzah2 = this.zzdN();
            JSONObject jSONObject = this.zzc(zzah2);
            zza zza2 = this.zzc(jSONObject);
            zzcn.zza zza3 = this.zza(zzah2, zza2, jSONObject);
            zzhe zzhe2 = this.zza(zza3);
            return zzhe2;
        }
        catch (CancellationException cancellationException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (JSONException jSONException) {
            zzhx.zzd("Malformed native JSON response.", jSONException);
        }
        catch (TimeoutException timeoutException) {
            zzhx.zzd("Timeout when loading native ad.", timeoutException);
        }
        if (!this.zzwX) {
            this.zzx(0);
        }
        return this.zza(null);
    }

    private zzah zzdN() throws CancellationException, ExecutionException, InterruptedException, TimeoutException {
        if (this.zzdO()) {
            return null;
        }
        zzah zzah2 = this.zzwW.zza(this.mContext, this.zzvN.zzyy.zzlP, "https://googleads.g.doubleclick.net/mads/static/mad/sdk/native/native_ads.html").get();
        zzah2.zza(this.zzrv, this.zzrv, this.zzrv, this.zzrv, false, this.zzrv, this.zzrv, null, this.zzrv);
        return zzah2;
    }

    private JSONObject zzc(final zzah zzah2) throws TimeoutException, JSONException {
        zzcv zzcv2;
        if (this.zzdO()) {
            return null;
        }
        final zzhq zzhq2 = new zzhq();
        final zzb zzb2 = new zzb();
        zzb2.zzxe = zzcv2 = new zzcv(){

            @Override
            public void zza(zzic zzic2, Map<String, String> map) {
                zzah2.zzb("/nativeAdPreProcess", zzb2.zzxe);
                try {
                    String string2 = map.get("success");
                    if (!TextUtils.isEmpty((CharSequence)string2)) {
                        zzhq2.zzb(new JSONObject(string2).getJSONArray("ads").getJSONObject(0));
                        return;
                    }
                }
                catch (JSONException jSONException) {
                    zzhx.zzb("Malformed native JSON response.", jSONException);
                }
                zzgt.this.zzx(0);
                zzx.zza((boolean)zzgt.this.zzdO(), (Object)"Unable to set the ad state error!");
                zzhq2.zzb(null);
            }
        };
        zzah2.zza("/nativeAdPreProcess", zzcv2);
        JSONObject jSONObject = new JSONObject(this.zzvN.zzyz.zzwG);
        zzah2.zza("google.afma.nativeAds.preProcessJsonGmsg", jSONObject);
        return (JSONObject)zzhq2.get();
    }

    protected zza zzc(JSONObject jSONObject) throws JSONException {
        if (this.zzdO()) {
            return null;
        }
        String string2 = jSONObject.getString("template_id");
        if ("2".equals(string2)) {
            return new zzgu();
        }
        if ("1".equals(string2)) {
            return new zzgv();
        }
        this.zzx(0);
        return null;
    }

    private zzcn.zza zza(zzah zzah2, zza zza2, JSONObject jSONObject) throws ExecutionException, InterruptedException, JSONException {
        if (this.zzdO()) {
            return null;
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject("tracking_urls_and_actions");
        String[] stringArray = this.zzb(jSONObject2, "impression_tracking_urls");
        this.zzwY = stringArray == null ? null : Arrays.asList(stringArray);
        Object t = zza2.zza(this, jSONObject);
        if (t == null) {
            zzhx.zzZ("Failed to retrieve ad assets.");
            return null;
        }
        t.zza(new zzcn(this.zzrv, zzah2, jSONObject));
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzhe zza(zzcn.zza zza2) {
        int n;
        Object object = this.zznh;
        synchronized (object) {
            n = this.zzvR;
            if (zza2 == null && this.zzvR == -2) {
                n = 0;
            }
        }
        if (n != -2) {
            zza2 = null;
        }
        return new zzhe(this.zzvN.zzyy.zzwn, null, this.zzvN.zzyz.zzst, n, this.zzvN.zzyz.zzsu, this.zzwY, this.zzvN.zzyz.orientation, this.zzvN.zzyz.zzsx, this.zzvN.zzyy.zzwq, false, null, null, null, null, null, 0L, this.zzvN.zzlV, this.zzvN.zzyz.zzwH, this.zzvN.zzyv, this.zzvN.zzyw, this.zzvN.zzyz.zzwN, this.zzvN.zzys, zza2, this.zzvN.zzyy.zzwD);
    }

    public Future<Drawable> zza(JSONObject jSONObject, String string2, final boolean bl) throws JSONException {
        String string3;
        JSONObject jSONObject2 = bl ? jSONObject.getJSONObject(string2) : jSONObject.optJSONObject(string2);
        jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
        String string4 = string3 = bl ? jSONObject2.getString("url") : jSONObject2.optString("url");
        if (TextUtils.isEmpty((CharSequence)string3)) {
            this.zza(0, bl);
            return new zzhr<Object>(null);
        }
        return this.zzwV.zza(string3, new zzht.zza<Drawable>(){

            public Drawable zzdP() {
                zzgt.this.zza(2, bl);
                return null;
            }

            public Drawable zza(InputStream inputStream) {
                byte[] byArray = null;
                try {
                    byArray = zzlz.zzd((InputStream)inputStream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (byArray == null) {
                    zzgt.this.zza(2, bl);
                    return null;
                }
                Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
                if (bitmap == null) {
                    zzgt.this.zza(2, bl);
                    return null;
                }
                return new BitmapDrawable(Resources.getSystem(), bitmap);
            }

            @Override
            public /* synthetic */ Object zzdQ() {
                return this.zzdP();
            }

            @Override
            public /* synthetic */ Object zzb(InputStream inputStream) {
                return this.zza(inputStream);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzdO() {
        Object object = this.zznh;
        synchronized (object) {
            return this.zzwX;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzx(int n) {
        Object object = this.zznh;
        synchronized (object) {
            this.zzwX = true;
            this.zzvR = n;
        }
    }

    public void zza(int n, boolean bl) {
        if (bl) {
            this.zzx(n);
        }
    }

    private String[] zzb(JSONObject jSONObject, String string2) throws JSONException {
        JSONArray jSONArray = jSONObject.optJSONArray(string2);
        if (jSONArray == null) {
            return null;
        }
        String[] stringArray = new String[jSONArray.length()];
        for (int i = 0; i < jSONArray.length(); ++i) {
            stringArray[i] = jSONArray.getString(i);
        }
        return stringArray;
    }

    @Override
    public /* synthetic */ Object call() throws Exception {
        return this.zzdM();
    }

    class zzb {
        public zzcv zzxe;

        zzb() {
        }
    }

    public static interface zza<T extends zzcn.zza> {
        public T zza(zzgt var1, JSONObject var2) throws JSONException, InterruptedException, ExecutionException;
    }
}

