/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.internal.zzab;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzba;
import com.google.android.gms.internal.zzdk;
import com.google.android.gms.internal.zzg;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzgj;
import com.google.android.gms.internal.zzgl;
import com.google.android.gms.internal.zzgo;
import com.google.android.gms.internal.zzgq;
import com.google.android.gms.internal.zzhe;
import com.google.android.gms.internal.zzhl;
import com.google.android.gms.internal.zzhw;
import com.google.android.gms.internal.zzhx;
import com.google.android.gms.internal.zzk;
import com.google.android.gms.internal.zzz;
import org.json.JSONException;
import org.json.JSONObject;

@zzgi
public class zzgk
extends zzhl
implements zzgl.zza {
    private final zzgj.zza zzwe;
    private final zzgo.zza zzwf;
    private final Object zzvM = new Object();
    private final Context mContext;
    private final zzk zzwg;
    zzhl zzwh;
    Object zznh = new Object();
    zzgq zzvO;
    zzdk zzsf;

    public zzgk(Context context, zzgo.zza zza2, zzk zzk2, zzgj.zza zza3) {
        this.zzwe = zza3;
        this.mContext = context;
        this.zzwf = zza2;
        this.zzwg = zzk2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(zzgq zzgq2) {
        Object object = this.zznh;
        synchronized (object) {
            zzhx.zzY("Received ad response.");
            this.zzvO = zzgq2;
            this.zznh.notify();
        }
    }

    zzhl zza(zzgo zzgo2) {
        return zzgl.zza(this.mContext, zzgo2, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzdw() {
        Object object = this.zznh;
        synchronized (object) {
            zzhx.zzY("AdLoaderBackgroundTask started.");
            zzg zzg2 = this.zzwg.zzC();
            String string2 = zzg2.zza(this.mContext);
            zzz zzz2 = zzz.zzj(this.mContext);
            String string3 = zzz2.getClientId();
            zzgo zzgo2 = new zzgo(this.zzwf, string2, string3);
            zzba zzba2 = null;
            int n = -2;
            long l = -1L;
            try {
                long l2 = zzab.zzaQ().elapsedRealtime();
                zzhl zzhl2 = this.zza(zzgo2);
                Object object2 = this.zzvM;
                synchronized (object2) {
                    this.zzwh = zzhl2;
                    if (this.zzwh == null) {
                        throw new zza("Could not start the ad request service.", 0);
                    }
                }
                this.zzh(l2);
                l = zzab.zzaQ().elapsedRealtime();
                this.zzdI();
                if (zzgo2.zzlV.zzpc != null) {
                    zzba2 = this.zzb(zzgo2);
                }
                this.zzv(this.zzvO.zzwT);
            }
            catch (zza zza2) {
                n = zza2.getErrorCode();
                if (n == 3 || n == -1) {
                    zzhx.zzaa(zza2.getMessage());
                } else {
                    zzhx.zzac(zza2.getMessage());
                }
                this.zzvO = this.zzvO == null ? new zzgq(n) : new zzgq(n, this.zzvO.zzsx);
                zzhw.zzzG.post(new Runnable(){

                    @Override
                    public void run() {
                        zzgk.this.onStop();
                    }
                });
            }
            JSONObject jSONObject = null;
            if (!TextUtils.isEmpty((CharSequence)this.zzvO.zzwQ)) {
                try {
                    jSONObject = new JSONObject(this.zzvO.zzwQ);
                }
                catch (Exception exception) {
                    zzhx.zzb("Error parsing the JSON for Active View.", exception);
                }
            }
            final zzhe.zza zza3 = new zzhe.zza(zzgo2, this.zzvO, this.zzsf, zzba2, n, l, this.zzvO.zzwM, jSONObject);
            zzhw.zzzG.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = zzgk.this.zznh;
                    synchronized (object) {
                        zzgk.this.zzwe.zza(zza3);
                    }
                }
            });
        }
    }

    protected void zzv(boolean bl) {
        zzab.zzaP().zzz(bl);
        zzan zzan2 = zzab.zzaP().zzo(this.mContext);
        if (zzan2 != null && !zzan2.isAlive()) {
            zzhx.zzY("start fetching content...");
            zzan2.zzbt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzvM;
        synchronized (object) {
            if (this.zzwh != null) {
                this.zzwh.cancel();
            }
        }
    }

    protected void zzdI() throws zza {
        if (this.zzvO.errorCode == -3) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.zzvO.zzwG)) {
            throw new zza("No fill from ad server.", 3);
        }
        zzab.zzaP().zza(this.mContext, this.zzvO.zzwv);
        if (this.zzvO.zzwI) {
            try {
                this.zzsf = new zzdk(this.zzvO.zzwG);
            }
            catch (JSONException jSONException) {
                throw new zza("Could not parse mediation config: " + this.zzvO.zzwG, 0);
            }
        }
    }

    protected zzba zzb(zzgo zzgo2) throws zza {
        int n;
        int n2;
        if (this.zzvO.zzwL == null) {
            throw new zza("The ad response must specify one of the supported ad sizes.", 0);
        }
        String[] stringArray = this.zzvO.zzwL.split("x");
        if (stringArray.length != 2) {
            throw new zza("Invalid ad size format from the ad response: " + this.zzvO.zzwL, 0);
        }
        try {
            n2 = Integer.parseInt(stringArray[0]);
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new zza("Invalid ad size number from the ad response: " + this.zzvO.zzwL, 0);
        }
        for (zzba zzba2 : zzgo2.zzlV.zzpc) {
            int n3;
            float f = this.mContext.getResources().getDisplayMetrics().density;
            int n4 = zzba2.width == -1 ? (int)((float)zzba2.widthPixels / f) : zzba2.width;
            int n5 = n3 = zzba2.height == -2 ? (int)((float)zzba2.heightPixels / f) : zzba2.height;
            if (n2 != n4 || n != n3) continue;
            return new zzba(zzba2, zzgo2.zzlV.zzpc);
        }
        throw new zza("The ad size from the ad response was not one of the requested sizes: " + this.zzvO.zzwL, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzh(long l) throws zza {
        do {
            if (this.zzd(l)) continue;
            throw new zza("Timed out waiting for ad response.", 2);
        } while (this.zzvO == null);
        Object object = this.zzvM;
        synchronized (object) {
            this.zzwh = null;
        }
        if (this.zzvO.errorCode != -2 && this.zzvO.errorCode != -3) {
            throw new zza("There was a problem getting an ad response. ErrorCode: " + this.zzvO.errorCode, this.zzvO.errorCode);
        }
    }

    protected boolean zzd(long l) throws zza {
        long l2 = 60000L - (zzab.zzaQ().elapsedRealtime() - l);
        if (l2 <= 0L) {
            return false;
        }
        try {
            this.zznh.wait(l2);
        }
        catch (InterruptedException interruptedException) {
            throw new zza("Ad request cancelled.", -1);
        }
        return true;
    }

    @zzgi
    static final class zza
    extends Exception {
        private final int zzvR;

        public zza(String string2, int n) {
            super(string2);
            this.zzvR = n;
        }

        public int getErrorCode() {
            return this.zzvR;
        }
    }
}

