/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import com.google.android.gms.internal.zzab;
import com.google.android.gms.internal.zzca;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzhx;
import com.google.android.gms.internal.zzhy;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedList;

@zzgi
public class zzgh
implements Thread.UncaughtExceptionHandler {
    private Thread.UncaughtExceptionHandler zzwb;
    private Thread.UncaughtExceptionHandler zzwc;
    private Context mContext;
    private zzhy zzwd;

    public static zzgh zza(Context context, Thread thread, zzhy zzhy2) {
        if (context == null || thread == null || zzhy2 == null) {
            return null;
        }
        if (!zzgh.zzn(context)) {
            return null;
        }
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = thread.getUncaughtExceptionHandler();
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler2 = thread.getDefaultUncaughtExceptionHandler();
        zzgh zzgh2 = new zzgh(context, zzhy2, uncaughtExceptionHandler, uncaughtExceptionHandler2);
        if (uncaughtExceptionHandler == null || !(uncaughtExceptionHandler instanceof zzgh)) {
            try {
                thread.setUncaughtExceptionHandler(zzgh2);
                return zzgh2;
            }
            catch (SecurityException securityException) {
                zzhx.zzc("Fail to set UncaughtExceptionHandler.", securityException);
            }
        } else {
            return (zzgh)uncaughtExceptionHandler;
        }
        return null;
    }

    private static boolean zzn(Context context) {
        return zzca.zzqo.get();
    }

    public zzgh(Context context, zzhy zzhy2, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Thread.UncaughtExceptionHandler uncaughtExceptionHandler2) {
        this.zzwb = uncaughtExceptionHandler;
        this.zzwc = uncaughtExceptionHandler2;
        this.mContext = context;
        this.zzwd = zzhy2;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable exception) {
        if (this.zza(exception)) {
            this.zzb(exception);
            if (Looper.getMainLooper().getThread() != thread) {
                return;
            }
        }
        if (this.zzwb != null) {
            this.zzwb.uncaughtException(thread, exception);
        } else if (this.zzwc != null) {
            this.zzwc.uncaughtException(thread, exception);
        }
    }

    protected boolean zza(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        while (throwable != null) {
            StackTraceElement[] stackTraceElementArray;
            for (StackTraceElement stackTraceElement : stackTraceElementArray = throwable.getStackTrace()) {
                if (this.zzO(stackTraceElement.getClassName())) {
                    bl = true;
                }
                if (!this.getClass().getName().equals(stackTraceElement.getClassName())) continue;
                bl2 = true;
            }
            throwable = throwable.getCause();
        }
        return bl && !bl2;
    }

    protected boolean zzO(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        if (string2.startsWith("com.google.android.gms.ads")) {
            return true;
        }
        if (string2.startsWith("com.google.ads")) {
            return true;
        }
        try {
            Class<?> clazz = Class.forName(string2);
            return clazz.isAnnotationPresent(zzgi.class);
        }
        catch (Exception exception) {
            zzhx.zza("Fail to check class type for class " + string2, exception);
            return false;
        }
    }

    protected boolean zzP(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        return string2.startsWith("android.") || string2.startsWith("java.");
    }

    public void zzb(Throwable throwable) {
        if (!zzgh.zzn(this.mContext)) {
            return;
        }
        Throwable throwable2 = this.zzd(throwable);
        if (throwable2 == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.zzc(throwable2));
        zzab.zzaM().zza(this.mContext, this.zzwd.zzzH, arrayList, zzab.zzaP().zzej());
    }

    protected String zzc(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        Uri.Builder builder = new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("id", "gmob-apps-report-exception").appendQueryParameter("os", Build.VERSION.RELEASE).appendQueryParameter("api", String.valueOf(Build.VERSION.SDK_INT)).appendQueryParameter("device", zzab.zzaM().zzev()).appendQueryParameter("js", this.zzwd.zzzH).appendQueryParameter("appid", this.mContext.getApplicationContext().getPackageName()).appendQueryParameter("stacktrace", stringWriter.toString()).appendQueryParameter("eids", TextUtils.join((CharSequence)",", zzca.zzcb()));
        return builder.toString();
    }

    private Throwable zzd(Throwable throwable) {
        Throwable throwable2;
        if (zzca.zzqp.get().booleanValue()) {
            return throwable;
        }
        LinkedList<Throwable> linkedList = new LinkedList<Throwable>();
        for (throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            linkedList.push(throwable2);
        }
        Throwable throwable3 = null;
        while (!linkedList.isEmpty()) {
            throwable2 = (Throwable)linkedList.pop();
            StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
            ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>();
            arrayList.add(new StackTraceElement(throwable2.getClass().getName(), "<filtered>", "<filtered>", 1));
            boolean bl = false;
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (this.zzO(stackTraceElement.getClassName())) {
                    bl = true;
                    arrayList.add(stackTraceElement);
                    continue;
                }
                if (this.zzP(stackTraceElement.getClassName())) {
                    arrayList.add(stackTraceElement);
                    continue;
                }
                StackTraceElement stackTraceElement2 = new StackTraceElement("<filtered>", "<filtered>", "<filtered>", 1);
                arrayList.add(stackTraceElement2);
            }
            if (!bl) continue;
            throwable3 = throwable3 == null ? new Throwable(throwable2.getMessage()) : new Throwable(throwable2.getMessage(), throwable3);
            throwable3.setStackTrace(arrayList.toArray(new StackTraceElement[0]));
        }
        return throwable3;
    }
}

