/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.google.android.gms.internal.zzfb;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzhx;
import org.json.JSONException;
import org.json.JSONObject;

@zzgi
public class zzfj {
    public int zzd(Intent intent) {
        Object object = intent.getExtras().get("RESPONSE_CODE");
        if (object == null) {
            zzhx.zzac("Intent with no response code, assuming OK (known issue)");
            return 0;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Long) {
            return (int)((Long)object).longValue();
        }
        zzhx.zzac("Unexpected type for intent response code. " + object.getClass().getName());
        return 5;
    }

    public int zzf(Bundle bundle) {
        Object object = bundle.get("RESPONSE_CODE");
        if (object == null) {
            zzhx.zzac("Bundle with null response code, assuming OK (known issue)");
            return 0;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Long) {
            return (int)((Long)object).longValue();
        }
        zzhx.zzac("Unexpected type for intent response code. " + object.getClass().getName());
        return 5;
    }

    public String zze(Intent intent) {
        if (intent == null) {
            return null;
        }
        return intent.getStringExtra("INAPP_PURCHASE_DATA");
    }

    public String zzf(Intent intent) {
        if (intent == null) {
            return null;
        }
        return intent.getStringExtra("INAPP_DATA_SIGNATURE");
    }

    public String zzL(String string2) {
        if (string2 == null) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            return jSONObject.getString("developerPayload");
        }
        catch (JSONException jSONException) {
            zzhx.zzac("Fail to parse purchase data");
            return null;
        }
    }

    public String zzM(String string2) {
        if (string2 == null) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            return jSONObject.getString("purchaseToken");
        }
        catch (JSONException jSONException) {
            zzhx.zzac("Fail to parse purchase data");
            return null;
        }
    }

    public void zza(Context context, boolean bl, zzfb zzfb2) {
        Intent intent = new Intent();
        intent.setClassName(context, "com.google.android.gms.ads.purchase.InAppPurchaseActivity");
        intent.putExtra("com.google.android.gms.ads.internal.purchase.useClientJar", bl);
        zzfb.zza(intent, zzfb2);
        context.startActivity(intent);
    }
}

