/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.SystemClock;
import com.google.android.gms.internal.zzab;
import com.google.android.gms.internal.zzfn;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzhx;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

@zzgi
public class zzfe
extends zzfn.zza {
    private String zznf;
    private Context mContext;
    private String zzvf;
    private ArrayList<String> zzvg;

    public zzfe(String string2, ArrayList<String> arrayList, Context context, String string3) {
        this.zzvf = string2;
        this.zzvg = arrayList;
        this.zznf = string3;
        this.mContext = context;
    }

    @Override
    public String getProductId() {
        return this.zzvf;
    }

    protected int zzs(int n) {
        if (n == 0) {
            return 1;
        }
        if (n == 1) {
            return 2;
        }
        if (n == 4) {
            return 3;
        }
        return 0;
    }

    protected String zza(String string2, HashMap<String, String> hashMap) {
        String string3 = this.mContext.getPackageName();
        String string4 = "";
        try {
            string4 = this.mContext.getPackageManager().getPackageInfo((String)string3, (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            zzhx.zzd("Error to retrieve app version", nameNotFoundException);
        }
        long l = zzab.zzaP().zzef().zzeo();
        long l2 = SystemClock.elapsedRealtime() - l;
        for (String string5 : hashMap.keySet()) {
            string2 = string2.replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", string5), String.format("$1%s$2", hashMap.get(string5)));
        }
        return string2.replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", "sessionid"), String.format("$1%s$2", zzab.zzaP().getSessionId())).replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", "appid"), String.format("$1%s$2", string3)).replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", "osversion"), String.format("$1%s$2", String.valueOf(Build.VERSION.SDK_INT))).replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", "sdkversion"), String.format("$1%s$2", this.zznf)).replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", "appversion"), String.format("$1%s$2", string4)).replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", "timestamp"), String.format("$1%s$2", String.valueOf(l2))).replaceAll(String.format("(?<!@)((?:@@)*)@%s(?<!@)((?:@@)*)@", "[^@]+"), String.format("$1%s$2", "")).replaceAll("@@", "@");
    }

    @Override
    public void recordResolution(int resolution) {
        if (resolution == 1) {
            this.zzdy();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("status", String.valueOf(resolution));
        hashMap.put("sku", this.zzvf);
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string2 : this.zzvg) {
            linkedList.add(this.zza(string2, hashMap));
        }
        zzab.zzaM().zza(this.mContext, this.zznf, linkedList);
    }

    @Override
    public void recordPlayBillingResolution(int billingResponseCode) {
        if (billingResponseCode == 0) {
            this.zzdy();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("google_play_status", String.valueOf(billingResponseCode));
        hashMap.put("sku", this.zzvf);
        hashMap.put("status", String.valueOf(this.zzs(billingResponseCode)));
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string2 : this.zzvg) {
            linkedList.add(this.zza(string2, hashMap));
        }
        zzab.zzaM().zza(this.mContext, this.zznf, linkedList);
    }

    void zzdy() {
        try {
            Class<?> clazz = this.mContext.getClassLoader().loadClass("com.google.ads.conversiontracking.IAPConversionReporter");
            Method method = clazz.getDeclaredMethod("reportWithProductId", Context.class, String.class, String.class, Boolean.TYPE);
            method.invoke(null, this.mContext, this.zzvf, "", true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            zzhx.zzac("Google Conversion Tracking SDK 1.2.0 or above is required to report a conversion.");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            zzhx.zzac("Google Conversion Tracking SDK 1.2.0 or above is required to report a conversion.");
        }
        catch (Exception exception) {
            zzhx.zzd("Fail to report a conversion.", exception);
        }
    }
}

