/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import com.google.android.gms.internal.zzab;
import com.google.android.gms.internal.zzfc;
import com.google.android.gms.internal.zzfg;
import com.google.android.gms.internal.zzfh;
import com.google.android.gms.internal.zzfi;
import com.google.android.gms.internal.zzfl;
import com.google.android.gms.internal.zzfs;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzhl;
import com.google.android.gms.internal.zzhw;
import com.google.android.gms.internal.zzhx;
import com.google.android.gms.internal.zzlo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@zzgi
public class zzfd
extends zzhl
implements ServiceConnection {
    private final Object zznh = new Object();
    private boolean zzuW = false;
    private Context mContext;
    private zzfs zzuX;
    private zzfc zzuY;
    private zzfi zzuZ;
    private List<zzfg> zzva = null;
    private zzfl zzvb;

    public zzfd(Context context, zzfs zzfs2, zzfl zzfl2) {
        this(context, zzfs2, zzfl2, new zzfc(context), zzfi.zzm(context.getApplicationContext()));
    }

    zzfd(Context context, zzfs zzfs2, zzfl zzfl2, zzfc zzfc2, zzfi zzfi2) {
        this.mContext = context;
        this.zzuX = zzfs2;
        this.zzvb = zzfl2;
        this.zzuY = zzfc2;
        this.zzuZ = zzfi2;
        this.zzva = this.zzuZ.zze(10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzdw() {
        Object object = this.zznh;
        synchronized (object) {
            Intent intent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
            intent.setPackage("com.android.vending");
            zzlo.zzka().zza(this.mContext, intent, (ServiceConnection)this, 1);
            this.zzc(SystemClock.elapsedRealtime());
            zzlo.zzka().zza(this.mContext, (ServiceConnection)this);
            this.zzuY.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zznh;
        synchronized (object) {
            zzlo.zzka().zza(this.mContext, (ServiceConnection)this);
            this.zzuY.destroy();
        }
    }

    public void onServiceDisconnected(ComponentName name) {
        zzhx.zzaa("In-app billing service disconnected.");
        this.zzuY.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceConnected(ComponentName name, IBinder service) {
        Object object = this.zznh;
        synchronized (object) {
            this.zzuY.zzx(service);
            this.zzdx();
            this.zzuW = true;
            this.zznh.notify();
        }
    }

    protected void zzdx() {
        int n;
        Bundle bundle;
        if (this.zzva.isEmpty()) {
            return;
        }
        HashMap<String, zzfg> hashMap = new HashMap<String, zzfg>();
        for (zzfg object2 : this.zzva) {
            hashMap.put(object2.zzvo, object2);
        }
        Object object3 = null;
        while ((bundle = this.zzuY.zzh(this.mContext.getPackageName(), (String)object3)) != null && (n = zzab.zzaU().zzf(bundle)) == 0) {
            ArrayList arrayList = bundle.getStringArrayList("INAPP_PURCHASE_ITEM_LIST");
            ArrayList arrayList2 = bundle.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
            ArrayList arrayList3 = bundle.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
            object3 = bundle.getString("INAPP_CONTINUATION_TOKEN");
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!hashMap.containsKey(arrayList.get(i))) continue;
                String string2 = (String)arrayList.get(i);
                String string3 = (String)arrayList2.get(i);
                String string4 = (String)arrayList3.get(i);
                zzfg zzfg2 = (zzfg)hashMap.get(string2);
                String string5 = zzab.zzaU().zzL(string3);
                if (!zzfg2.zzvn.equals(string5)) continue;
                this.zza(zzfg2, string3, string4);
                hashMap.remove(string2);
            }
            if (object3 != null && !hashMap.isEmpty()) continue;
        }
        for (String string6 : hashMap.keySet()) {
            this.zzuZ.zza((zzfg)hashMap.get(string6));
        }
    }

    protected void zza(final zzfg zzfg2, String string2, String string3) {
        final Intent intent = new Intent();
        zzab.zzaU();
        intent.putExtra("RESPONSE_CODE", 0);
        zzab.zzaU();
        intent.putExtra("INAPP_PURCHASE_DATA", string2);
        zzab.zzaU();
        intent.putExtra("INAPP_DATA_SIGNATURE", string3);
        zzhw.zzzG.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (zzfd.this.zzvb.zza(zzfg2.zzvn, -1, intent)) {
                        zzfd.this.zzuX.zza(new zzfh(zzfd.this.mContext, zzfg2.zzvo, true, -1, intent, zzfg2));
                    } else {
                        zzfd.this.zzuX.zza(new zzfh(zzfd.this.mContext, zzfg2.zzvo, false, -1, intent, zzfg2));
                    }
                }
                catch (RemoteException remoteException) {
                    zzhx.zzac("Fail to verify and dispatch pending transaction");
                }
            }
        });
    }

    private void zzc(long l) {
        do {
            if (this.zzd(l)) continue;
            zzhx.zzab("Timeout waiting for pending transaction to be processed.");
        } while (!this.zzuW);
    }

    private boolean zzd(long l) {
        long l2 = 60000L - (SystemClock.elapsedRealtime() - l);
        if (l2 <= 0L) {
            return false;
        }
        try {
            this.zznh.wait(l2);
        }
        catch (InterruptedException interruptedException) {
            zzhx.zzac("waitWithTimeout_lock interrupted");
        }
        return true;
    }
}

