/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.media.MediaPlayer;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.MediaController;
import android.widget.VideoView;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzhw;
import com.google.android.gms.internal.zzic;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

@zzgi
public class zzeq
extends FrameLayout
implements MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnPreparedListener {
    private final zzic zzmu;
    private final MediaController zzuA;
    private final zza zzuB;
    private final VideoView zzuC;
    private long zzuD;
    private String zzuE;

    public static void zza(zzic zzic2, String string2, String string3) {
        boolean bl = string3 == null;
        HashMap<String, String> hashMap = new HashMap<String, String>(bl ? 2 : 3);
        hashMap.put("what", string2);
        if (!bl) {
            hashMap.put("extra", string3);
        }
        zzeq.zza(zzic2, "error", hashMap);
    }

    private static void zza(zzic zzic2, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        zzeq.zza(zzic2, string2, hashMap);
    }

    private static void zza(zzic zzic2, String string2, String string3, String string4) {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put(string3, string4);
        zzeq.zza(zzic2, string2, hashMap);
    }

    private static void zza(zzic zzic2, String string2, Map<String, String> map) {
        map.put("event", string2);
        zzic2.zzb("onVideoEvent", map);
    }

    public zzeq(Context context, zzic zzic2) {
        super(context);
        this.zzmu = zzic2;
        this.zzuC = new VideoView(context);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1, 17);
        this.addView((View)this.zzuC, (ViewGroup.LayoutParams)layoutParams);
        this.zzuA = new MediaController(context);
        this.zzuB = new zza(this);
        this.zzuB.zzdq();
        this.zzuC.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        this.zzuC.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        this.zzuC.setOnErrorListener((MediaPlayer.OnErrorListener)this);
    }

    public void destroy() {
        this.zzuB.cancel();
        this.zzuC.stopPlayback();
    }

    public void zzdo() {
        if (!TextUtils.isEmpty((CharSequence)this.zzuE)) {
            this.zzuC.setVideoPath(this.zzuE);
        } else {
            zzeq.zza(this.zzmu, "no_src", null);
        }
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        zzeq.zza(this.zzmu, "ended");
    }

    public boolean onError(MediaPlayer mediaPlayer, int what, int extra) {
        zzeq.zza(this.zzmu, String.valueOf(what), String.valueOf(extra));
        return true;
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        float f = (float)this.zzuC.getDuration() / 1000.0f;
        zzeq.zza(this.zzmu, "canplaythrough", "duration", String.valueOf(f));
    }

    public void pause() {
        this.zzuC.pause();
    }

    public void play() {
        this.zzuC.start();
    }

    public void seekTo(int timeInMilliseconds) {
        this.zzuC.seekTo(timeInMilliseconds);
    }

    public void zzb(MotionEvent motionEvent) {
        this.zzuC.dispatchTouchEvent(motionEvent);
    }

    public void zzu(boolean bl) {
        if (bl) {
            this.zzuC.setMediaController(this.zzuA);
        } else {
            this.zzuA.hide();
            this.zzuC.setMediaController(null);
        }
    }

    public void zzK(String string2) {
        this.zzuE = string2;
    }

    public void zzdp() {
        long l = this.zzuC.getCurrentPosition();
        if (this.zzuD != l) {
            float f = (float)l / 1000.0f;
            zzeq.zza(this.zzmu, "timeupdate", "time", String.valueOf(f));
            this.zzuD = l;
        }
    }

    private static final class zza {
        private final Runnable zzmG;
        private volatile boolean zzuF = false;

        public zza(final zzeq zzeq2) {
            this.zzmG = new Runnable(){
                private final WeakReference<zzeq> zzuG;
                {
                    this.zzuG = new WeakReference<zzeq>(zzeq2);
                }

                @Override
                public void run() {
                    zzeq zzeq22 = (zzeq)((Object)this.zzuG.get());
                    if (!zza.this.zzuF && zzeq22 != null) {
                        zzeq22.zzdp();
                        zza.this.zzdq();
                    }
                }
            };
        }

        public void cancel() {
            this.zzuF = true;
            zzhw.zzzG.removeCallbacks(this.zzmG);
        }

        public void zzdq() {
            zzhw.zzzG.postDelayed(this.zzmG, 250L);
        }
    }
}

