/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.android.gms.internal.zzab;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzeq;
import com.google.android.gms.internal.zzer;
import com.google.android.gms.internal.zzet;
import com.google.android.gms.internal.zzev;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzhs;
import com.google.android.gms.internal.zzhx;
import com.google.android.gms.internal.zzic;
import com.google.android.gms.internal.zzid;

@zzgi
public class zzel
extends zzev.zza
implements zzet {
    static final int zztV = Color.argb((int)0, (int)0, (int)0, (int)0);
    private final Activity zzoi;
    zzeo zztW;
    zzeq zztX;
    zzic zzmu;
    zzc zztY;
    zzer zztZ;
    boolean zzua = false;
    FrameLayout zzub;
    WebChromeClient.CustomViewCallback zzuc;
    boolean zzud = false;
    boolean zzue = false;
    RelativeLayout zzts;
    boolean zzuf = false;
    int zzug = 0;
    private boolean zzuh;
    private boolean zzui = false;
    private boolean zzuj = true;

    static RelativeLayout.LayoutParams zzd(int n, int n2, int n3, int n4) {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(n3, n4);
        layoutParams.setMargins(n, n2, 0, 0);
        layoutParams.addRule(10);
        layoutParams.addRule(9);
        return layoutParams;
    }

    public zzel(Activity activity) {
        this.zzoi = activity;
    }

    public void close() {
        this.zzug = 2;
        this.zzoi.finish();
    }

    public zzeq zzdb() {
        return this.zztX;
    }

    public void zzdc() {
        if (this.zztW != null && this.zzua) {
            this.setRequestedOrientation(this.zztW.orientation);
        }
        if (this.zzub != null) {
            this.zzoi.setContentView((View)this.zzts);
            this.zzX();
            this.zzub.removeAllViews();
            this.zzub = null;
        }
        if (this.zzuc != null) {
            this.zzuc.onCustomViewHidden();
            this.zzuc = null;
        }
        this.zzua = false;
    }

    public void zze(int n, int n2, int n3, int n4) {
        if (this.zztX != null) {
            this.zztX.setLayoutParams((ViewGroup.LayoutParams)zzel.zzd(n, n2, n3, n4));
        }
    }

    public void zzf(int n, int n2, int n3, int n4) {
        if (this.zztX == null) {
            this.zztX = new zzeq((Context)this.zzoi, this.zzmu);
            this.zzts.addView((View)this.zztX, 0, (ViewGroup.LayoutParams)zzel.zzd(n, n2, n3, n4));
            this.zzmu.zzeG().zzC(false);
        }
    }

    @Override
    public void zzdd() {
        this.zzug = 1;
        this.zzoi.finish();
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        this.zzud = savedInstanceState != null ? savedInstanceState.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false) : false;
        try {
            this.zztW = zzeo.zzb(this.zzoi.getIntent());
            if (this.zztW == null) {
                throw new zza("Could not get info for ad overlay.");
            }
            if (this.zzoi.getIntent() != null) {
                this.zzuj = this.zzoi.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzue = this.zztW.zzuz != null ? this.zztW.zzuz.zzml : false;
            if (savedInstanceState == null) {
                if (this.zztW.zzup != null && this.zzuj) {
                    this.zztW.zzup.zzag();
                }
                if (this.zztW.zzuw != 1 && this.zztW.zzuo != null) {
                    this.zztW.zzuo.onAdClicked();
                }
            }
            this.zzts = new zzb((Context)this.zzoi, this.zztW.zzuy);
            switch (this.zztW.zzuw) {
                case 1: {
                    this.zzt(false);
                    break;
                }
                case 2: {
                    this.zztY = new zzc(this.zztW.zzuq);
                    this.zzt(false);
                    break;
                }
                case 3: {
                    this.zzt(true);
                    break;
                }
                case 4: {
                    if (this.zzud) {
                        this.zzug = 3;
                        this.zzoi.finish();
                        break;
                    }
                    if (!zzab.zzaJ().zza((Context)this.zzoi, this.zztW.zzun, this.zztW.zzuv)) {
                        this.zzug = 3;
                        this.zzoi.finish();
                    }
                    break;
                }
                default: {
                    throw new zza("Could not determine ad overlay type.");
                }
            }
        }
        catch (zza zza2) {
            zzhx.zzac(zza2.getMessage());
            this.zzug = 3;
            this.zzoi.finish();
        }
    }

    @Override
    public void onRestart() {
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onResume() {
        if (this.zztW != null && this.zztW.zzuw == 4) {
            if (this.zzud) {
                this.zzug = 3;
                this.zzoi.finish();
            } else {
                this.zzud = true;
            }
        }
        if (this.zzmu != null && !this.zzmu.isDestroyed()) {
            zzab.zzaO().zzb(this.zzmu.getWebView());
        } else {
            zzhx.zzac("The webview does not exit. Ignoring action.");
        }
    }

    @Override
    public void onPause() {
        if (this.zztX != null) {
            this.zztX.pause();
        }
        this.zzdc();
        if (!(this.zzmu == null || this.zzoi.isFinishing() && this.zztY != null)) {
            zzab.zzaO().zza(this.zzmu.getWebView());
        }
        this.zzdf();
    }

    @Override
    public void onSaveInstanceState(Bundle outBundle) {
        outBundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzud);
    }

    @Override
    public void onStop() {
        this.zzdf();
    }

    @Override
    public void onDestroy() {
        if (this.zztX != null) {
            this.zztX.destroy();
        }
        if (this.zzmu != null) {
            this.zzts.removeView((View)this.zzmu.getWebView());
        }
        this.zzdf();
    }

    public void zzs(boolean bl) {
        int n = bl ? 50 : 32;
        this.zztZ = new zzer((Context)this.zzoi, n, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n2 = bl ? 11 : 9;
        layoutParams.addRule(n2);
        this.zztZ.zza(bl, this.zztW.zzut);
        this.zzts.addView((View)this.zztZ, (ViewGroup.LayoutParams)layoutParams);
    }

    @Override
    public void zzX() {
        this.zzuh = true;
    }

    public void zza(boolean bl, boolean bl2) {
        if (this.zztZ != null) {
            this.zztZ.zza(bl, bl2);
        }
    }

    public void zzde() {
        this.zzts.removeView((View)this.zztZ);
        this.zzs(true);
    }

    public void setRequestedOrientation(int requestedOrientation) {
        this.zzoi.setRequestedOrientation(requestedOrientation);
    }

    public void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzub = new FrameLayout((Context)this.zzoi);
        this.zzub.setBackgroundColor(-16777216);
        this.zzub.addView(view, -1, -1);
        this.zzoi.setContentView((View)this.zzub);
        this.zzX();
        this.zzuc = customViewCallback;
        this.zzua = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void zzt(boolean bl) throws zza {
        Window window;
        if (!this.zzuh) {
            this.zzoi.requestWindowFeature(1);
        }
        if ((window = this.zzoi.getWindow()) == null) {
            throw new zza("Invalid activity, no window available.");
        }
        if (!this.zzue || this.zztW.zzuz != null && this.zztW.zzuz.zzmy) {
            window.setFlags(1024, 1024);
        }
        this.zzuf = false;
        if (this.zztW.orientation == zzab.zzaO().zzex()) {
            this.zzuf = this.zzoi.getResources().getConfiguration().orientation == 1;
        } else if (this.zztW.orientation == zzab.zzaO().zzey()) {
            this.zzuf = this.zzoi.getResources().getConfiguration().orientation == 2;
        }
        zzhx.zzY("Delay onShow to next orientation change: " + this.zzuf);
        this.setRequestedOrientation(this.zztW.orientation);
        if (zzab.zzaO().zza(window)) {
            zzhx.zzY("Hardware acceleration on the AdActivity window enabled.");
        }
        if (!this.zzue) {
            this.zzts.setBackgroundColor(-16777216);
        } else {
            this.zzts.setBackgroundColor(zztV);
        }
        this.zzoi.setContentView((View)this.zzts);
        this.zzX();
        boolean bl2 = this.zztW.zzuq.zzeG().zzba();
        if (bl) {
            this.zzmu = zzab.zzaN().zza((Context)this.zzoi, this.zztW.zzuq.zzad(), true, bl2, null, this.zztW.zzlP);
            this.zzmu.zzeG().zzb(null, null, this.zztW.zzur, this.zztW.zzuv, true, this.zztW.zzux, null, this.zztW.zzuq.zzeG().zzeM(), null);
            this.zzmu.zzeG().zza(new zzid.zza(){

                @Override
                public void zza(zzic zzic2, boolean bl) {
                    zzic2.zzeG().zzeR();
                    zzic2.zzdh();
                }
            });
            if (this.zztW.zztR != null) {
                this.zzmu.loadUrl(this.zztW.zztR);
            } else {
                if (this.zztW.zzuu == null) throw new zza("No URL or HTML to display in ad overlay.");
                this.zzmu.loadDataWithBaseURL(this.zztW.zzus, this.zztW.zzuu, "text/html", "UTF-8", null);
            }
        } else {
            this.zzmu = this.zztW.zzuq;
            this.zzmu.setContext((Context)this.zzoi);
        }
        this.zzmu.zza(this);
        ViewParent viewParent = this.zzmu.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView((View)this.zzmu.getWebView());
        }
        if (this.zzue) {
            this.zzmu.setBackgroundColor(zztV);
        }
        this.zzts.addView((View)this.zzmu.getWebView(), -1, -1);
        if (!bl && !this.zzuf) {
            this.zzdh();
        }
        this.zzs(bl2);
        if (!this.zzmu.zzeH()) return;
        this.zza(bl2, true);
    }

    protected void zzdf() {
        if (!this.zzoi.isFinishing() || this.zzui) {
            return;
        }
        this.zzui = true;
        if (this.zzoi.isFinishing()) {
            if (this.zzmu != null) {
                this.zzp(this.zzug);
                this.zzts.removeView((View)this.zzmu.getWebView());
                if (this.zztY != null) {
                    this.zzmu.setContext(this.zztY.zzlN);
                    this.zzmu.zzA(false);
                    this.zztY.zzum.addView((View)this.zzmu.getWebView(), this.zztY.index, this.zztY.zzul);
                    this.zztY = null;
                }
            }
            if (this.zztW != null && this.zztW.zzup != null) {
                this.zztW.zzup.zzaf();
            }
        }
    }

    public void zzdg() {
        if (this.zzuf) {
            this.zzuf = false;
            this.zzdh();
        }
    }

    protected void zzdh() {
        this.zzmu.zzdh();
    }

    protected void zzp(int n) {
        this.zzmu.zzp(n);
    }

    @zzgi
    static final class zzb
    extends RelativeLayout {
        zzhs zzlL;

        public zzb(Context context, String string2) {
            super(context);
            this.zzlL = new zzhs(context, string2);
        }

        public boolean onInterceptTouchEvent(MotionEvent event) {
            this.zzlL.zzc(event);
            return false;
        }
    }

    @zzgi
    public static class zzc {
        public final int index;
        public final ViewGroup.LayoutParams zzul;
        public final ViewGroup zzum;
        public final Context zzlN;

        public zzc(zzic zzic2) throws zza {
            this.zzul = zzic2.getLayoutParams();
            ViewParent viewParent = zzic2.getParent();
            this.zzlN = zzic2.zzeE();
            if (viewParent == null || !(viewParent instanceof ViewGroup)) {
                throw new zza("Could not get the parent of the WebView for an overlay.");
            }
            this.zzum = (ViewGroup)viewParent;
            this.index = this.zzum.indexOfChild((View)zzic2.getWebView());
            this.zzum.removeView((View)zzic2.getWebView());
            zzic2.zzA(true);
        }
    }

    @zzgi
    private static final class zza
    extends Exception {
        public zza(String string2) {
            super(string2);
        }
    }
}

