/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.internal.zzek;
import com.google.android.gms.internal.zzes;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzhx;

@zzgi
public class zzei {
    public boolean zza(Context context, zzek zzek2, zzes zzes2) {
        String[] stringArray;
        if (zzek2 == null) {
            zzhx.zzac("No intent data for launcher overlay.");
            return false;
        }
        Intent intent = new Intent();
        if (TextUtils.isEmpty((CharSequence)zzek2.zztR)) {
            zzhx.zzac("Open GMSG did not contain a URL.");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)zzek2.mimeType)) {
            intent.setDataAndType(Uri.parse((String)zzek2.zztR), zzek2.mimeType);
        } else {
            intent.setData(Uri.parse((String)zzek2.zztR));
        }
        intent.setAction("android.intent.action.VIEW");
        if (!TextUtils.isEmpty((CharSequence)zzek2.packageName)) {
            intent.setPackage(zzek2.packageName);
        }
        if (!TextUtils.isEmpty((CharSequence)zzek2.zztS)) {
            stringArray = zzek2.zztS.split("/", 2);
            if (stringArray.length < 2) {
                zzhx.zzac("Could not parse component name from open GMSG: " + zzek2.zztS);
                return false;
            }
            intent.setClassName(stringArray[0], stringArray[1]);
        }
        if (!TextUtils.isEmpty((CharSequence)(stringArray = zzek2.zztT))) {
            int n = 0;
            try {
                n = Integer.parseInt((String)stringArray);
            }
            catch (NumberFormatException numberFormatException) {
                zzhx.zzac("Could not parse intent flags.");
            }
            intent.addFlags(n);
        }
        try {
            zzhx.zzab("Launching an intent: " + intent.toURI());
            context.startActivity(intent);
            if (zzes2 != null) {
                zzes2.zzae();
            }
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzhx.zzac(activityNotFoundException.getMessage());
            return false;
        }
        return true;
    }
}

