/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.app.DownloadManager;
import android.content.Context;
import android.content.DialogInterface;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.google.android.gms.R;
import com.google.android.gms.internal.zzab;
import com.google.android.gms.internal.zzbu;
import com.google.android.gms.internal.zzeg;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzic;
import java.util.Map;

@zzgi
public class zzed
extends zzeg {
    private final Map<String, String> zzsZ;
    private final Context mContext;

    public zzed(zzic zzic2, Map<String, String> map) {
        super(zzic2, "storePicture");
        this.zzsZ = map;
        this.mContext = zzic2.zzeD();
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzH("Activity context is not available");
            return;
        }
        zzbu zzbu2 = zzab.zzaM().zzx(this.mContext);
        if (!zzbu2.zzbR()) {
            this.zzH("Feature is not supported by the device.");
            return;
        }
        final String string2 = this.zzsZ.get("iurl");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzH("Image url cannot be empty.");
            return;
        }
        if (!URLUtil.isValidUrl((String)string2)) {
            this.zzH("Invalid image url: " + string2);
            return;
        }
        final String string3 = this.zzG(string2);
        if (!zzab.zzaM().zzU(string3)) {
            this.zzH("Image type not recognized: " + string3);
            return;
        }
        AlertDialog.Builder builder = zzab.zzaM().zzw(this.mContext);
        builder.setTitle((CharSequence)zzab.zzaP().zzc(R.string.store_picture_title, "Save image"));
        builder.setMessage((CharSequence)zzab.zzaP().zzc(R.string.store_picture_message, "Allow Ad to store image in Picture gallery?"));
        builder.setPositiveButton((CharSequence)zzab.zzaP().zzc(R.string.accept, "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                DownloadManager downloadManager = (DownloadManager)zzed.this.mContext.getSystemService("download");
                try {
                    DownloadManager.Request request = zzed.this.zzf(string2, string3);
                    downloadManager.enqueue(request);
                }
                catch (IllegalStateException illegalStateException) {
                    zzed.this.zzH("Could not store picture.");
                }
            }
        });
        builder.setNegativeButton((CharSequence)zzab.zzaP().zzc(R.string.decline, "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                zzed.this.zzH("User canceled the download.");
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    DownloadManager.Request zzf(String string2, String string3) {
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)string2));
        request.setDestinationInExternalPublicDir(Environment.DIRECTORY_PICTURES, string3);
        zzab.zzaO().zza(request);
        return request;
    }

    String zzG(String string2) {
        Uri uri = Uri.parse((String)string2);
        return uri.getLastPathSegment();
    }
}

