/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.internal.zzab;
import com.google.android.gms.internal.zzba;
import com.google.android.gms.internal.zzbe;
import com.google.android.gms.internal.zzeg;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzhx;
import com.google.android.gms.internal.zzic;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@zzgi
public class zzeb
extends zzeg {
    static final Set<String> zztg = new HashSet<String>(Arrays.asList("top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"));
    private String zzth = "top-right";
    private boolean zzti = true;
    private int zztj = 0;
    private int zztk = 0;
    private int zzlj = -1;
    private int zztl = 0;
    private int zztm = 0;
    private int zzli = -1;
    private final Object zznh = new Object();
    private final zzic zzmu;
    private final Activity zztn;
    private zzba zzsF;
    private ImageView zzto;
    private LinearLayout zztp;
    private zzeh zztq;
    private PopupWindow zztr;
    private RelativeLayout zzts;
    private ViewGroup zztt;

    public zzeb(zzic zzic2, zzeh zzeh2) {
        super(zzic2, "resize");
        this.zzmu = zzic2;
        this.zztn = zzic2.zzeD();
        this.zztq = zzeh2;
    }

    private void zzf(Map<String, String> map) {
        String string2;
        if (!TextUtils.isEmpty((CharSequence)map.get("width"))) {
            this.zzli = zzab.zzaM().zzT(map.get("width"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("height"))) {
            this.zzlj = zzab.zzaM().zzT(map.get("height"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetX"))) {
            this.zztl = zzab.zzaM().zzT(map.get("offsetX"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetY"))) {
            this.zztm = zzab.zzaM().zzT(map.get("offsetY"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("allowOffscreen"))) {
            this.zzti = Boolean.parseBoolean(map.get("allowOffscreen"));
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = map.get("customClosePosition")))) {
            this.zzth = string2;
        }
    }

    boolean zzcN() {
        return this.zzli > -1 && this.zzlj > -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzg(Map<String, String> map) {
        Object object = this.zznh;
        synchronized (object) {
            Bitmap bitmap;
            if (this.zztn == null) {
                this.zzH("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zzmu.zzad() == null) {
                this.zzH("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zzmu.zzad().zzpb) {
                this.zzH("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zzmu.zzeK()) {
                this.zzH("Cannot resize an expanded banner.");
                return;
            }
            this.zzf(map);
            if (!this.zzcN()) {
                this.zzH("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zztn.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zzH("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zzcO();
            if (nArray == null) {
                this.zzH("Resize location out of screen or close button is not visible.");
                return;
            }
            int n = zzbe.zzbD().zzb((Context)this.zztn, this.zzli);
            int n2 = zzbe.zzbD().zzb((Context)this.zztn, this.zzlj);
            ViewParent viewParent = this.zzmu.getWebView().getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView((View)this.zzmu.getWebView());
                if (this.zztr == null) {
                    this.zztt = (ViewGroup)viewParent;
                    bitmap = zzab.zzaM().zzh((View)this.zzmu.getWebView());
                    this.zzto = new ImageView((Context)this.zztn);
                    this.zzto.setImageBitmap(bitmap);
                    this.zzsF = this.zzmu.zzad();
                    this.zztt.addView((View)this.zzto);
                } else {
                    this.zztr.dismiss();
                }
            } else {
                this.zzH("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzts = new RelativeLayout((Context)this.zztn);
            this.zzts.setBackgroundColor(0);
            this.zzts.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            this.zztr = zzab.zzaM().zza((View)this.zzts, n, n2, false);
            this.zztr.setOutsideTouchable(true);
            this.zztr.setTouchable(true);
            this.zztr.setClippingEnabled(!this.zzti);
            this.zzts.addView((View)this.zzmu.getWebView(), -1, -1);
            this.zztp = new LinearLayout((Context)this.zztn);
            bitmap = new RelativeLayout.LayoutParams(zzbe.zzbD().zzb((Context)this.zztn, 50), zzbe.zzbD().zzb((Context)this.zztn, 50));
            switch (this.zzth) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zztp.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    zzeb.this.zzm(true);
                }
            });
            this.zztp.setContentDescription((CharSequence)"Close button");
            this.zzts.addView((View)this.zztp, (ViewGroup.LayoutParams)bitmap);
            try {
                this.zztr.showAtLocation(window.getDecorView(), 0, zzbe.zzbD().zzb((Context)this.zztn, nArray[0]), zzbe.zzbD().zzb((Context)this.zztn, nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                this.zzH("Cannot show popup window: " + runtimeException.getMessage());
                this.zzts.removeView((View)this.zzmu.getWebView());
                if (this.zztt != null) {
                    this.zztt.removeView((View)this.zzto);
                    this.zztt.addView((View)this.zzmu.getWebView());
                    this.zzmu.zza(this.zzsF);
                }
                return;
            }
            this.zzc(nArray[0], nArray[1]);
            this.zzmu.zza(new zzba((Context)this.zztn, new AdSize(this.zzli, this.zzlj)));
            this.zzd(nArray[0], nArray[1]);
            this.zzJ("resized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzm(boolean bl) {
        Object object = this.zznh;
        synchronized (object) {
            if (this.zztr != null) {
                this.zztr.dismiss();
                this.zzts.removeView((View)this.zzmu.getWebView());
                if (this.zztt != null) {
                    this.zztt.removeView((View)this.zzto);
                    this.zztt.addView((View)this.zzmu.getWebView());
                    this.zzmu.zza(this.zzsF);
                }
                if (bl) {
                    this.zzJ("default");
                    if (this.zztq != null) {
                        this.zztq.zzam();
                    }
                }
                this.zztr = null;
                this.zzts = null;
                this.zztt = null;
                this.zztp = null;
            }
        }
    }

    private int[] zzcO() {
        if (!this.zzcQ()) {
            return null;
        }
        if (this.zzti) {
            return new int[]{this.zztj + this.zztl, this.zztk + this.zztm};
        }
        int[] nArray = zzab.zzaM().zzh(this.zztn);
        int[] nArray2 = zzab.zzaM().zzj(this.zztn);
        int n = nArray[0];
        int n2 = this.zztj + this.zztl;
        int n3 = this.zztk + this.zztm;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 + this.zzli > n) {
            n2 = n - this.zzli;
        }
        if (n3 < nArray2[0]) {
            n3 = nArray2[0];
        } else if (n3 + this.zzlj > nArray2[1]) {
            n3 = nArray2[1] - this.zzlj;
        }
        return new int[]{n2, n3};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzb(int n, int n2) {
        Object object = this.zznh;
        synchronized (object) {
            this.zztj = n;
            this.zztk = n2;
            if (this.zztr != null) {
                int[] nArray = this.zzcO();
                if (nArray != null) {
                    this.zztr.update(zzbe.zzbD().zzb((Context)this.zztn, nArray[0]), zzbe.zzbD().zzb((Context)this.zztn, nArray[1]), this.zztr.getWidth(), this.zztr.getHeight());
                    this.zzd(nArray[0], nArray[1]);
                } else {
                    this.zzm(true);
                }
            }
        }
    }

    void zzc(int n, int n2) {
        if (this.zztq != null) {
            this.zztq.zza(n, n2, this.zzli, this.zzlj);
        }
    }

    void zzd(int n, int n2) {
        int n3 = zzab.zzaM().zzj(this.zztn)[0];
        this.zzb(n, n2 - n3, this.zzli, this.zzlj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzcP() {
        Object object = this.zznh;
        synchronized (object) {
            return this.zztr != null;
        }
    }

    public void zze(int n, int n2) {
        this.zztj = n;
        this.zztk = n2;
    }

    boolean zzcQ() {
        int[] nArray = zzab.zzaM().zzh(this.zztn);
        int[] nArray2 = zzab.zzaM().zzj(this.zztn);
        int n = nArray[0];
        int n2 = nArray[1];
        if (this.zzli < 50 || this.zzli > n) {
            zzhx.zzac("Width is too small or too large.");
            return false;
        }
        if (this.zzlj < 50 || this.zzlj > n2) {
            zzhx.zzac("Height is too small or too large.");
            return false;
        }
        if (this.zzlj == n2 && this.zzli == n) {
            zzhx.zzac("Cannot resize to a full-screen ad.");
            return false;
        }
        if (this.zzti) {
            int n3 = -1;
            int n4 = -2;
            switch (this.zzth) {
                case "top-left": {
                    n3 = this.zztj + this.zztl;
                    n4 = this.zztk + this.zztm;
                    break;
                }
                case "top-center": {
                    n3 = this.zztj + this.zztl + this.zzli / 2 - 25;
                    n4 = this.zztk + this.zztm;
                    break;
                }
                case "center": {
                    n3 = this.zztj + this.zztl + this.zzli / 2 - 25;
                    n4 = this.zztk + this.zztm + this.zzlj / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n3 = this.zztj + this.zztl;
                    n4 = this.zztk + this.zztm + this.zzlj - 50;
                    break;
                }
                case "bottom-center": {
                    n3 = this.zztj + this.zztl + this.zzli / 2 - 25;
                    n4 = this.zztk + this.zztm + this.zzlj - 50;
                    break;
                }
                case "bottom-right": {
                    n3 = this.zztj + this.zztl + this.zzli - 50;
                    n4 = this.zztk + this.zztm + this.zzlj - 50;
                    break;
                }
                default: {
                    n3 = this.zztj + this.zztl + this.zzli - 50;
                    n4 = this.zztk + this.zztm;
                }
            }
            if (n3 < 0 || n3 + 50 > n || n4 < nArray2[0] || n4 + 50 > nArray2[1]) {
                return false;
            }
        }
        return true;
    }
}

