/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.internal.zzab;
import com.google.android.gms.internal.zzbu;
import com.google.android.gms.internal.zzeg;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzic;
import java.util.Map;

@zzgi
public class zzea
extends zzeg {
    private final Map<String, String> zzsZ;
    private final Context mContext;
    private String zzta;
    private long zztb;
    private long zztc;
    private String zztd;
    private String zzte;

    public zzea(zzic zzic2, Map<String, String> map) {
        super(zzic2, "createCalendarEvent");
        this.zzsZ = map;
        this.mContext = zzic2.zzeD();
        this.zzcM();
    }

    private void zzcM() {
        this.zzta = this.zzE("description");
        this.zztd = this.zzE("summary");
        this.zztb = this.zzF("start_ticks");
        this.zztc = this.zzF("end_ticks");
        this.zzte = this.zzE("location");
    }

    private String zzE(String string2) {
        return TextUtils.isEmpty((CharSequence)this.zzsZ.get(string2)) ? "" : this.zzsZ.get(string2);
    }

    private long zzF(String string2) {
        String string3 = this.zzsZ.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzH("Activity context is not available.");
            return;
        }
        zzbu zzbu2 = zzab.zzaM().zzx(this.mContext);
        if (!zzbu2.zzbU()) {
            this.zzH("This feature is not available on the device.");
            return;
        }
        AlertDialog.Builder builder = zzab.zzaM().zzw(this.mContext);
        builder.setTitle((CharSequence)zzab.zzaP().zzc(R.string.create_calendar_title, "Create calendar event"));
        builder.setMessage((CharSequence)zzab.zzaP().zzc(R.string.create_calendar_message, "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)zzab.zzaP().zzc(R.string.accept, "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Intent intent = zzea.this.createIntent();
                zzea.this.mContext.startActivity(intent);
            }
        });
        builder.setNegativeButton((CharSequence)zzab.zzaP().zzc(R.string.decline, "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                zzea.this.zzH("Operation denied by user.");
            }
        });
        builder.create().show();
    }

    Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzta);
        intent.putExtra("eventLocation", this.zzte);
        intent.putExtra("description", this.zztd);
        if (this.zztb > -1L) {
            intent.putExtra("beginTime", this.zztb);
        }
        if (this.zztc > -1L) {
            intent.putExtra("endTime", this.zztc);
        }
        intent.setFlags(0x10000000);
        return intent;
    }
}

