/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.zza;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzax;
import com.google.android.gms.internal.zzba;
import com.google.android.gms.internal.zzds;
import com.google.android.gms.internal.zzdt;
import com.google.android.gms.internal.zzdu;
import com.google.android.gms.internal.zzdw;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzhx;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.json.JSONObject;

@zzgi
public final class zzdv
extends zzds.zza {
    private final MediationAdapter zzsR;

    public zzdv(MediationAdapter mediationAdapter) {
        this.zzsR = mediationAdapter;
    }

    @Override
    public zzd getView() throws RemoteException {
        if (!(this.zzsR instanceof MediationBannerAdapter)) {
            zzhx.zzac("MediationAdapter is not a MediationBannerAdapter: " + this.zzsR.getClass().getCanonicalName());
            throw new RemoteException();
        }
        try {
            MediationBannerAdapter mediationBannerAdapter = (MediationBannerAdapter)this.zzsR;
            return zze.zzn((Object)mediationBannerAdapter.getBannerView());
        }
        catch (Throwable throwable) {
            zzhx.zzd("Could not get banner view from adapter.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public void zza(zzd zzd2, zzba zzba2, zzax zzax2, String string2, zzdt zzdt2) throws RemoteException {
        this.zza(zzd2, zzba2, zzax2, string2, null, zzdt2);
    }

    @Override
    public void zza(zzd zzd2, zzba zzba2, zzax zzax2, String string2, String string3, zzdt zzdt2) throws RemoteException {
        if (!(this.zzsR instanceof MediationBannerAdapter)) {
            zzhx.zzac("MediationAdapter is not a MediationBannerAdapter: " + this.zzsR.getClass().getCanonicalName());
            throw new RemoteException();
        }
        zzhx.zzY("Requesting banner ad from adapter.");
        try {
            MediationBannerAdapter mediationBannerAdapter = (MediationBannerAdapter)this.zzsR;
            HashSet<String> hashSet = zzax2.zzoN != null ? new HashSet<String>(zzax2.zzoN) : null;
            zzdu zzdu2 = new zzdu(new Date(zzax2.zzoL), zzax2.zzoM, hashSet, zzax2.zzoT, zzax2.zzoO, zzax2.zzoP);
            Bundle bundle = zzax2.zzoV != null ? zzax2.zzoV.getBundle(mediationBannerAdapter.getClass().getName()) : null;
            mediationBannerAdapter.requestBannerAd((Context)zze.zzf((zzd)zzd2), new zzdw(zzdt2), this.zza(string2, zzax2.zzoP, string3), zza.zza(zzba2.width, zzba2.height, zzba2.zzpa), zzdu2, bundle);
        }
        catch (Throwable throwable) {
            zzhx.zzd("Could not request banner ad from adapter.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public void zza(zzd zzd2, zzax zzax2, String string2, zzdt zzdt2) throws RemoteException {
        this.zza(zzd2, zzax2, string2, null, zzdt2);
    }

    @Override
    public void zza(zzd zzd2, zzax zzax2, String string2, String string3, zzdt zzdt2) throws RemoteException {
        if (!(this.zzsR instanceof MediationInterstitialAdapter)) {
            zzhx.zzac("MediationAdapter is not a MediationInterstitialAdapter: " + this.zzsR.getClass().getCanonicalName());
            throw new RemoteException();
        }
        zzhx.zzY("Requesting interstitial ad from adapter.");
        try {
            MediationInterstitialAdapter mediationInterstitialAdapter = (MediationInterstitialAdapter)this.zzsR;
            HashSet<String> hashSet = zzax2.zzoN != null ? new HashSet<String>(zzax2.zzoN) : null;
            zzdu zzdu2 = new zzdu(new Date(zzax2.zzoL), zzax2.zzoM, hashSet, zzax2.zzoT, zzax2.zzoO, zzax2.zzoP);
            Bundle bundle = zzax2.zzoV != null ? zzax2.zzoV.getBundle(mediationInterstitialAdapter.getClass().getName()) : null;
            mediationInterstitialAdapter.requestInterstitialAd((Context)zze.zzf((zzd)zzd2), new zzdw(zzdt2), this.zza(string2, zzax2.zzoP, string3), zzdu2, bundle);
        }
        catch (Throwable throwable) {
            zzhx.zzd("Could not request interstitial ad from adapter.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public void showInterstitial() throws RemoteException {
        if (!(this.zzsR instanceof MediationInterstitialAdapter)) {
            zzhx.zzac("MediationAdapter is not a MediationInterstitialAdapter: " + this.zzsR.getClass().getCanonicalName());
            throw new RemoteException();
        }
        zzhx.zzY("Showing interstitial from adapter.");
        try {
            MediationInterstitialAdapter mediationInterstitialAdapter = (MediationInterstitialAdapter)this.zzsR;
            mediationInterstitialAdapter.showInterstitial();
        }
        catch (Throwable throwable) {
            zzhx.zzd("Could not show interstitial from adapter.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public void destroy() throws RemoteException {
        try {
            this.zzsR.onDestroy();
        }
        catch (Throwable throwable) {
            zzhx.zzd("Could not destroy adapter.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public void pause() throws RemoteException {
        try {
            this.zzsR.onPause();
        }
        catch (Throwable throwable) {
            zzhx.zzd("Could not pause adapter.", throwable);
            throw new RemoteException();
        }
    }

    @Override
    public void resume() throws RemoteException {
        try {
            this.zzsR.onResume();
        }
        catch (Throwable throwable) {
            zzhx.zzd("Could not resume adapter.", throwable);
            throw new RemoteException();
        }
    }

    private Bundle zza(String string2, int n, String string3) throws RemoteException {
        zzhx.zzac("Server parameters: " + string2);
        try {
            Bundle bundle = new Bundle();
            if (string2 != null) {
                JSONObject jSONObject = new JSONObject(string2);
                bundle = new Bundle();
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    bundle.putString(string4, jSONObject.getString(string4));
                }
            }
            if (this.zzsR instanceof AdMobAdapter) {
                bundle.putString("adJson", string3);
                bundle.putInt("tagForChildDirectedTreatment", n);
            }
            return bundle;
        }
        catch (Throwable throwable) {
            zzhx.zzd("Could not get Server Parameters Bundle.", throwable);
            throw new RemoteException();
        }
    }
}

