/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import com.google.android.gms.internal.zzbe;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zzel;
import com.google.android.gms.internal.zzeq;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzhx;
import com.google.android.gms.internal.zzic;
import java.util.Map;

@zzgi
public final class zzdb
implements zzcv {
    private static int zza(DisplayMetrics displayMetrics, Map<String, String> map, String string2, int n) {
        String string3 = map.get(string2);
        int n2 = n;
        if (string3 != null) {
            try {
                n2 = zzbe.zzbD().zza(displayMetrics, Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                zzhx.zzac("Could not parse " + string2 + " in a video GMSG: " + string3);
            }
        }
        return n2;
    }

    @Override
    public void zza(zzic zzic2, Map<String, String> map) {
        String string2 = map.get("action");
        if (string2 == null) {
            zzhx.zzac("Action missing from video GMSG.");
            return;
        }
        zzel zzel2 = zzic2.zzeF();
        if (zzel2 == null) {
            zzhx.zzac("Could not get ad overlay for a video GMSG.");
            return;
        }
        boolean bl = "new".equalsIgnoreCase(string2);
        boolean bl2 = "position".equalsIgnoreCase(string2);
        if (bl || bl2) {
            DisplayMetrics displayMetrics = zzic2.getContext().getResources().getDisplayMetrics();
            int n = zzdb.zza(displayMetrics, map, "x", 0);
            int n2 = zzdb.zza(displayMetrics, map, "y", 0);
            int n3 = zzdb.zza(displayMetrics, map, "w", -1);
            int n4 = zzdb.zza(displayMetrics, map, "h", -1);
            if (bl && zzel2.zzdb() == null) {
                zzel2.zzf(n, n2, n3, n4);
            } else {
                zzel2.zze(n, n2, n3, n4);
            }
        } else {
            zzeq zzeq2 = zzel2.zzdb();
            if (zzeq2 == null) {
                zzeq.zza(zzic2, "no_video_view", null);
                return;
            }
            if ("click".equalsIgnoreCase(string2)) {
                DisplayMetrics displayMetrics = zzic2.getContext().getResources().getDisplayMetrics();
                int n = zzdb.zza(displayMetrics, map, "x", 0);
                int n5 = zzdb.zza(displayMetrics, map, "y", 0);
                long l = SystemClock.uptimeMillis();
                MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)0, (float)n, (float)n5, (int)0);
                zzeq2.zzb(motionEvent);
                motionEvent.recycle();
            } else if ("controls".equalsIgnoreCase(string2)) {
                String string3 = map.get("enabled");
                if (string3 == null) {
                    zzhx.zzac("Enabled parameter missing from controls video GMSG.");
                    return;
                }
                zzeq2.zzu(Boolean.parseBoolean(string3));
            } else if ("currentTime".equalsIgnoreCase(string2)) {
                String string4 = map.get("time");
                if (string4 == null) {
                    zzhx.zzac("Time parameter missing from currentTime video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string4);
                    int n = (int)(f * 1000.0f);
                    zzeq2.seekTo(n);
                }
                catch (NumberFormatException numberFormatException) {
                    zzhx.zzac("Could not parse time parameter from currentTime video GMSG: " + string4);
                }
            } else if ("hide".equalsIgnoreCase(string2)) {
                zzeq2.setVisibility(4);
            } else if ("load".equalsIgnoreCase(string2)) {
                zzeq2.zzdo();
            } else if ("pause".equalsIgnoreCase(string2)) {
                zzeq2.pause();
            } else if ("play".equalsIgnoreCase(string2)) {
                zzeq2.play();
            } else if ("show".equalsIgnoreCase(string2)) {
                zzeq2.setVisibility(0);
            } else if ("src".equalsIgnoreCase(string2)) {
                zzeq2.zzK(map.get("src"));
            } else {
                zzhx.zzac("Unknown video action: " + string2);
            }
        }
    }
}

