/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zzdb;
import com.google.android.gms.internal.zzel;
import com.google.android.gms.internal.zzg;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzhl;
import com.google.android.gms.internal.zzhu;
import com.google.android.gms.internal.zzhx;
import com.google.android.gms.internal.zzic;
import com.google.android.gms.internal.zzk;
import com.google.android.gms.internal.zzl;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzgi
public final class zzcu {
    public static final zzcv zzrz = new zzcv(){

        @Override
        public void zza(zzic zzic2, Map<String, String> map) {
        }
    };
    public static final zzcv zzrA = new zzcv(){

        @Override
        public void zza(zzic zzic2, Map<String, String> map) {
            String string2 = map.get("urls");
            if (TextUtils.isEmpty((CharSequence)string2)) {
                zzhx.zzac("URLs missing in canOpenURLs GMSG.");
                return;
            }
            String[] stringArray = string2.split(",");
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            PackageManager packageManager = zzic2.getContext().getPackageManager();
            for (String string3 : stringArray) {
                String[] stringArray2 = string3.split(";", 2);
                String string4 = stringArray2[0].trim();
                String string5 = stringArray2.length > 1 ? stringArray2[1].trim() : "android.intent.action.VIEW";
                Uri uri = Uri.parse((String)string4);
                Intent intent = new Intent(string5, uri);
                ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
                hashMap.put(string3, resolveInfo != null);
            }
            zzic2.zzb("openableURLs", hashMap);
        }
    };
    public static final zzcv zzrB = new zzcv(){

        @Override
        public void zza(zzic zzic2, Map<String, String> map) {
            JSONArray jSONArray;
            JSONObject jSONObject;
            PackageManager packageManager = zzic2.getContext().getPackageManager();
            String string2 = map.get("data");
            try {
                jSONObject = new JSONObject(string2);
            }
            catch (JSONException jSONException) {
                zzic2.zzb("openableIntents", new JSONObject());
                return;
            }
            try {
                jSONArray = jSONObject.getJSONArray("intents");
            }
            catch (JSONException jSONException) {
                zzic2.zzb("openableIntents", new JSONObject());
                return;
            }
            JSONObject jSONObject2 = new JSONObject();
            for (int i = 0; i < jSONArray.length(); ++i) {
                ResolveInfo resolveInfo;
                JSONObject jSONObject3;
                try {
                    jSONObject3 = jSONArray.getJSONObject(i);
                }
                catch (JSONException jSONException) {
                    zzhx.zzb("Error parsing the intent data.", jSONException);
                    continue;
                }
                String string3 = jSONObject3.optString("id");
                String string4 = jSONObject3.optString("u");
                String string5 = jSONObject3.optString("i");
                String string6 = jSONObject3.optString("m");
                String string7 = jSONObject3.optString("p");
                String string8 = jSONObject3.optString("c");
                String string9 = jSONObject3.optString("f");
                String string10 = jSONObject3.optString("e");
                Intent intent = new Intent();
                if (!TextUtils.isEmpty((CharSequence)string4)) {
                    intent.setData(Uri.parse((String)string4));
                }
                if (!TextUtils.isEmpty((CharSequence)string5)) {
                    intent.setAction(string5);
                }
                if (!TextUtils.isEmpty((CharSequence)string6)) {
                    intent.setType(string6);
                }
                if (!TextUtils.isEmpty((CharSequence)string7)) {
                    intent.setPackage(string7);
                }
                if (!TextUtils.isEmpty((CharSequence)string8) && ((ResolveInfo)(resolveInfo = string8.split("/", 2))).length == 2) {
                    intent.setComponent(new ComponentName((String)resolveInfo[0], (String)resolveInfo[1]));
                }
                boolean bl = (resolveInfo = packageManager.resolveActivity(intent, 65536)) != null;
                try {
                    jSONObject2.put(string3, bl);
                    continue;
                }
                catch (JSONException jSONException) {
                    zzhx.zzb("Error constructing openable urls response.", jSONException);
                }
            }
            zzic2.zzb("openableIntents", jSONObject2);
        }
    };
    public static final zzcv zzrC = new zzcv(){

        @Override
        public void zza(zzic zzic2, Map<String, String> map) {
            Object object;
            String string2 = map.get("u");
            if (string2 == null) {
                zzhx.zzac("URL missing from click GMSG.");
                return;
            }
            Uri uri = Uri.parse((String)string2);
            try {
                object = zzic2.zzeI();
                if (object != null && object.zzb(uri)) {
                    uri = object.zza(uri, zzic2.getContext());
                }
            }
            catch (zzl zzl2) {
                zzhx.zzac("Unable to append parameter to URL: " + string2);
            }
            string2 = uri.toString();
            object = new zzhu(zzic2.getContext(), zzic2.zzeJ().zzzH, string2);
            ((zzhl)object).start();
        }
    };
    public static final zzcv zzrD = new zzcv(){

        @Override
        public void zza(zzic zzic2, Map<String, String> map) {
            zzel zzel2 = zzic2.zzeF();
            if (zzel2 == null) {
                zzhx.zzac("A GMSG tried to close something that wasn't an overlay.");
                return;
            }
            zzel2.close();
        }
    };
    public static final zzcv zzrE = new zzcv(){

        @Override
        public void zza(zzic zzic2, Map<String, String> map) {
            zzic2.zzB("1".equals(map.get("custom_close")));
        }
    };
    public static final zzcv zzrF = new zzcv(){

        @Override
        public void zza(zzic zzic2, Map<String, String> map) {
            String string2 = map.get("u");
            if (string2 == null) {
                zzhx.zzac("URL missing from httpTrack GMSG.");
                return;
            }
            zzhu zzhu2 = new zzhu(zzic2.getContext(), zzic2.zzeJ().zzzH, string2);
            zzhu2.start();
        }
    };
    public static final zzcv zzrG = new zzcv(){

        @Override
        public void zza(zzic zzic2, Map<String, String> map) {
            zzhx.zzaa("Received log message: " + map.get("string"));
        }
    };
    public static final zzcv zzrH = new zzcv(){

        @Override
        public void zza(zzic zzic2, Map<String, String> map) {
            String string2 = map.get("tx");
            String string3 = map.get("ty");
            String string4 = map.get("td");
            try {
                int n = Integer.parseInt(string2);
                int n2 = Integer.parseInt(string3);
                int n3 = Integer.parseInt(string4);
                zzk zzk2 = zzic2.zzeI();
                if (zzk2 != null) {
                    zzg zzg2 = zzk2.zzC();
                    zzg2.zza(n, n2, n3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                zzhx.zzac("Could not parse touch parameters from gmsg.");
            }
        }
    };
    public static final zzcv zzrI = new zzdb();
}

