/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.doubleclick.PublisherInterstitialAd;
import com.google.android.gms.ads.purchase.InAppPurchaseListener;
import com.google.android.gms.ads.purchase.PlayStorePurchaseListener;
import com.google.android.gms.internal.zzat;
import com.google.android.gms.internal.zzau;
import com.google.android.gms.internal.zzav;
import com.google.android.gms.internal.zzaz;
import com.google.android.gms.internal.zzba;
import com.google.android.gms.internal.zzbc;
import com.google.android.gms.internal.zzbe;
import com.google.android.gms.internal.zzbi;
import com.google.android.gms.internal.zzbo;
import com.google.android.gms.internal.zzck;
import com.google.android.gms.internal.zzdq;
import com.google.android.gms.internal.zzft;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzhx;

public class zzbq {
    private final zzdq zzpD = new zzdq();
    private final Context mContext;
    private final zzaz zzpE;
    private AdListener zzoK;
    private zzat zzoJ;
    private zzbi zzpG;
    private String zzpf;
    private String zzpH;
    private AppEventListener zzpd;
    private PlayStorePurchaseListener zzpK;
    private InAppPurchaseListener zzpJ;
    private PublisherInterstitialAd zzpM;
    private OnCustomRenderedAdLoadedListener zzpL;

    public zzbq(Context context) {
        this(context, zzaz.zzbA(), null);
    }

    public zzbq(Context context, PublisherInterstitialAd publisherInterstitialAd) {
        this(context, zzaz.zzbA(), publisherInterstitialAd);
    }

    public zzbq(Context context, zzaz zzaz2, PublisherInterstitialAd publisherInterstitialAd) {
        this.mContext = context;
        this.zzpE = zzaz2;
        this.zzpM = publisherInterstitialAd;
    }

    public AdListener getAdListener() {
        return this.zzoK;
    }

    public String getAdUnitId() {
        return this.zzpf;
    }

    public AppEventListener getAppEventListener() {
        return this.zzpd;
    }

    public InAppPurchaseListener getInAppPurchaseListener() {
        return this.zzpJ;
    }

    public OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzpL;
    }

    public boolean isLoaded() {
        try {
            if (this.zzpG == null) {
                return false;
            }
            return this.zzpG.isReady();
        }
        catch (RemoteException remoteException) {
            zzhx.zzd("Failed to check if ad is ready.", remoteException);
            return false;
        }
    }

    public void zza(zzbo zzbo2) {
        try {
            if (this.zzpG == null) {
                this.zzy("loadAd");
            }
            if (this.zzpG.zza(this.zzpE.zza(this.mContext, zzbo2))) {
                this.zzpD.zze(zzbo2.zzbJ());
            }
        }
        catch (RemoteException remoteException) {
            zzhx.zzd("Failed to load ad.", remoteException);
        }
    }

    public void setAdListener(AdListener adListener) {
        try {
            this.zzoK = adListener;
            if (this.zzpG != null) {
                this.zzpG.zza(adListener != null ? new zzav(adListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzhx.zzd("Failed to set the AdListener.", remoteException);
        }
    }

    public void zza(zzat zzat2) {
        try {
            this.zzoJ = zzat2;
            if (this.zzpG != null) {
                this.zzpG.zza(zzat2 != null ? new zzau(zzat2) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzhx.zzd("Failed to set the AdClickListener.", remoteException);
        }
    }

    public void setAdUnitId(String adUnitId) {
        if (this.zzpf != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on InterstitialAd.");
        }
        this.zzpf = adUnitId;
    }

    public void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzpd = appEventListener;
            if (this.zzpG != null) {
                this.zzpG.zza(appEventListener != null ? new zzbc(appEventListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzhx.zzd("Failed to set the AppEventListener.", remoteException);
        }
    }

    public void setInAppPurchaseListener(InAppPurchaseListener inAppPurchaseListener) {
        if (this.zzpK != null) {
            throw new IllegalStateException("Play store purchase parameter has already been set.");
        }
        try {
            this.zzpJ = inAppPurchaseListener;
            if (this.zzpG != null) {
                this.zzpG.zza(inAppPurchaseListener != null ? new zzft(inAppPurchaseListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzhx.zzd("Failed to set the InAppPurchaseListener.", remoteException);
        }
    }

    public void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        try {
            this.zzpL = onCustomRenderedAdLoadedListener;
            if (this.zzpG != null) {
                this.zzpG.zza(onCustomRenderedAdLoadedListener != null ? new zzck(onCustomRenderedAdLoadedListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzhx.zzd("Failed to set the OnCustomRenderedAdLoadedListener.", remoteException);
        }
    }

    public void setPlayStorePurchaseParams(PlayStorePurchaseListener playStorePurchaseListener, String publicKey) {
        if (this.zzpJ != null) {
            throw new IllegalStateException("In app purchase parameter has already been set.");
        }
        try {
            this.zzpK = playStorePurchaseListener;
            this.zzpH = publicKey;
            if (this.zzpG != null) {
                this.zzpG.zza(playStorePurchaseListener != null ? new zzfx(playStorePurchaseListener) : null, publicKey);
            }
        }
        catch (RemoteException remoteException) {
            zzhx.zzd("Failed to set the play store purchase parameter.", remoteException);
        }
    }

    public String getMediationAdapterClassName() {
        try {
            if (this.zzpG != null) {
                return this.zzpG.getMediationAdapterClassName();
            }
        }
        catch (RemoteException remoteException) {
            zzhx.zzd("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public void show() {
        try {
            this.zzz("show");
            this.zzpG.showInterstitial();
        }
        catch (RemoteException remoteException) {
            zzhx.zzd("Failed to show interstitial.", remoteException);
        }
    }

    private void zzy(String string2) throws RemoteException {
        if (this.zzpf == null) {
            this.zzz(string2);
        }
        this.zzpG = zzbe.zzbE().zza(this.mContext, new zzba(), this.zzpf, this.zzpD);
        if (this.zzoK != null) {
            this.zzpG.zza(new zzav(this.zzoK));
        }
        if (this.zzoJ != null) {
            this.zzpG.zza(new zzau(this.zzoJ));
        }
        if (this.zzpd != null) {
            this.zzpG.zza(new zzbc(this.zzpd));
        }
        if (this.zzpJ != null) {
            this.zzpG.zza(new zzft(this.zzpJ));
        }
        if (this.zzpK != null) {
            this.zzpG.zza(new zzfx(this.zzpK), this.zzpH);
        }
        if (this.zzpL != null) {
            this.zzpG.zza(new zzck(this.zzpL));
        }
    }

    private void zzz(String string2) {
        if (this.zzpG == null) {
            throw new IllegalStateException("The ad unit ID must be set on InterstitialAd before " + string2 + " is called.");
        }
    }
}

