/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.purchase.InAppPurchaseListener;
import com.google.android.gms.ads.purchase.PlayStorePurchaseListener;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzat;
import com.google.android.gms.internal.zzau;
import com.google.android.gms.internal.zzav;
import com.google.android.gms.internal.zzaz;
import com.google.android.gms.internal.zzba;
import com.google.android.gms.internal.zzbc;
import com.google.android.gms.internal.zzbd;
import com.google.android.gms.internal.zzbe;
import com.google.android.gms.internal.zzbi;
import com.google.android.gms.internal.zzbo;
import com.google.android.gms.internal.zzck;
import com.google.android.gms.internal.zzdq;
import com.google.android.gms.internal.zzft;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzhx;
import java.util.concurrent.atomic.AtomicBoolean;

public class zzbp {
    private final zzdq zzpD = new zzdq();
    private final zzaz zzpE;
    private final AtomicBoolean zzpF;
    private AdListener zzoK;
    private zzat zzoJ;
    private zzbi zzpG;
    private AdSize[] zzpe;
    private String zzpf;
    private String zzpH;
    private ViewGroup zzpI;
    private AppEventListener zzpd;
    private InAppPurchaseListener zzpJ;
    private PlayStorePurchaseListener zzpK;
    private OnCustomRenderedAdLoadedListener zzpL;

    public zzbp(ViewGroup viewGroup) {
        this(viewGroup, null, false, zzaz.zzbA());
    }

    public zzbp(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl) {
        this(viewGroup, attributeSet, bl, zzaz.zzbA());
    }

    zzbp(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzaz zzaz2, zzbi zzbi2) {
        this.zzpI = viewGroup;
        this.zzpE = zzaz2;
        this.zzpG = zzbi2;
        this.zzpF = new AtomicBoolean(false);
        if (attributeSet != null) {
            Context context = viewGroup.getContext();
            try {
                zzbd zzbd2 = new zzbd(context, attributeSet);
                this.zzpe = zzbd2.zzi(bl);
                this.zzpf = zzbd2.getAdUnitId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzbe.zzbD().zza(viewGroup, new zzba(context, AdSize.BANNER), illegalArgumentException.getMessage(), illegalArgumentException.getMessage());
                return;
            }
            if (viewGroup.isInEditMode()) {
                zzbe.zzbD().zza(viewGroup, new zzba(context, this.zzpe[0]), "Ads by Google");
            }
        }
    }

    zzbp(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzaz zzaz2) {
        this(viewGroup, attributeSet, bl, zzaz2, null);
    }

    public void destroy() {
        try {
            if (this.zzpG != null) {
                this.zzpG.destroy();
            }
        }
        catch (RemoteException remoteException) {
            zzhx.zzd("Failed to destroy AdView.", remoteException);
        }
    }

    public AdListener getAdListener() {
        return this.zzoK;
    }

    public AdSize getAdSize() {
        try {
            zzba zzba2;
            if (this.zzpG != null && (zzba2 = this.zzpG.zzad()) != null) {
                return zzba2.zzbB();
            }
        }
        catch (RemoteException remoteException) {
            zzhx.zzd("Failed to get the current AdSize.", remoteException);
        }
        return this.zzpe != null ? this.zzpe[0] : null;
    }

    public AdSize[] getAdSizes() {
        return this.zzpe;
    }

    public String getAdUnitId() {
        return this.zzpf;
    }

    public AppEventListener getAppEventListener() {
        return this.zzpd;
    }

    public InAppPurchaseListener getInAppPurchaseListener() {
        return this.zzpJ;
    }

    public OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzpL;
    }

    public void zza(zzbo zzbo2) {
        try {
            if (this.zzpG == null) {
                this.zzbO();
            }
            if (this.zzpG.zza(this.zzpE.zza(this.zzpI.getContext(), zzbo2))) {
                this.zzpD.zze(zzbo2.zzbJ());
            }
        }
        catch (RemoteException remoteException) {
            zzhx.zzd("Failed to load ad.", remoteException);
        }
    }

    public void pause() {
        try {
            if (this.zzpG != null) {
                this.zzpG.pause();
            }
        }
        catch (RemoteException remoteException) {
            zzhx.zzd("Failed to call pause.", remoteException);
        }
    }

    public void recordManualImpression() {
        if (this.zzpF.getAndSet(true)) {
            return;
        }
        try {
            if (this.zzpG != null) {
                this.zzpG.zzan();
            }
        }
        catch (RemoteException remoteException) {
            zzhx.zzd("Failed to record impression.", remoteException);
        }
    }

    public void resume() {
        try {
            if (this.zzpG != null) {
                this.zzpG.resume();
            }
        }
        catch (RemoteException remoteException) {
            zzhx.zzd("Failed to call resume.", remoteException);
        }
    }

    public void setAdListener(AdListener adListener) {
        try {
            this.zzoK = adListener;
            if (this.zzpG != null) {
                this.zzpG.zza(adListener != null ? new zzav(adListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzhx.zzd("Failed to set the AdListener.", remoteException);
        }
    }

    public void zza(zzat zzat2) {
        try {
            this.zzoJ = zzat2;
            if (this.zzpG != null) {
                this.zzpG.zza(zzat2 != null ? new zzau(zzat2) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzhx.zzd("Failed to set the AdClickListener.", remoteException);
        }
    }

    public void setAdSizes(AdSize ... adSizes) {
        if (this.zzpe != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.zza(adSizes);
    }

    public void zza(AdSize ... adSizeArray) {
        this.zzpe = adSizeArray;
        try {
            if (this.zzpG != null) {
                this.zzpG.zza(new zzba(this.zzpI.getContext(), this.zzpe));
            }
        }
        catch (RemoteException remoteException) {
            zzhx.zzd("Failed to set the ad size.", remoteException);
        }
        this.zzpI.requestLayout();
    }

    public void setAdUnitId(String adUnitId) {
        if (this.zzpf != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.zzpf = adUnitId;
    }

    public void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzpd = appEventListener;
            if (this.zzpG != null) {
                this.zzpG.zza(appEventListener != null ? new zzbc(appEventListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzhx.zzd("Failed to set the AppEventListener.", remoteException);
        }
    }

    public void setInAppPurchaseListener(InAppPurchaseListener inAppPurchaseListener) {
        if (this.zzpK != null) {
            throw new IllegalStateException("Play store purchase parameter has already been set.");
        }
        try {
            this.zzpJ = inAppPurchaseListener;
            if (this.zzpG != null) {
                this.zzpG.zza(inAppPurchaseListener != null ? new zzft(inAppPurchaseListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzhx.zzd("Failed to set the InAppPurchaseListener.", remoteException);
        }
    }

    public void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzpL = onCustomRenderedAdLoadedListener;
        try {
            if (this.zzpG != null) {
                this.zzpG.zza(onCustomRenderedAdLoadedListener != null ? new zzck(onCustomRenderedAdLoadedListener) : null);
            }
        }
        catch (RemoteException remoteException) {
            zzhx.zzd("Failed to set the onCustomRenderedAdLoadedListener.", remoteException);
        }
    }

    public void setPlayStorePurchaseParams(PlayStorePurchaseListener playStorePurchaseListener, String publicKey) {
        if (this.zzpJ != null) {
            throw new IllegalStateException("InAppPurchaseListener has already been set.");
        }
        try {
            this.zzpK = playStorePurchaseListener;
            this.zzpH = publicKey;
            if (this.zzpG != null) {
                this.zzpG.zza(playStorePurchaseListener != null ? new zzfx(playStorePurchaseListener) : null, publicKey);
            }
        }
        catch (RemoteException remoteException) {
            zzhx.zzd("Failed to set the play store purchase parameter.", remoteException);
        }
    }

    public String getMediationAdapterClassName() {
        try {
            if (this.zzpG != null) {
                return this.zzpG.getMediationAdapterClassName();
            }
        }
        catch (RemoteException remoteException) {
            zzhx.zzd("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    private void zzbN() {
        try {
            zzd zzd2 = this.zzpG.zzac();
            if (zzd2 == null) {
                return;
            }
            this.zzpI.addView((View)zze.zzf((zzd)zzd2));
        }
        catch (RemoteException remoteException) {
            zzhx.zzd("Failed to get an ad frame.", remoteException);
        }
    }

    private void zzbO() throws RemoteException {
        if ((this.zzpe == null || this.zzpf == null) && this.zzpG == null) {
            throw new IllegalStateException("The ad size and ad unit ID must be set before loadAd is called.");
        }
        Context context = this.zzpI.getContext();
        this.zzpG = zzbe.zzbE().zza(context, new zzba(context, this.zzpe), this.zzpf, this.zzpD);
        if (this.zzoK != null) {
            this.zzpG.zza(new zzav(this.zzoK));
        }
        if (this.zzoJ != null) {
            this.zzpG.zza(new zzau(this.zzoJ));
        }
        if (this.zzpd != null) {
            this.zzpG.zza(new zzbc(this.zzpd));
        }
        if (this.zzpJ != null) {
            this.zzpG.zza(new zzft(this.zzpJ));
        }
        if (this.zzpK != null) {
            this.zzpG.zza(new zzfx(this.zzpK), this.zzpH);
        }
        if (this.zzpL != null) {
            this.zzpG.zza(new zzck(this.zzpL));
        }
        this.zzpG.zza(zzbe.zzbF());
        this.zzbN();
    }
}

