/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.os.PowerManager;
import android.os.Process;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.internal.zzak;
import com.google.android.gms.internal.zzal;
import com.google.android.gms.internal.zzam;
import com.google.android.gms.internal.zzca;
import com.google.android.gms.internal.zzgh;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzhx;
import com.google.android.gms.internal.zzic;
import com.google.android.gms.internal.zzme;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzgi
public class zzan
extends Thread {
    private boolean mStarted = false;
    private boolean zzoj = false;
    private boolean zzok = false;
    private final Object zznh;
    private final zzam zzol;
    private final zzal zzom;
    private final zzgh zzon;
    private final int zzoo;
    private final int zznW;
    private final int zzop;
    private final int zznY;
    private final int zzoq;

    public zzan(zzam zzam2, zzal zzal2, zzgh zzgh2) {
        this.zzol = zzam2;
        this.zzom = zzal2;
        this.zzon = zzgh2;
        this.zznh = new Object();
        this.zznW = zzca.zzqC.get();
        this.zzop = zzca.zzqD.get();
        this.zznY = zzca.zzqE.get();
        this.zzoq = zzca.zzqF.get();
        this.zzoo = zzca.zzqG.get();
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzbt() {
        Object object = this.zznh;
        synchronized (object) {
            if (this.mStarted) {
                zzhx.zzY("Content hash thread already started, quiting...");
                return;
            }
            this.mStarted = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.zzok) {
            Object object;
            try {
                if (this.zzbu()) {
                    object = this.zzol.getActivity();
                    if (object == null) {
                        zzhx.zzY("ContentFetchThread: no activity");
                        continue;
                    }
                    this.zza((Activity)object);
                } else {
                    zzhx.zzY("ContentFetchTask: sleeping");
                    this.zzbw();
                }
                Thread.sleep(this.zzoo * 1000);
            }
            catch (Throwable throwable) {
                zzhx.zzb("Error in ContentFetchTask", throwable);
                this.zzon.zzb(throwable);
            }
            object = this.zznh;
            synchronized (object) {
                while (this.zzoj) {
                    try {
                        zzhx.zzY("ContentFetchTask: waiting");
                        this.zznh.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    boolean zzf(final View view) {
        if (view == null) {
            return false;
        }
        view.post(new Runnable(){

            @Override
            public void run() {
                zzan.this.zzg(view);
            }
        });
        return true;
    }

    void zzg(View view) {
        try {
            zzak zzak2 = new zzak(this.zznW, this.zzop, this.zznY, this.zzoq);
            zza zza2 = this.zza(view, zzak2);
            zzak2.zzbq();
            if (zza2.zzox == 0 && zza2.zzoy == 0) {
                return;
            }
            if (zza2.zzoy == 0 && zzak2.zzbr() == 0) {
                return;
            }
            if (zza2.zzoy == 0 && this.zzom.zza(zzak2)) {
                return;
            }
            this.zzom.zzc(zzak2);
        }
        catch (Exception exception) {
            zzhx.zzb("Exception in fetchContentOnUIThread", exception);
            this.zzon.zzb(exception);
        }
    }

    boolean zzk(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (powerManager == null) {
            return false;
        }
        return powerManager.isScreenOn();
    }

    boolean zzbu() {
        try {
            Context context = this.zzol.getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !this.zzk(context)) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    void zza(Activity activity) {
        if (activity == null) {
            return;
        }
        View view = null;
        if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
            view = activity.getWindow().getDecorView().findViewById(0x1020002);
        }
        if (view == null) {
            return;
        }
        this.zzf(view);
    }

    zza zza(View view, zzak zzak2) {
        if (view == null) {
            return new zza(0, 0);
        }
        if (view instanceof TextView && !(view instanceof EditText)) {
            TextView textView = (TextView)view;
            CharSequence charSequence = textView.getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string2 = charSequence.toString();
                zzak2.zzi(string2);
                return new zza(1, 0);
            }
            return new zza(0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzic)) {
            zzak2.zzbp();
            if (this.zza((WebView)view, zzak2)) {
                return new zza(0, 1);
            }
            return new zza(0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zza zza2 = this.zza(viewGroup.getChildAt(i), zzak2);
                n += zza2.zzox;
                n2 += zza2.zzoy;
            }
            return new zza(n, n2);
        }
        return new zza(0, 0);
    }

    boolean zza(final WebView webView, final zzak zzak2) {
        if (!zzme.zzkj()) {
            return false;
        }
        zzak2.zzbp();
        webView.post(new Runnable(){
            ValueCallback<String> zzot = new ValueCallback<String>(){

                public void zzk(String string2) {
                    zzan.this.zza(zzak2, webView, string2);
                }

                public /* synthetic */ void onReceiveValue(Object x0) {
                    this.zzk((String)x0);
                }
            };

            @Override
            public void run() {
                if (webView.getSettings().getJavaScriptEnabled()) {
                    try {
                        webView.evaluateJavascript("(function() { return  {text:document.body.innerText}})();", this.zzot);
                    }
                    catch (Throwable throwable) {
                        this.zzot.onReceiveValue((Object)"");
                    }
                }
            }
        });
        return true;
    }

    void zza(zzak zzak2, WebView webView, String string2) {
        zzak2.zzbo();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                JSONObject jSONObject = new JSONObject(string2);
                String string3 = jSONObject.optString("text");
                if (!TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    zzak2.zzh(webView.getTitle() + "\n" + string3);
                } else {
                    zzak2.zzh(string3);
                }
            }
            if (zzak2.zzbl()) {
                this.zzom.zzb(zzak2);
            }
        }
        catch (JSONException jSONException) {
            zzhx.zzY("Json string may be malformed.");
        }
        catch (Throwable throwable) {
            zzhx.zza("Failed to get webview content.", throwable);
            this.zzon.zzb(throwable);
        }
    }

    public zzak zzbv() {
        return this.zzom.zzbs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        Object object = this.zznh;
        synchronized (object) {
            this.zzoj = false;
            this.zznh.notifyAll();
            zzhx.zzY("ContentFetchThread: wakeup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzbw() {
        Object object = this.zznh;
        synchronized (object) {
            this.zzoj = true;
            zzhx.zzY("ContentFetchThread: paused, mPause = " + this.zzoj);
        }
    }

    public boolean zzbx() {
        return this.zzoj;
    }

    @zzgi
    class zza {
        final int zzox;
        final int zzoy;

        zza(int n, int n2) {
            this.zzox = n;
            this.zzoy = n2;
        }
    }
}

