/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.PowerManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.internal.zzab;
import com.google.android.gms.internal.zzac;
import com.google.android.gms.internal.zzad;
import com.google.android.gms.internal.zzag;
import com.google.android.gms.internal.zzah;
import com.google.android.gms.internal.zzba;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zzdf;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzhe;
import com.google.android.gms.internal.zzhx;
import com.google.android.gms.internal.zzhy;
import com.google.android.gms.internal.zzia;
import com.google.android.gms.internal.zzic;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzgi
public class zzaf
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private final Object zznh = new Object();
    private final WeakReference<zzhe> zznn;
    private WeakReference<ViewTreeObserver> zzno;
    private final WeakReference<View> zznp;
    private final zzad zznq;
    private final Context zznk;
    private final zzdf zznr;
    private final zzia<zzah> zzns;
    private boolean zznt;
    private final WindowManager zznu;
    private final PowerManager zznv;
    private final KeyguardManager zznw;
    private zzag zznx;
    private boolean zzmJ = false;
    private boolean zzny = false;
    private long zznz = Long.MIN_VALUE;
    private boolean zznA;
    private boolean zznB;
    private BroadcastReceiver zznC;
    private final HashSet<zzac> zznD = new HashSet();
    private final zzcv zznE = new zzcv(){

        @Override
        public void zza(zzic zzic2, Map<String, String> map) {
            if (!zzaf.this.zza(map)) {
                return;
            }
            zzaf.this.zza((View)zzic2.getWebView(), map);
        }
    };
    private final zzcv zznF = new zzcv(){

        @Override
        public void zza(zzic zzic2, Map<String, String> map) {
            if (!zzaf.this.zza(map)) {
                return;
            }
            zzhx.zzY("Received request to untrack: " + zzaf.this.zznq.zzaZ());
            zzaf.this.destroy();
        }
    };
    private final zzcv zznG = new zzcv(){

        @Override
        public void zza(zzic zzic2, Map<String, String> map) {
            if (!zzaf.this.zza(map)) {
                return;
            }
            if (!map.containsKey("isVisible")) {
                return;
            }
            Boolean bl = "1".equals(map.get("isVisible")) || "true".equals(map.get("isVisible"));
            zzaf.this.zzg(bl);
        }
    };

    public zzaf(zzba zzba2, zzhe zzhe2, zzhy zzhy2, View view, zzdf zzdf2) {
        this.zznr = zzdf2;
        this.zznn = new WeakReference<zzhe>(zzhe2);
        this.zznp = new WeakReference<View>(view);
        this.zzno = new WeakReference<Object>(null);
        this.zznA = true;
        this.zznq = new zzad(UUID.randomUUID().toString(), zzhy2, zzba2.zzpa, zzhe2.zzys, zzhe2.zzba());
        this.zzns = this.zznr.zzcJ();
        this.zznu = (WindowManager)view.getContext().getSystemService("window");
        this.zznv = (PowerManager)view.getContext().getApplicationContext().getSystemService("power");
        this.zznw = (KeyguardManager)view.getContext().getSystemService("keyguard");
        this.zznk = view.getContext().getApplicationContext();
        try {
            final JSONObject jSONObject = this.zzd(view);
            this.zzns.zza(new zzia.zzd<zzah>(){

                public void zzb(zzah zzah2) {
                    zzaf.this.zza(jSONObject);
                }

                @Override
                public /* synthetic */ void zza(Object object) {
                    this.zzb((zzah)object);
                }
            }, new zzia.zza(){

                @Override
                public void run() {
                }
            });
        }
        catch (JSONException jSONException) {
        }
        catch (RuntimeException runtimeException) {
            zzhx.zzb("Failure while processing active view data.", runtimeException);
        }
        this.zzns.zza(new zzia.zzd<zzah>(){

            public void zzb(zzah zzah2) {
                zzaf.this.zznt = true;
                zzaf.this.zza(zzah2);
                zzaf.this.zzbb();
                zzaf.this.zzh(false);
            }

            @Override
            public /* synthetic */ void zza(Object object) {
                this.zzb((zzah)object);
            }
        }, new zzia.zza(){

            @Override
            public void run() {
                zzaf.this.destroy();
            }
        });
        zzhx.zzY("Tracking ad unit: " + this.zznq.zzaZ());
    }

    public void zza(zzac zzac2) {
        this.zznD.add(zzac2);
    }

    protected void zzg(boolean bl) {
        for (zzac zzac2 : this.zznD) {
            zzac2.zza(this, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzbb() {
        Object object = this.zznh;
        synchronized (object) {
            if (this.zznC != null) {
                return;
            }
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            this.zznC = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    zzaf.this.zzh(false);
                }
            };
            this.zznk.registerReceiver(this.zznC, intentFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzbc() {
        Object object = this.zznh;
        synchronized (object) {
            if (this.zznC != null) {
                this.zznk.unregisterReceiver(this.zznC);
                this.zznC = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        Object object = this.zznh;
        synchronized (object) {
            this.zzbh();
            this.zzbc();
            this.zznA = false;
            this.zzbe();
            this.zznr.zzb(this.zzns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzbd() {
        Object object = this.zznh;
        synchronized (object) {
            if (this.zznA) {
                this.zznB = true;
                try {
                    JSONObject jSONObject = this.zzbj();
                    this.zza(jSONObject);
                }
                catch (JSONException jSONException) {
                    zzhx.zzb("JSON failure while processing active view data.", jSONException);
                }
                catch (RuntimeException runtimeException) {
                    zzhx.zzb("Failure while processing active view data.", runtimeException);
                }
                zzhx.zzY("Untracking ad unit: " + this.zznq.zzaZ());
            }
        }
    }

    protected void zza(View view, Map<String, String> map) {
        this.zzh(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzh(boolean bl) {
        Object object = this.zznh;
        synchronized (object) {
            boolean bl2;
            if (!this.zznt || !this.zznA) {
                return;
            }
            long l = zzab.zzaQ().elapsedRealtime();
            if (bl && this.zznz + 200L > l) {
                return;
            }
            this.zznz = l;
            zzhe zzhe2 = (zzhe)this.zznn.get();
            View view = (View)this.zznp.get();
            boolean bl3 = bl2 = view == null || zzhe2 == null;
            if (bl2) {
                this.zzbd();
                return;
            }
            try {
                JSONObject jSONObject = this.zzd(view);
                this.zza(jSONObject);
            }
            catch (JSONException jSONException) {
                zzhx.zza("Active view update failed.", jSONException);
            }
            catch (RuntimeException runtimeException) {
                zzhx.zza("Active view update failed.", runtimeException);
            }
            this.zzbg();
            this.zzbe();
        }
    }

    protected void zzbe() {
        if (this.zznx != null) {
            this.zznx.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzbf() {
        Object object = this.zznh;
        synchronized (object) {
            return this.zznA;
        }
    }

    protected int zza(int n, DisplayMetrics displayMetrics) {
        float f = displayMetrics.density;
        return (int)((float)n / f);
    }

    protected void zzbg() {
        View view = (View)this.zznp.get();
        if (view == null) {
            return;
        }
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzno.get();
        ViewTreeObserver viewTreeObserver2 = view.getViewTreeObserver();
        if (viewTreeObserver2 == viewTreeObserver) {
            return;
        }
        this.zzno = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
        viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    protected boolean zza(Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.zznq.zzaZ());
    }

    protected void zza(zzah zzah2) {
        zzah2.zza("/updateActiveView", this.zznE);
        zzah2.zza("/untrackActiveViewUnit", this.zznF);
        zzah2.zza("/visibilityChanged", this.zznG);
    }

    protected void zzbh() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzno.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    protected JSONObject zzbi() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("afmaVersion", (Object)this.zznq.zzaX()).put("activeViewJSON", (Object)this.zznq.zzaY()).put("timestamp", zzab.zzaQ().elapsedRealtime()).put("adFormat", (Object)this.zznq.zzaW()).put("hashCode", (Object)this.zznq.zzaZ()).put("isMraid", this.zznq.zzba());
        return jSONObject;
    }

    protected void zza(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = new JSONArray();
            final JSONObject jSONObject2 = new JSONObject();
            jSONArray.put((Object)jSONObject);
            jSONObject2.put("units", (Object)jSONArray);
            this.zzns.zza(new zzia.zzd<zzah>(){

                public void zzb(zzah zzah2) {
                    zzah2.zza("AFMA_updateActiveView", jSONObject2);
                }

                @Override
                public /* synthetic */ void zza(Object object) {
                    this.zzb((zzah)object);
                }
            }, new zzia.zza(){

                @Override
                public void run() {
                }
            });
        }
        catch (Throwable throwable) {
            zzhx.zzb("Skipping active view message.", throwable);
        }
    }

    protected JSONObject zzd(View view) throws JSONException {
        boolean bl = zzab.zzaO().zzi(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            zzhx.zzb("Failure getting view location.", exception);
        }
        DisplayMetrics displayMetrics = view.getContext().getResources().getDisplayMetrics();
        Rect rect = new Rect();
        rect.left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        rect2.right = this.zznu.getDefaultDisplay().getWidth();
        rect2.bottom = this.zznu.getDefaultDisplay().getHeight();
        Rect rect3 = new Rect();
        boolean bl2 = view.getGlobalVisibleRect(rect3, null);
        Rect rect4 = new Rect();
        boolean bl3 = view.getLocalVisibleRect(rect4);
        Rect rect5 = new Rect();
        view.getHitRect(rect5);
        JSONObject jSONObject = this.zzbi();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isStopped", this.zzny).put("isPaused", this.zzmJ).put("isAttachedToWindow", bl).put("viewBox", (Object)new JSONObject().put("top", this.zza(rect2.top, displayMetrics)).put("bottom", this.zza(rect2.bottom, displayMetrics)).put("left", this.zza(rect2.left, displayMetrics)).put("right", this.zza(rect2.right, displayMetrics))).put("adBox", (Object)new JSONObject().put("top", this.zza(rect.top, displayMetrics)).put("bottom", this.zza(rect.bottom, displayMetrics)).put("left", this.zza(rect.left, displayMetrics)).put("right", this.zza(rect.right, displayMetrics))).put("globalVisibleBox", (Object)new JSONObject().put("top", this.zza(rect3.top, displayMetrics)).put("bottom", this.zza(rect3.bottom, displayMetrics)).put("left", this.zza(rect3.left, displayMetrics)).put("right", this.zza(rect3.right, displayMetrics))).put("globalVisibleBoxVisible", bl2).put("localVisibleBox", (Object)new JSONObject().put("top", this.zza(rect4.top, displayMetrics)).put("bottom", this.zza(rect4.bottom, displayMetrics)).put("left", this.zza(rect4.left, displayMetrics)).put("right", this.zza(rect4.right, displayMetrics))).put("localVisibleBoxVisible", bl3).put("hitBox", (Object)new JSONObject().put("top", this.zza(rect5.top, displayMetrics)).put("bottom", this.zza(rect5.bottom, displayMetrics)).put("left", this.zza(rect5.left, displayMetrics)).put("right", this.zza(rect5.right, displayMetrics))).put("screenDensity", (double)displayMetrics.density).put("isVisible", this.zze(view));
        return jSONObject;
    }

    protected boolean zze(View view) {
        return view.getVisibility() == 0 && view.isShown() && this.zznv.isScreenOn() && (!this.zznw.inKeyguardRestrictedInputMode() || zzab.zzaM().zzes());
    }

    protected JSONObject zzbj() throws JSONException {
        JSONObject jSONObject = this.zzbi();
        jSONObject.put("doneReasonCode", (Object)"u");
        return jSONObject;
    }

    public void onScrollChanged() {
        this.zzh(true);
    }

    public void onGlobalLayout() {
        this.zzh(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(zzag zzag2) {
        Object object = this.zznh;
        synchronized (object) {
            this.zznx = zzag2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.zznh;
        synchronized (object) {
            this.zzny = true;
            this.zzh(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.zznh;
        synchronized (object) {
            this.zzmJ = true;
            this.zzh(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.zznh;
        synchronized (object) {
            this.zzmJ = false;
            this.zzh(false);
        }
    }
}

