/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzbo;
import java.util.Date;
import java.util.Set;

public final class AdRequest {
    public static final int ERROR_CODE_INTERNAL_ERROR = 0;
    public static final int ERROR_CODE_INVALID_REQUEST = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 2;
    public static final int ERROR_CODE_NO_FILL = 3;
    public static final int GENDER_UNKNOWN = 0;
    public static final int GENDER_MALE = 1;
    public static final int GENDER_FEMALE = 2;
    public static final int MAX_CONTENT_URL_LENGTH = 512;
    public static final String DEVICE_ID_EMULATOR = zzbo.DEVICE_ID_EMULATOR;
    private final zzbo zzlg;

    private AdRequest(Builder builder) {
        this.zzlg = new zzbo(builder.zzlh);
    }

    public Date getBirthday() {
        return this.zzlg.getBirthday();
    }

    public String getContentUrl() {
        return this.zzlg.getContentUrl();
    }

    public int getGender() {
        return this.zzlg.getGender();
    }

    public Set<String> getKeywords() {
        return this.zzlg.getKeywords();
    }

    public Location getLocation() {
        return this.zzlg.getLocation();
    }

    @Deprecated
    public <T extends NetworkExtras> T getNetworkExtras(Class<T> networkExtrasClass) {
        return this.zzlg.getNetworkExtras(networkExtrasClass);
    }

    public <T extends MediationAdapter> Bundle getNetworkExtrasBundle(Class<T> adapterClass) {
        return this.zzlg.getNetworkExtrasBundle(adapterClass);
    }

    public <T extends CustomEvent> Bundle getCustomEventExtrasBundle(Class<T> adapterClass) {
        return this.zzlg.getCustomEventExtrasBundle(adapterClass);
    }

    public boolean isTestDevice(Context context) {
        return this.zzlg.isTestDevice(context);
    }

    zzbo zzY() {
        return this.zzlg;
    }

    public static final class Builder {
        private final zzbo.zza zzlh = new zzbo.zza();

        public Builder() {
            this.zzlh.zzs(DEVICE_ID_EMULATOR);
        }

        public Builder addKeyword(String keyword) {
            this.zzlh.zzr(keyword);
            return this;
        }

        public Builder addNetworkExtras(NetworkExtras networkExtras) {
            this.zzlh.zza(networkExtras);
            return this;
        }

        public Builder addNetworkExtrasBundle(Class<? extends MediationAdapter> adapterClass, Bundle networkExtras) {
            this.zzlh.zza(adapterClass, networkExtras);
            if (adapterClass.equals(AdMobAdapter.class) && networkExtras.getBoolean("_emulatorLiveAds")) {
                this.zzlh.zzt(DEVICE_ID_EMULATOR);
            }
            return this;
        }

        public Builder addCustomEventExtrasBundle(Class<? extends CustomEvent> adapterClass, Bundle customEventExtras) {
            this.zzlh.zzb(adapterClass, customEventExtras);
            return this;
        }

        public Builder addTestDevice(String deviceId) {
            this.zzlh.zzs(deviceId);
            return this;
        }

        public AdRequest build() {
            return new AdRequest(this);
        }

        public Builder setBirthday(Date birthday) {
            this.zzlh.zza(birthday);
            return this;
        }

        public Builder setContentUrl(String contentUrl) {
            zzx.zzb((Object)contentUrl, (Object)"Content URL must be non-null.");
            zzx.zzb((String)contentUrl, (Object)"Content URL must be non-empty.");
            zzx.zzb((contentUrl.length() <= 512 ? 1 : 0) != 0, (String)"Content URL must not exceed %d in length.  Provided length was %d.", (Object[])new Object[]{512, contentUrl.length()});
            this.zzlh.zzu(contentUrl);
            return this;
        }

        public Builder setGender(int gender) {
            this.zzlh.zzh(gender);
            return this;
        }

        public Builder setLocation(Location location) {
            this.zzlh.zza(location);
            return this;
        }

        public Builder setRequestAgent(String requestAgent) {
            this.zzlh.zzw(requestAgent);
            return this;
        }

        public Builder tagForChildDirectedTreatment(boolean tagForChildDirectedTreatment) {
            this.zzlh.zzk(tagForChildDirectedTreatment);
            return this;
        }
    }
}

