/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.MutableContextWrapper;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.google.android.gms.internal.ay;
import com.google.android.gms.internal.dp;
import com.google.android.gms.internal.ey;
import com.google.android.gms.internal.gi;
import com.google.android.gms.internal.gm;
import com.google.android.gms.internal.go;
import com.google.android.gms.internal.gr;
import com.google.android.gms.internal.gs;
import com.google.android.gms.internal.gv;
import com.google.android.gms.internal.gw;
import com.google.android.gms.internal.gx;
import com.google.android.gms.internal.gy;
import com.google.android.gms.internal.k;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@ey
public class gu
extends WebView
implements DownloadListener {
    private final gv wW;
    private final a wX;
    private final Object mH = new Object();
    private final k tl;
    private final gs qJ;
    private dp wY;
    private ay qI;
    private boolean wZ;
    private boolean xa;
    private boolean xb;
    private boolean xc;
    private final WindowManager mR;

    public static gu a(Context context, ay ay2, boolean bl2, boolean bl3, k k2, gs gs2) {
        a a2 = new a(context);
        return new gu(a2, ay2, bl2, bl3, k2, gs2);
    }

    protected gu(a a2, ay ay2, boolean bl2, boolean bl3, k k2, gs gs2) {
        super((Context)a2);
        this.wX = a2;
        this.qI = ay2;
        this.wZ = bl2;
        this.tl = k2;
        this.qJ = gs2;
        this.mR = (WindowManager)this.getContext().getSystemService("window");
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        gi.a((Context)a2, gs2.wS, webSettings);
        if (Build.VERSION.SDK_INT >= 17) {
            go.a(this.getContext(), webSettings);
        } else if (Build.VERSION.SDK_INT >= 11) {
            gm.a(this.getContext(), webSettings);
        }
        this.setDownloadListener(this);
        this.wW = Build.VERSION.SDK_INT >= 11 ? new gx(this, bl3) : new gv(this, bl3);
        this.setWebViewClient(this.wW);
        if (Build.VERSION.SDK_INT >= 14) {
            this.setWebChromeClient(new gy(this));
        } else if (Build.VERSION.SDK_INT >= 11) {
            this.setWebChromeClient(new gw(this));
        }
        this.dJ();
    }

    public void cb() {
        if (!this.dD().dN()) {
            return;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Display display = this.mR.getDefaultDisplay();
        display.getMetrics(displayMetrics);
        int n = gi.s(this.getContext());
        float f = 160.0f / (float)displayMetrics.densityDpi;
        int n2 = Math.round((float)displayMetrics.widthPixels * f);
        int n3 = Math.round((float)(displayMetrics.heightPixels - n) * f);
        try {
            JSONObject jSONObject = new JSONObject().put("width", n2).put("height", n3).put("density", (double)displayMetrics.density).put("rotation", display.getRotation());
            this.b("onScreenInfoChanged", jSONObject);
        }
        catch (JSONException jSONException) {
            gr.b("Error occured while obtaining screen information.", jSONException);
        }
    }

    public void a(String string, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = gi.t(map);
        }
        catch (JSONException jSONException) {
            gr.W("Could not convert parameters to JSON.");
            return;
        }
        this.b(string, jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateJavascript(String script, ValueCallback<String> resultCallback) {
        Object object = this.mH;
        synchronized (object) {
            if (this.isDestroyed()) {
                gr.W("The webview is destroyed. Ignoring action.");
                if (resultCallback != null) {
                    resultCallback.onReceiveValue(null);
                }
                return;
            }
            super.evaluateJavascript(script, resultCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void X(String string) {
        Object object = this.mH;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.loadUrl(string);
            } else {
                gr.W("The webview is destroyed. Ignoring action.");
            }
        }
    }

    public void a(String string, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string2 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("javascript:" + string + "(");
        stringBuilder.append(string2);
        stringBuilder.append(");");
        this.X(stringBuilder.toString());
    }

    public void b(String string, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string2 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("javascript:AFMA_ReceiveMessage('");
        stringBuilder.append(string);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string2);
        stringBuilder.append(");");
        gr.V("Dispatching AFMA event: " + stringBuilder);
        this.X(stringBuilder.toString());
    }

    public void cj() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.qJ.wS);
        this.a("onhide", hashMap);
    }

    public void ci() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.qJ.wS);
        this.a("onshow", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public dp dC() {
        Object object = this.mH;
        synchronized (object) {
            return this.wY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ay ac() {
        Object object = this.mH;
        synchronized (object) {
            return this.qI;
        }
    }

    public gv dD() {
        return this.wW;
    }

    public boolean dE() {
        return this.xc;
    }

    public k dF() {
        return this.tl;
    }

    public gs dG() {
        return this.qJ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dH() {
        Object object = this.mH;
        synchronized (object) {
            return this.wZ;
        }
    }

    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long size) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)url), mimeType);
            this.getContext().startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            gr.S("Couldn't find an Activity to view url/mimetype: " + url + " / " + mimeType);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.tl != null) {
            this.tl.a(event);
        }
        return super.onTouchEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Object object = this.mH;
        synchronized (object) {
            if (this.isInEditMode() || this.wZ) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                return;
            }
            int n = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int n2 = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int n3 = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int n4 = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int n5 = Integer.MAX_VALUE;
            if (n == Integer.MIN_VALUE || n == 0x40000000) {
                n5 = n2;
            }
            int n6 = Integer.MAX_VALUE;
            if (n3 == Integer.MIN_VALUE || n3 == 0x40000000) {
                n6 = n4;
            }
            if (this.qI.widthPixels > n5 || this.qI.heightPixels > n6) {
                float f = this.wX.getResources().getDisplayMetrics().density;
                gr.W("Not enough space to show ad. Needs " + (int)((float)this.qI.widthPixels / f) + "x" + (int)((float)this.qI.heightPixels / f) + " dp, but only has " + (int)((float)n2 / f) + "x" + (int)((float)n4 / f) + " dp.");
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.qI.widthPixels, this.qI.heightPixels);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(Context context, ay ay2) {
        Object object = this.mH;
        synchronized (object) {
            this.wX.setBaseContext(context);
            this.wY = null;
            this.qI = ay2;
            this.wZ = false;
            this.xc = false;
            gi.b(this);
            this.loadUrl("about:blank");
            this.wW.reset();
            this.setOnTouchListener(null);
            this.setOnClickListener(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(dp dp2) {
        Object object = this.mH;
        synchronized (object) {
            this.wY = dp2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(ay ay2) {
        Object object = this.mH;
        synchronized (object) {
            this.qI = ay2;
            this.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void z(boolean bl2) {
        Object object = this.mH;
        synchronized (object) {
            this.wZ = bl2;
            this.dJ();
        }
    }

    public void setContext(Context context) {
        this.wX.setBaseContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void q(boolean bl2) {
        Object object = this.mH;
        synchronized (object) {
            if (this.wY != null) {
                this.wY.q(bl2);
            } else {
                this.xc = bl2;
            }
        }
    }

    public Context dI() {
        return this.wX.dI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dJ() {
        Object object = this.mH;
        synchronized (object) {
            if (this.wZ || this.qI.oq) {
                if (Build.VERSION.SDK_INT < 14) {
                    gr.S("Disabling hardware acceleration on an overlay.");
                    this.dK();
                } else {
                    gr.S("Enabling hardware acceleration on an overlay.");
                    this.dL();
                }
            } else if (Build.VERSION.SDK_INT < 18) {
                gr.S("Disabling hardware acceleration on an AdView.");
                this.dK();
            } else {
                gr.S("Enabling hardware acceleration on an AdView.");
                this.dL();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dK() {
        Object object = this.mH;
        synchronized (object) {
            if (!this.xa && Build.VERSION.SDK_INT >= 11) {
                gm.i((View)this);
            }
            this.xa = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dL() {
        Object object = this.mH;
        synchronized (object) {
            if (this.xa && Build.VERSION.SDK_INT >= 11) {
                gm.j((View)this);
            }
            this.xa = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.mH;
        synchronized (object) {
            if (this.wY != null) {
                this.wY.close();
            }
            this.xb = true;
            super.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDestroyed() {
        Object object = this.mH;
        synchronized (object) {
            return this.xb;
        }
    }

    @ey
    protected static class a
    extends MutableContextWrapper {
        private Activity xd;
        private Context mO;

        public a(Context context) {
            super(context);
            this.setBaseContext(context);
        }

        public void setBaseContext(Context base) {
            this.mO = base.getApplicationContext();
            this.xd = base instanceof Activity ? (Activity)base : null;
            super.setBaseContext(this.mO);
        }

        public void startActivity(Intent intent) {
            if (this.xd != null) {
                this.xd.startActivity(intent);
            } else {
                intent.setFlags(0x10000000);
                this.mO.startActivity(intent);
            }
        }

        public Context dI() {
            return this.xd;
        }
    }
}

