/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Rect;
import android.net.Uri;
import android.net.UrlQuerySanitizer;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.google.android.gms.internal.ey;
import com.google.android.gms.internal.gm;
import com.google.android.gms.internal.go;
import com.google.android.gms.internal.gp;
import com.google.android.gms.internal.gq;
import com.google.android.gms.internal.gr;
import java.io.IOException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.nio.CharBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@ey
public final class gi {
    private static final Object ut = new Object();
    private static final SimpleDateFormat[] wB = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"), new SimpleDateFormat("yyyyMMdd")};
    private static boolean wC = true;
    private static String wD;
    private static boolean wE;

    public static void a(Context context, String string2, boolean bl2, HttpURLConnection httpURLConnection) {
        gi.a(context, string2, bl2, httpURLConnection, false);
    }

    public static void a(Context context, String string2, boolean bl2, HttpURLConnection httpURLConnection, boolean bl3) {
        httpURLConnection.setConnectTimeout(60000);
        httpURLConnection.setInstanceFollowRedirects(bl2);
        httpURLConnection.setReadTimeout(60000);
        httpURLConnection.setRequestProperty("User-Agent", gi.c(context, string2));
        httpURLConnection.setUseCaches(bl3);
    }

    public static void a(Context context, String string2, boolean bl2, HttpURLConnection httpURLConnection, String string3) {
        httpURLConnection.setConnectTimeout(60000);
        httpURLConnection.setInstanceFollowRedirects(bl2);
        httpURLConnection.setReadTimeout(60000);
        httpURLConnection.setRequestProperty("User-Agent", string3);
        httpURLConnection.setUseCaches(false);
    }

    public static boolean p(Context context) {
        Intent intent = new Intent();
        intent.setClassName(context, "com.google.android.gms.ads.AdActivity");
        PackageManager packageManager = context.getPackageManager();
        ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
        boolean bl2 = true;
        if (resolveInfo == null || resolveInfo.activityInfo == null) {
            gr.W("Could not find com.google.android.gms.ads.AdActivity, please make sure it is declared in AndroidManifest.xml.");
            bl2 = false;
        } else {
            String string2 = "com.google.android.gms.ads.AdActivity requires the android:configChanges value to contain \"%s\".";
            if ((resolveInfo.activityInfo.configChanges & 0x10) == 0) {
                gr.W(String.format(string2, "keyboard"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x20) == 0) {
                gr.W(String.format(string2, "keyboardHidden"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x80) == 0) {
                gr.W(String.format(string2, "orientation"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x100) == 0) {
                gr.W(String.format(string2, "screenLayout"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x200) == 0) {
                gr.W(String.format(string2, "uiMode"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x400) == 0) {
                gr.W(String.format(string2, "screenSize"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x800) == 0) {
                gr.W(String.format(string2, "smallestScreenSize"));
                bl2 = false;
            }
        }
        return bl2;
    }

    public static boolean a(PackageManager packageManager, String string2, String string3) {
        return packageManager.checkPermission(string3, string2) == 0;
    }

    public static boolean dt() {
        return wC;
    }

    public static int du() {
        return Build.VERSION.SDK_INT >= 9 ? 6 : 0;
    }

    public static int dv() {
        return Build.VERSION.SDK_INT >= 9 ? 7 : 1;
    }

    public static void a(Context context, String string2, List<String> list) {
        for (String string3 : list) {
            new gp(context, string2, string3).start();
        }
    }

    public static void c(Context context, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        gi.a(context, string2, arrayList);
    }

    public static void a(Context context, String string2, List<String> list, String string3) {
        for (String string4 : list) {
            new gp(context, string2, string4, string3).start();
        }
    }

    public static String a(Readable readable) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        CharBuffer charBuffer = CharBuffer.allocate(2048);
        while ((n = readable.read(charBuffer)) != -1) {
            charBuffer.flip();
            stringBuilder.append(charBuffer, 0, n);
        }
        return stringBuilder.toString();
    }

    public static void q(Context context) {
        if (wE) {
            return;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        context.getApplicationContext().registerReceiver((BroadcastReceiver)new a(), intentFilter);
        wE = true;
    }

    public static void a(Context context, String string2, WebSettings webSettings) {
        webSettings.setUserAgentString(gi.c(context, string2));
    }

    static String dw() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("Mozilla/5.0 (Linux; U; Android");
        if (Build.VERSION.RELEASE != null) {
            stringBuffer.append(" ").append(Build.VERSION.RELEASE);
        }
        stringBuffer.append("; ").append(Locale.getDefault());
        if (Build.DEVICE != null) {
            stringBuffer.append("; ").append(Build.DEVICE);
            if (Build.DISPLAY != null) {
                stringBuffer.append(" Build/").append(Build.DISPLAY);
            }
        }
        stringBuffer.append(") AppleWebKit/533 Version/4.0 Safari/533");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String c(final Context context, String string2) {
        Object object = ut;
        synchronized (object) {
            if (wD != null) {
                return wD;
            }
            if (Build.VERSION.SDK_INT >= 17) {
                try {
                    wD = go.getDefaultUserAgent(context);
                    wD = wD + " (Mobile; " + string2 + ")";
                    return wD;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!gq.dB()) {
                gq.wR.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = ut;
                        synchronized (object) {
                            wD = gi.r(context);
                            ut.notifyAll();
                        }
                    }
                });
                while (wD == null) {
                    try {
                        ut.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        wD = gi.dw();
                        gr.W("Interrupted, use default user agent: " + wD);
                    }
                }
            } else {
                try {
                    wD = gi.r(context);
                }
                catch (Exception exception) {
                    wD = gi.dw();
                }
            }
            wD = wD + " (Mobile; " + string2 + ")";
            return wD;
        }
    }

    private static String r(Context context) {
        return new WebView(context).getSettings().getUserAgentString();
    }

    public static boolean a(ClassLoader classLoader, Class<?> clazz, String string2) {
        try {
            Class<?> clazz2 = Class.forName(string2, false, classLoader);
            return clazz.isAssignableFrom(clazz2);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String L(String string2) {
        return Uri.parse((String)string2).buildUpon().query(null).build().toString();
    }

    public static JSONObject t(Map<String, ?> map) throws JSONException {
        try {
            JSONObject jSONObject = new JSONObject();
            for (String string2 : map.keySet()) {
                gi.a(jSONObject, string2, map.get(string2));
            }
            return jSONObject;
        }
        catch (ClassCastException classCastException) {
            throw new JSONException("Could not convert map to JSON: " + classCastException.getMessage());
        }
    }

    private static JSONObject c(Bundle bundle) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string2 : bundle.keySet()) {
            gi.a(jSONObject, string2, bundle.get(string2));
        }
        return jSONObject;
    }

    private static JSONArray a(Collection<?> collection) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object obj : collection) {
            gi.a(jSONArray, obj);
        }
        return jSONArray;
    }

    static JSONArray a(Object[] objectArray) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object object : objectArray) {
            gi.a(jSONArray, object);
        }
        return jSONArray;
    }

    private static void a(JSONArray jSONArray, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONArray.put((Object)gi.c((Bundle)object));
        } else if (object instanceof Map) {
            Map map = (Map)object;
            jSONArray.put((Object)gi.t(map));
        } else if (object instanceof Collection) {
            jSONArray.put((Object)gi.a((Collection)object));
        } else if (object instanceof Object[]) {
            jSONArray.put((Object)gi.a((Object[])object));
        } else {
            jSONArray.put(object);
        }
    }

    private static void a(JSONObject jSONObject, String string2, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONObject.put(string2, (Object)gi.c((Bundle)object));
        } else if (object instanceof Map) {
            Map map = (Map)object;
            jSONObject.put(string2, (Object)gi.t(map));
        } else if (object instanceof Collection) {
            jSONObject.put(string2 != null ? string2 : "null", (Object)gi.a((Collection)object));
        } else if (object instanceof Object[]) {
            jSONObject.put(string2, (Object)gi.a(Arrays.asList((Object[])object)));
        } else {
            jSONObject.put(string2, object);
        }
    }

    public static Map<String, String> c(Uri uri) {
        if (uri == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        UrlQuerySanitizer urlQuerySanitizer = new UrlQuerySanitizer();
        urlQuerySanitizer.setAllowUnregisteredParamaters(true);
        urlQuerySanitizer.setUnregisteredParameterValueSanitizer(UrlQuerySanitizer.getAllButNulLegal());
        urlQuerySanitizer.parseUrl(uri.toString());
        List list = urlQuerySanitizer.getParameterList();
        for (UrlQuerySanitizer.ParameterValuePair parameterValuePair : list) {
            hashMap.put(parameterValuePair.mParameter, parameterValuePair.mValue);
        }
        return hashMap;
    }

    public static void a(WebView webView) {
        if (Build.VERSION.SDK_INT >= 11) {
            gm.a(webView);
        }
    }

    public static void b(WebView webView) {
        if (Build.VERSION.SDK_INT >= 11) {
            gm.b(webView);
        }
    }

    public static String dx() {
        UUID uUID = UUID.randomUUID();
        byte[] byArray = BigInteger.valueOf(uUID.getLeastSignificantBits()).toByteArray();
        byte[] byArray2 = BigInteger.valueOf(uUID.getMostSignificantBits()).toByteArray();
        String string2 = new BigInteger(1, byArray).toString();
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(byArray);
                messageDigest.update(byArray2);
                byte[] byArray3 = new byte[8];
                System.arraycopy(messageDigest.digest(), 0, byArray3, 0, 8);
                string2 = new BigInteger(1, byArray3).toString();
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return string2;
    }

    public static int s(Context context) {
        int n = 0;
        int n2 = 0;
        if (context instanceof Activity) {
            Activity activity = (Activity)context;
            Window window = activity.getWindow();
            Rect rect = new Rect();
            window.getDecorView().getWindowVisibleDisplayFrame(rect);
            n = rect.top;
            int n3 = window.findViewById(0x1020002).getTop();
            n2 = n3 - n;
        }
        return n2 + n;
    }

    public static int M(String string2) {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            gr.W("Could not parse value:" + numberFormatException);
            return 0;
        }
    }

    public static int[] t(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Display display = windowManager.getDefaultDisplay();
        display.getMetrics(displayMetrics);
        float f = 160.0f / (float)displayMetrics.densityDpi;
        int n = (int)((float)displayMetrics.widthPixels * f);
        int n2 = (int)((float)displayMetrics.heightPixels * f);
        return new int[]{n, n2};
    }

    public static boolean N(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        return string2.matches("([^\\s]+(\\.(?i)(jpg|png|gif|bmp|webp))$)");
    }

    public static long O(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return -1L;
        }
        for (SimpleDateFormat simpleDateFormat : wB) {
            try {
                simpleDateFormat.setLenient(false);
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                return simpleDateFormat.parse(string2).getTime();
            }
            catch (ParseException parseException) {
            }
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    static {
        wE = false;
    }

    private static final class a
    extends BroadcastReceiver {
        private a() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_PRESENT".equals(intent.getAction())) {
                wC = true;
            } else if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                wC = false;
            }
        }
    }
}

