/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.purchase.InAppPurchaseListener;
import com.google.android.gms.ads.purchase.PlayStorePurchaseListener;
import com.google.android.gms.internal.bh;

public final class AdView
extends ViewGroup {
    private final bh ll;

    public AdView(Context context) {
        super(context);
        this.ll = new bh(this);
    }

    public AdView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.ll = new bh(this, attrs, false);
    }

    public AdView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.ll = new bh(this, attrs, false);
    }

    public void destroy() {
        this.ll.destroy();
    }

    public AdListener getAdListener() {
        return this.ll.getAdListener();
    }

    public AdSize getAdSize() {
        return this.ll.getAdSize();
    }

    public String getAdUnitId() {
        return this.ll.getAdUnitId();
    }

    public InAppPurchaseListener getInAppPurchaseListener() {
        return this.ll.getInAppPurchaseListener();
    }

    public void loadAd(AdRequest adRequest) {
        this.ll.a(adRequest.Y());
    }

    public void pause() {
        this.ll.pause();
    }

    public void resume() {
        this.ll.resume();
    }

    public void setAdListener(AdListener adListener) {
        this.ll.setAdListener(adListener);
    }

    public void setAdSize(AdSize adSize) {
        this.ll.setAdSizes(adSize);
    }

    public void setAdUnitId(String adUnitId) {
        this.ll.setAdUnitId(adUnitId);
    }

    public void setInAppPurchaseListener(InAppPurchaseListener inAppPurchaseListener) {
        this.ll.setInAppPurchaseListener(inAppPurchaseListener);
    }

    public void setPlayStorePurchaseParams(PlayStorePurchaseListener playStorePurchaseListener, String publicKey) {
        this.ll.setPlayStorePurchaseParams(playStorePurchaseListener, publicKey);
    }

    public String getMediationAdapterClassName() {
        return this.ll.getMediationAdapterClassName();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            int n = view.getMeasuredWidth();
            int n2 = view.getMeasuredHeight();
            int n3 = (right - left - n) / 2;
            int n4 = (bottom - top - n2) / 2;
            view.layout(n3, n4, n3 + n, n4 + n2);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n = 0;
        int n2 = 0;
        View view = this.getChildAt(0);
        AdSize adSize = this.getAdSize();
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, widthMeasureSpec, heightMeasureSpec);
            n = view.getMeasuredWidth();
            n2 = view.getMeasuredHeight();
        } else if (adSize != null) {
            Context context = this.getContext();
            n = adSize.getWidthInPixels(context);
            n2 = adSize.getHeightInPixels(context);
        }
        n = Math.max(n, this.getSuggestedMinimumWidth());
        n2 = Math.max(n2, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(View.resolveSize((int)n, (int)widthMeasureSpec), View.resolveSize((int)n2, (int)heightMeasureSpec));
    }
}

