/*
 * Decompiled with CFR 0.152.
 */
package com.android.vending.expansion.zipfile;

import android.content.Context;
import android.os.Environment;
import com.android.vending.expansion.zipfile.ZipResourceFile;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class APKExpansionSupport {
    private static final String EXP_PATH = "/Android/obb/";

    static String[] getAPKExpansionFiles(Context ctx, int mainVersion, int patchVersion) {
        File root;
        File expPath;
        String packageName = ctx.getPackageName();
        Vector<String> ret = new Vector<String>();
        if (Environment.getExternalStorageState().equals("mounted") && (expPath = new File((root = Environment.getExternalStorageDirectory()).toString() + EXP_PATH + packageName)).exists()) {
            String strPatchPath;
            String strMainPath;
            File main;
            if (mainVersion > 0 && (main = new File(strMainPath = expPath + File.separator + "main." + mainVersion + "." + packageName + ".obb")).isFile()) {
                ret.add(strMainPath);
            }
            if (patchVersion > 0 && (main = new File(strPatchPath = expPath + File.separator + "patch." + mainVersion + "." + packageName + ".obb")).isFile()) {
                ret.add(strPatchPath);
            }
        }
        String[] retArray = new String[ret.size()];
        ret.toArray(retArray);
        return retArray;
    }

    public static ZipResourceFile getResourceZipFile(String[] expansionFiles) throws IOException {
        ZipResourceFile apkExpansionFile = null;
        for (String expansionFilePath : expansionFiles) {
            if (null == apkExpansionFile) {
                apkExpansionFile = new ZipResourceFile(expansionFilePath);
                continue;
            }
            apkExpansionFile.addPatchFile(expansionFilePath);
        }
        return apkExpansionFile;
    }

    public static ZipResourceFile getAPKExpansionZipFile(Context ctx, int mainVersion, int patchVersion) throws IOException {
        String[] expansionFiles = APKExpansionSupport.getAPKExpansionFiles(ctx, mainVersion, patchVersion);
        return APKExpansionSupport.getResourceZipFile(expansionFiles);
    }
}

