package com.cybelia.sandra.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.exception.SQLGrammarException;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaId;
import org.nuiton.topia.taas.entities.TaasUser;

/**
 * @author sletellier
 */
public class NotifierProfilManager {

    private static Log log = LogFactory.getLog(NotifierProfilManager.class);

    /**
     * Recupere une entite a partir du topiaId
     */
    public static TopiaEntity getTopiaEntity(TopiaContext transaction, TaasUser user, String topiaId) throws TopiaNotFoundException, TopiaException {
        // Recuperation de l'entite associe
        Class klass = TopiaId.getClassName(topiaId);
        String alias = StringUtils.uncapitalize(klass.getSimpleName().replace("Taas", ""));
        String hql = "SELECT " + alias + " FROM " + klass.getName() + " " + alias + " WHERE " + alias + ".topiaId = :topiaId";
        List<TopiaEntity> result = NotifierProfilManager.find(transaction, klass, user, hql, "topiaId", topiaId);
        TopiaEntity entity = null;
        if (result != null && !result.isEmpty()) {
            entity = result.get(0);
        }
        return entity;
    }

    public static <T> List<T> find(TopiaContext context, Class<? extends TopiaEntity> classSearch,
                                   TaasUser user, String query, Object... args) throws TopiaException {

        return findWithBounds(context, classSearch, user, query, -1, -1, args);
    }

    public static <T> List<T> findWithBounds(TopiaContext context, Class<? extends TopiaEntity> classSearch,
                                             TaasUser user,
                                             String query, int startIndex, int endIndex, Object... args) throws TopiaException {

        String[] authorizations = NotifierSecurityHelper.getAuthorizations(user);
        if (authorizations.length > 0) {
            List<Object> argsList = new ArrayList<Object>(Arrays.asList(args));

            String queryFilter = query;
            // Ajout des éléments supplémentaires dans la requête
            if (log.isDebugEnabled()) {
              log.debug("Authorizations : " + Arrays.toString(authorizations));
            }

            String autorizations = authorizations[0];
            // Pas de filtre si l'autorisation est *
            if (!autorizations.equals("*")){
                Class<TopiaEntity> classProfil = TopiaId.getClassName(autorizations);

                Filter filter = FilterManagerProfil.getFilter(classSearch, classProfil);
                queryFilter = filter.addFilter(query);

                // Ajout des paramètres supplémentaires
                addParametersForFilter(filter, argsList, user, authorizations);
            }
            if (log.isDebugEnabled()) {
                log.debug("queryFilter : " + queryFilter);
            }

            List<T> result = null;
            try {

                if (log.isDebugEnabled()) {
                    log.debug("Execute final query : " + queryFilter);
                }

                if (startIndex != -1 && endIndex != -1){
                    result = context.find(queryFilter, startIndex, endIndex, argsList.toArray());
                } else {
                    result = context.findAll(queryFilter, argsList.toArray());
                }
            } catch (TopiaException ex){
                Throwable cause = ex.getCause();
                 if (cause instanceof SQLGrammarException) {
                    if (log.isErrorEnabled()) {
                        log.error("SQL executed with error : " + ((SQLGrammarException)cause).getSQL());
                    }
                }
                log.error("TopiaException ", ex);
            }

            if (log.isDebugEnabled()) {
                log.debug("Query filter result : " + result);
            }

            return result;
        }
        return null;
    }

    /**
     * Ajout des paramètres supplémentaires
     */
    protected static void addParametersForFilter(Filter filter, List<Object> argsList, TaasUser user, String[] authorizations) {
        if (filter.needParameter(FilterManagerProfil.PARAM_PROFIL)) {
            argsList.add(FilterManagerProfil.PARAM_PROFIL_NAME);
            argsList.add(authorizations);
        }
        if (filter.needParameter(FilterManagerProfil.PARAM_DATE_PREVIOUS_8)) {
            argsList.add(FilterManagerProfil.PARAM_DATE_PREVIOUS_8_NAME);
            Calendar calendar = Calendar.getInstance();
            calendar.add(Calendar.DAY_OF_YEAR, -8);
            argsList.add(calendar.getTime());
        }
        if (filter.needParameter(FilterManagerProfil.PARAM_USER)) {
            argsList.add(FilterManagerProfil.PARAM_USER_NAME);
            argsList.add(user.getTopiaId());
        }
    }
}
