package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.notifier.Event;
import com.cybelia.sandra.entities.notifier.EventDAO;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.csv.bean.IbuEvent;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import java.util.Arrays;
import org.nuiton.topia.TopiaException;

/**
 * @author julien
 */
public class InjectorEvent implements Injector {

    protected Event event;

    public Event getObject() {
        return event;
    }

    public void clear() {
        event = null;
    }

    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        // do nothing
    }

    public void inject(ManagerInjector manager, IbuEvent ibuEvent) throws TopiaException {

        EventDAO eventDAO = SandraDAOHelper.getEventDAO(manager.getTransaction());

        // Recherche
        event = eventDAO.findByType(ibuEvent.getType());

        if (event == null) {
            // creation
            event = eventDAO.create();
            event.setType(ibuEvent.getType());
        }

        String[] variables = ibuEvent.getVariables().split("\\|");
        event.setVariables(Arrays.asList(variables));
        eventDAO.update(event);
    }
}
