package com.cybelia.sandra.ibu.csv;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.bean.CsvToBean;
import com.cybelia.sandra.ibu.MigrationContext;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.Resource;

public abstract class CSVReaderGeneric<E> extends CsvToBean {

    protected final Log log = LogFactory.getLog(CSVReaderGeneric.class);

    public static final char DELIM = ';';

    protected HeaderColumnNameTranslateMappingStrategy strategy;

    public CSVReaderGeneric() {
        // Description du mapping
        strategy = new HeaderColumnNameTranslateMappingStrategy();
        initStrategy();

        // Ajout de la conversion pour les dates
        PropertyEditorManager.registerEditor(Date.class, DatePropertyEditor.class);
    }

    public List<E> parseResource(MigrationContext contextMigration, String resourceName) {
        try {
            URL csvFileName = Resource.getURL(resourceName);
            return parse(contextMigration, new FileReader(new File(csvFileName.toURI())));
        } catch (Exception e) {
            // Erreur grave
            log.error("Parser error", e);
            throw new RuntimeException(e);
        }
    }

    public List<E> parseFile(MigrationContext contextMigration, String csvFileName) {
        try {
            return parse(contextMigration, new FileReader(csvFileName));
        } catch (Exception e) {
            // Erreur grave
            log.error("Parser error", e);
            throw new RuntimeException(e);
        }
    }

    public List<E> parse(MigrationContext contextMigration, Reader reader) {
        try {
            // Lancement du parsing du fichier CSV
            List<E> objects = new ArrayList<E>();

            // Fichier à lire
            CSVReader csv = new CSVReader(reader, DELIM);
            int lineNumber = 0;
            String errorContent = "";

            // Lecture de l'entête
            strategy.captureHeader(csv);
            String header = getInLine(strategy.getHeader());
            errorContent += header;
            contextMigration.getLines().add(header);

            // Lecture des lignes
            String[] line;
            while (null != (line = csv.readNext())) {
                lineNumber++;
                contextMigration.getLines().add(getInLine(line));
                try {
                    Object object = processLine(strategy, line);
                    objects.add((E) object);
                } catch (Exception e) {
                    // Erreur sur une ligne
                    log.error("Parser line error", e);
                    contextMigration.addErrorMsg("Parser line error at " + lineNumber);
                    contextMigration.getParserErrorLineNumbers().add(lineNumber);
                    objects.add(null);
                }
            }

//            contextMigration.setReturnCode(linesError.size());

            return objects;
        } catch (Exception e) {
            // Erreur grave
            log.error("Parser error", e);
            throw new RuntimeException(e);
        }
    }

    protected String getInLine(String[] line) {
        String result = "";

        if (line != null){
            for (Object field : line) {
                result += "\"" + field + "\"" + String.valueOf(DELIM);
            }
        }
        result += "\n";
        return result;
    }

    protected abstract void initStrategy();

}
