/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.web.job;

import com.franciaflex.faxtomail.FaxToMailApplicationContext;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailTopiaPersistenceContext;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.services.service.ClientService;
import com.franciaflex.faxtomail.web.job.AbstractFaxToMailJob;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class ClientUpdateJob
extends AbstractFaxToMailJob {
    private static final Log log = LogFactory.getLog(ClientUpdateJob.class);
    protected FaxToMailApplicationContext applicationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        this.applicationContext = this.getApplicationContext(jobExecutionContext);
        try (FaxToMailTopiaPersistenceContext persistenceContext = null;){
            persistenceContext = this.applicationContext.newPersistenceContext();
            FaxToMailServiceContext serviceContext = this.applicationContext.newServiceContext(persistenceContext);
            if (log.isInfoEnabled()) {
                log.info((Object)("Running ClientUpdateJob at " + serviceContext.getNow()));
            }
            ClientService clientService = serviceContext.getClientService();
            clientService.updateNewClients();
            if (log.isDebugEnabled()) {
                log.debug((Object)("ClientUpdateJob ended at " + serviceContext.getNow()));
            }
        }
    }
}

