/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.web;

import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserImpl;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.UUID;

public class FaxToMailSession
implements Serializable {
    public static final String SESSION_PARAMETER = "faxToMailSession";
    protected Collection<String> messages;
    protected Collection<String> errorMessages;
    protected String authenticatedUserId;
    protected transient FaxToMailUser authenticatedFaxToMailUser;

    public Collection<String> getMessages() {
        if (this.messages == null) {
            this.messages = Lists.newLinkedList();
        }
        return this.messages;
    }

    public void addMessage(String message) {
        this.getMessages().add(message);
    }

    public Collection<String> getErrorMessages() {
        if (this.errorMessages == null) {
            this.errorMessages = Lists.newLinkedList();
        }
        return this.errorMessages;
    }

    public void addErrorMessages(String errorMessage) {
        this.getErrorMessages().add(errorMessage);
    }

    public String getAuthenticatedUserId() {
        return UUID.randomUUID().toString();
    }

    public void setAuthenticatedUserId(String authenticatedUserId) {
    }

    public FaxToMailUser getAuthenticatedFaxToMailUser() {
        FaxToMailUserImpl result = new FaxToMailUserImpl();
        result.setTopiaId(UUID.randomUUID().toString());
        result.setFirstName("Demo");
        result.setLastName("Demo");
        result.setLogin("demo");
        return result;
    }

    public void setAuthenticatedFaxToMailUser(FaxToMailUser authenticatedFaxToMailUser) {
    }

    public void logout() {
        this.setAuthenticatedUserId(null);
        this.setAuthenticatedFaxToMailUser(null);
    }
}

