package com.franciaflex.faxtomail.ui.swing.content.reply;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.JAXXUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class AttachmentItem extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_REPLY_ATTACHMENT_MODEL = "replyAttachmentModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ATTACHMENT_NAME_LABEL_TEXT = "attachmentNameLabel.text";
    public static final String BINDING_REMOVE_ATTACHMENT_BUTTON_VISIBLE = "removeAttachmentButton.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Vz28bRRSeuLWNk5aWJo0KFGkbJGRXYVxKb0G0sYkbVy5UTpAKPsDYO46nmt0ZZt8ma0VF/An8CXDngsSNE+LAmQMXxL+AEAeuiDe7a28cb+TQKHKSee9973s/vpfv/iTFwJBbz1gUURP6IDxOH20/ffpR/xkfwAc8GBihQRmSfC0VSKFHVtzpewDkzV7HhtfT8HpTeVr53D8RvdUhywGMJQ9GnAOQN2YjBkFQ35uatyIdmgnqlFQe6jd//1X42v3q2wIhkUZ2ZSzFWRSVVXKxQwrCBXINMx2yumT+AdIwwj9AvpftW1OyIPiQefwL8iUpd0hJM4NgQDbOX3KMEcdHGsgVBsAGIw99nzCfSyD3B8qjQ8P8gWBDySM6ZBEojwlJQ0GDI6RDB8oHjKCGazmm21OINnBP6xi9BGQtNmfWx8q1CXb+d4JuDk6Wpjxiviu5AdJ8MeSWMt7H7d0EJcNdzVpjW95hfcv+mp1DlII9ih+tfyWjA0rJPkM6azOu+/jcYGbWeU1p7meVNUIA5EdWZyKTVxtxfRq4brinDvnpUGt9LfU05PWZ3cOtptlWZ2u31CNFE+IzkBu9eSF00ZRI4MYpCVjA2Prv+upvP/7xQ+vk3l/PdT0hW9xHbbB8A8KmvpIsfQhC1h8zvdUjlYBL1Hys6Zs5xPZSM5LDfK/YcGrD6S4LRghRLP/+08/rn/96gRRaZFkq5raY9W+TCowMdkFJN9L3H8SMLh29hJ9XLTfk4rFIeKHXVUdNFVp9Fe7eibADN3M6MKXRr/zyz+re9w8mXSggq1fPdM86UfyUlIQvhc9j/afSztX7ig546KpMwnmiJijr9QZnfktI4Ib10ay8vmqoKF3uTetyybqcMmzEn2/l9aTUV8a1Irt37DTiX5NujunAcAa8g/yT92pTSWVop/1wd/+zh93tT2rO8yi0wLctVMpg/vToBSQuALkIPMJpPD92oLqRiTvRcgZHpZXlxqZzwCHvdlRrFC2xdqu1RV7cP4BRtebUnXfu3L2HtQBZxsqF8tv2luAf07ATXarnd2nH0zBO2/TuppN+n9GgvAO0qEkFIJUh7jrYsQMpDpkM8OflhNcTJvD6uZP3vKST83WORDNtqNhL9vZQ2KwrFmNf6P14WrezQWUF7bgC20ITBGpjKQidRyj3RJ5jV8qHIhBxE2rHzi2cZHrgk7FOJiyCLmeu8uW4Oj/aEvpwmCtoc3FByXU+q6QzjveioqwKJRsrdCYvv+fijJ2+8F38H/H+XJYl+7mMiP8BmHaBEVIJAAA=";
    private static final Log log = LogFactory.getLog(AttachmentItem.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel attachmentNameLabel;
    protected AttachmentItem attachmentPanel = this;
    protected ReplyFormUIHandler handler;
    protected JButton openAttachmentButton;
    protected JButton removeAttachmentButton;
    protected ReplyAttachmentModel replyAttachmentModel;
    protected JToolBar toolbar;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AttachmentItem(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentItem(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentItem() {
        $initialize();
    }

    public AttachmentItem(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentItem(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public AttachmentItem(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentItem(boolean param0) {
        super(param0);
        $initialize();
    }

    public AttachmentItem(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__openAttachmentButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openAttachment(replyAttachmentModel);
    }

    public void doActionPerformed__on__removeAttachmentButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeAttachment(replyAttachmentModel);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getAttachmentNameLabel() {
        return attachmentNameLabel;
    }

    public ReplyFormUIHandler getHandler() {
        return handler;
    }

    public JButton getOpenAttachmentButton() {
        return openAttachmentButton;
    }

    public JButton getRemoveAttachmentButton() {
        return removeAttachmentButton;
    }

    public ReplyAttachmentModel getReplyAttachmentModel() {
        return replyAttachmentModel;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHandler(ReplyFormUIHandler handler) {
        ReplyFormUIHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setReplyAttachmentModel(ReplyAttachmentModel replyAttachmentModel) {
        ReplyAttachmentModel oldValue = this.replyAttachmentModel;
        this.replyAttachmentModel = replyAttachmentModel;
        firePropertyChange(PROPERTY_REPLY_ATTACHMENT_MODEL, oldValue, replyAttachmentModel);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAttachmentPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(attachmentNameLabel, BorderLayout.CENTER);
        add(toolbar, BorderLayout.EAST);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(openAttachmentButton);
        toolbar.add(removeAttachmentButton);
    }

    protected void createAttachmentNameLabel() {
        $objectMap.put("attachmentNameLabel", attachmentNameLabel = new JLabel());
        
        attachmentNameLabel.setName("attachmentNameLabel");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createOpenAttachmentButton() {
        $objectMap.put("openAttachmentButton", openAttachmentButton = new JButton());
        
        openAttachmentButton.setName("openAttachmentButton");
        openAttachmentButton.setToolTipText(t("faxtomail.attachmentEditor.action.open.tip"));
        openAttachmentButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__openAttachmentButton"));
    }

    protected void createRemoveAttachmentButton() {
        $objectMap.put("removeAttachmentButton", removeAttachmentButton = new JButton());
        
        removeAttachmentButton.setName("removeAttachmentButton");
        removeAttachmentButton.setToolTipText(t("faxtomail.attachmentEditor.action.remove.tip"));
        removeAttachmentButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeAttachmentButton"));
    }

    protected void createReplyAttachmentModel() {
        $objectMap.put("replyAttachmentModel", replyAttachmentModel = null);
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToAttachmentPanel();
        addChildrenToToolbar();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        setBorder( BorderFactory.createLineBorder(Color.LIGHT_GRAY) );
        attachmentNameLabel.setIcon(SwingUtil.createActionIcon("attachment"));
        attachmentNameLabel.setBorder( BorderFactory.createEmptyBorder(3, 3, 3, 3) );
        openAttachmentButton.setIcon(SwingUtil.createActionIcon("open-file"));
        removeAttachmentButton.setIcon(SwingUtil.createActionIcon("delete"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("attachmentPanel", attachmentPanel);
        createReplyAttachmentModel();
        createHandler();
        createAttachmentNameLabel();
        createToolbar();
        createOpenAttachmentButton();
        createRemoveAttachmentButton();
        // inline creation of attachmentPanel
        setName("attachmentPanel");
        setLayout(new BorderLayout());
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ATTACHMENT_NAME_LABEL_TEXT, true ,"replyAttachmentModel") {
        
            @Override
            public void processDataBinding() {
                if (getReplyAttachmentModel() != null) {
                    attachmentNameLabel.setText(t( t("faxtomail.reply.attachment.label", getReplyAttachmentModel().getLabel(), getReplyAttachmentModel().getLength() / 1024) ));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_ATTACHMENT_BUTTON_VISIBLE, true ,"handler") {
        
            @Override
            public void processDataBinding() {
                if (getHandler() != null && getHandler().getModel() != null) {
                    removeAttachmentButton.setVisible( !getHandler().getModel().isReadonly() );
                }
            }
        });
    }

}