/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing;

import com.franciaflex.faxtomail.FaxToMailConfiguration;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.MainUI;
import com.franciaflex.faxtomail.ui.swing.content.MainUIHandler;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailExceptionHandler;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.FontUIResource;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.extra.SplashScreen;

public class RunFaxToMail {
    private static final Log log = LogFactory.getLog(RunFaxToMail.class);
    public static final int NORMAL_EXIT_CODE = 0;
    public static final int UPATE_EXIT_CODE = 88;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) {
        Font font;
        if (log.isInfoEnabled()) {
            log.info((Object)("Starting FaxToMail with arguments: " + Arrays.toString(args)));
        }
        FaxToMailConfiguration config = new FaxToMailConfiguration("faxToMail.properties", args);
        try {
            InputStream fontStream = RunFaxToMail.class.getResourceAsStream("/PoetsenOne-Regular.ttf");
            font = FontUIResource.createFont(0, fontStream).deriveFont(30.0f);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"error while loading font, use the default one", (Throwable)e);
            }
            font = new Font("Verdana", 1, 20);
        }
        SplashScreen.Title title = new SplashScreen.Title("FaxToMail " + config.getVersion(), font, new Point(20, 40), new Color(200, 20, 40));
        SplashScreen splashScreen = new SplashScreen("/splashscreen.png", title);
        splashScreen.setRemanence(500L);
        try {
            FaxToMailUIContext context;
            block11: {
                context = FaxToMailUIContext.newContext(config);
                Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)((Object)new FaxToMailExceptionHandler(context.getErrorHelper())));
                context.init();
                try {
                    SwingUtil.initNimbusLoookAndFeel();
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block11;
                    log.warn((Object)"Failed to init nimbus look and feel", (Throwable)e);
                }
            }
            boolean reload = false;
            if (config.isFullLaunchMode() && log.isInfoEnabled()) {
                log.info((Object)"Full launch mode, try to update.");
            }
            if (!reload) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Will start FaxToMail...");
                }
                RunFaxToMail.startFaxToMail(context, true);
            }
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(splashScreen){
                final /* synthetic */ SplashScreen val$splashScreen;
                {
                    this.val$splashScreen = splashScreen;
                }

                @Override
                public void run() {
                    this.val$splashScreen.complete();
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public static void startFaxToMail(FaxToMailUIContext context, boolean openContext) {
        if (openContext) {
            context.open();
        }
        UIManager.put("Table.focusCellHighlightBorder", new BorderUIResource.LineBorderUIResource(Color.BLACK));
        final MainUI mainUI = new MainUI(context);
        context.addMessageNotifier(mainUI.getHandler());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                mainUI.setVisible(true);
            }
        });
    }

    public static void closeFaxToMail(MainUIHandler handler, Integer exitCode) {
        FaxToMailUIContext context;
        block3: {
            context = handler.getContext();
            handler.onCloseUI();
            try {
                context.getSwingSession().save();
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"error while saving the swing session", (Throwable)e);
            }
        }
        context.close();
        if (exitCode != null) {
            System.exit(exitCode);
        }
    }
}

