/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.media;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.support.v7.media.MediaRouteDescriptor;
import android.support.v7.media.MediaRouteDiscoveryRequest;
import android.support.v7.media.MediaRouteProvider;
import android.support.v7.media.MediaRouteProviderDescriptor;
import android.support.v7.media.MediaRouteProviderProtocol;
import android.support.v7.media.MediaRouter;
import android.util.Log;
import android.util.SparseArray;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

final class RegisteredMediaRouteProvider
extends MediaRouteProvider
implements ServiceConnection {
    private static final String TAG = "MediaRouteProviderProxy";
    private static final boolean DEBUG = Log.isLoggable((String)"MediaRouteProviderProxy", (int)3);
    private final ComponentName mComponentName;
    private final PrivateHandler mPrivateHandler;
    private final ArrayList<Controller> mControllers = new ArrayList();
    private boolean mStarted;
    private boolean mBound;
    private Connection mActiveConnection;
    private boolean mConnectionReady;

    public RegisteredMediaRouteProvider(Context context, ComponentName componentName) {
        super(context, new MediaRouteProvider.ProviderMetadata(componentName));
        this.mComponentName = componentName;
        this.mPrivateHandler = new PrivateHandler();
    }

    public MediaRouteProvider.RouteController onCreateRouteController(String routeId) {
        MediaRouteProviderDescriptor descriptor = this.getDescriptor();
        if (descriptor != null) {
            List<MediaRouteDescriptor> routes = descriptor.getRoutes();
            int count = routes.size();
            for (int i = 0; i < count; ++i) {
                MediaRouteDescriptor route = routes.get(i);
                if (!route.getId().equals(routeId)) continue;
                Controller controller = new Controller(routeId);
                this.mControllers.add(controller);
                if (this.mConnectionReady) {
                    controller.attachConnection(this.mActiveConnection);
                }
                this.updateBinding();
                return controller;
            }
        }
        return null;
    }

    public void onDiscoveryRequestChanged(MediaRouteDiscoveryRequest request) {
        if (this.mConnectionReady) {
            this.mActiveConnection.setDiscoveryRequest(request);
        }
        this.updateBinding();
    }

    public boolean hasComponentName(String packageName, String className) {
        return this.mComponentName.getPackageName().equals(packageName) && this.mComponentName.getClassName().equals(className);
    }

    public void start() {
        if (!this.mStarted) {
            if (DEBUG) {
                Log.d((String)TAG, (String)(this + ": Starting"));
            }
            this.mStarted = true;
            this.updateBinding();
        }
    }

    public void stop() {
        if (this.mStarted) {
            if (DEBUG) {
                Log.d((String)TAG, (String)(this + ": Stopping"));
            }
            this.mStarted = false;
            this.updateBinding();
        }
    }

    public void rebindIfDisconnected() {
        if (this.mActiveConnection == null && this.shouldBind()) {
            this.unbind();
            this.bind();
        }
    }

    private void updateBinding() {
        if (this.shouldBind()) {
            this.bind();
        } else {
            this.unbind();
        }
    }

    private boolean shouldBind() {
        if (this.mStarted) {
            if (this.getDiscoveryRequest() != null) {
                return true;
            }
            if (!this.mControllers.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private void bind() {
        block5: {
            if (!this.mBound) {
                if (DEBUG) {
                    Log.d((String)TAG, (String)(this + ": Binding"));
                }
                Intent service = new Intent("android.media.MediaRouteProviderService");
                service.setComponent(this.mComponentName);
                try {
                    this.mBound = this.getContext().bindService(service, (ServiceConnection)this, 1);
                    if (!this.mBound && DEBUG) {
                        Log.d((String)TAG, (String)(this + ": Bind failed"));
                    }
                }
                catch (SecurityException ex) {
                    if (!DEBUG) break block5;
                    Log.d((String)TAG, (String)(this + ": Bind failed"), (Throwable)ex);
                }
            }
        }
    }

    private void unbind() {
        if (this.mBound) {
            if (DEBUG) {
                Log.d((String)TAG, (String)(this + ": Unbinding"));
            }
            this.mBound = false;
            this.disconnect();
            this.getContext().unbindService((ServiceConnection)this);
        }
    }

    public void onServiceConnected(ComponentName name, IBinder service) {
        if (DEBUG) {
            Log.d((String)TAG, (String)(this + ": Connected"));
        }
        if (this.mBound) {
            Messenger messenger;
            this.disconnect();
            Messenger messenger2 = messenger = service != null ? new Messenger(service) : null;
            if (MediaRouteProviderProtocol.isValidRemoteMessenger(messenger)) {
                Connection connection = new Connection(messenger);
                if (connection.register()) {
                    this.mActiveConnection = connection;
                } else if (DEBUG) {
                    Log.d((String)TAG, (String)(this + ": Registration failed"));
                }
            } else {
                Log.e((String)TAG, (String)(this + ": Service returned invalid messenger binder"));
            }
        }
    }

    public void onServiceDisconnected(ComponentName name) {
        if (DEBUG) {
            Log.d((String)TAG, (String)(this + ": Service disconnected"));
        }
        this.disconnect();
    }

    private void onConnectionReady(Connection connection) {
        if (this.mActiveConnection == connection) {
            this.mConnectionReady = true;
            this.attachControllersToConnection();
            MediaRouteDiscoveryRequest request = this.getDiscoveryRequest();
            if (request != null) {
                this.mActiveConnection.setDiscoveryRequest(request);
            }
        }
    }

    private void onConnectionDied(Connection connection) {
        if (this.mActiveConnection == connection) {
            if (DEBUG) {
                Log.d((String)TAG, (String)(this + ": Service connection died"));
            }
            this.disconnect();
        }
    }

    private void onConnectionError(Connection connection, String error) {
        if (this.mActiveConnection == connection) {
            if (DEBUG) {
                Log.d((String)TAG, (String)(this + ": Service connection error - " + error));
            }
            this.unbind();
        }
    }

    private void onConnectionDescriptorChanged(Connection connection, MediaRouteProviderDescriptor descriptor) {
        if (this.mActiveConnection == connection) {
            if (DEBUG) {
                Log.d((String)TAG, (String)(this + ": Descriptor changed, descriptor=" + descriptor));
            }
            this.setDescriptor(descriptor);
        }
    }

    private void disconnect() {
        if (this.mActiveConnection != null) {
            this.setDescriptor(null);
            this.mConnectionReady = false;
            this.detachControllersFromConnection();
            this.mActiveConnection.dispose();
            this.mActiveConnection = null;
        }
    }

    private void onControllerReleased(Controller controller) {
        this.mControllers.remove(controller);
        controller.detachConnection();
        this.updateBinding();
    }

    private void attachControllersToConnection() {
        int count = this.mControllers.size();
        for (int i = 0; i < count; ++i) {
            this.mControllers.get(i).attachConnection(this.mActiveConnection);
        }
    }

    private void detachControllersFromConnection() {
        int count = this.mControllers.size();
        for (int i = 0; i < count; ++i) {
            this.mControllers.get(i).detachConnection();
        }
    }

    public String toString() {
        return "Service connection " + this.mComponentName.flattenToShortString();
    }

    private static final class ReceiveHandler
    extends Handler {
        private final WeakReference<Connection> mConnectionRef;

        public ReceiveHandler(Connection connection) {
            this.mConnectionRef = new WeakReference<Connection>(connection);
        }

        public void dispose() {
            this.mConnectionRef.clear();
        }

        public void handleMessage(Message msg) {
            Bundle data;
            Object obj;
            int arg;
            int requestId;
            int what;
            Connection connection = (Connection)this.mConnectionRef.get();
            if (connection != null && !this.processMessage(connection, what = msg.what, requestId = msg.arg1, arg = msg.arg2, obj = msg.obj, data = msg.peekData()) && DEBUG) {
                Log.d((String)RegisteredMediaRouteProvider.TAG, (String)("Unhandled message from server: " + msg));
            }
        }

        private boolean processMessage(Connection connection, int what, int requestId, int arg, Object obj, Bundle data) {
            switch (what) {
                case 0: {
                    connection.onGenericFailure(requestId);
                    return true;
                }
                case 1: {
                    connection.onGenericSuccess(requestId);
                    return true;
                }
                case 2: {
                    if (obj != null && !(obj instanceof Bundle)) break;
                    return connection.onRegistered(requestId, arg, (Bundle)obj);
                }
                case 5: {
                    if (obj != null && !(obj instanceof Bundle)) break;
                    return connection.onDescriptorChanged((Bundle)obj);
                }
                case 3: {
                    if (obj != null && !(obj instanceof Bundle)) break;
                    return connection.onControlRequestSucceeded(requestId, (Bundle)obj);
                }
                case 4: {
                    if (obj != null && !(obj instanceof Bundle)) break;
                    String error = data == null ? null : data.getString("error");
                    return connection.onControlRequestFailed(requestId, error, (Bundle)obj);
                }
            }
            return false;
        }
    }

    private final class PrivateHandler
    extends Handler {
        private PrivateHandler() {
        }
    }

    private final class Connection
    implements IBinder.DeathRecipient {
        private final Messenger mServiceMessenger;
        private final ReceiveHandler mReceiveHandler;
        private final Messenger mReceiveMessenger;
        private int mNextRequestId = 1;
        private int mNextControllerId = 1;
        private int mServiceVersion;
        private int mPendingRegisterRequestId;
        private final SparseArray<MediaRouter.ControlRequestCallback> mPendingCallbacks = new SparseArray();

        public Connection(Messenger serviceMessenger) {
            this.mServiceMessenger = serviceMessenger;
            this.mReceiveHandler = new ReceiveHandler(this);
            this.mReceiveMessenger = new Messenger((Handler)this.mReceiveHandler);
        }

        public boolean register() {
            this.mPendingRegisterRequestId = this.mNextRequestId++;
            if (!this.sendRequest(1, this.mPendingRegisterRequestId, 1, null, null)) {
                return false;
            }
            try {
                this.mServiceMessenger.getBinder().linkToDeath((IBinder.DeathRecipient)this, 0);
                return true;
            }
            catch (RemoteException ex) {
                this.binderDied();
                return false;
            }
        }

        public void dispose() {
            this.sendRequest(2, 0, 0, null, null);
            this.mReceiveHandler.dispose();
            this.mServiceMessenger.getBinder().unlinkToDeath((IBinder.DeathRecipient)this, 0);
            RegisteredMediaRouteProvider.this.mPrivateHandler.post(new Runnable(){

                public void run() {
                    Connection.this.failPendingCallbacks();
                }
            });
        }

        private void failPendingCallbacks() {
            boolean count = false;
            for (int i = 0; i < this.mPendingCallbacks.size(); ++i) {
                ((MediaRouter.ControlRequestCallback)this.mPendingCallbacks.valueAt(i)).onError(null, null);
            }
            this.mPendingCallbacks.clear();
        }

        public boolean onGenericFailure(int requestId) {
            MediaRouter.ControlRequestCallback callback;
            if (requestId == this.mPendingRegisterRequestId) {
                this.mPendingRegisterRequestId = 0;
                RegisteredMediaRouteProvider.this.onConnectionError(this, "Registation failed");
            }
            if ((callback = (MediaRouter.ControlRequestCallback)this.mPendingCallbacks.get(requestId)) != null) {
                this.mPendingCallbacks.remove(requestId);
                callback.onError(null, null);
            }
            return true;
        }

        public boolean onGenericSuccess(int requestId) {
            return true;
        }

        public boolean onRegistered(int requestId, int serviceVersion, Bundle descriptorBundle) {
            if (this.mServiceVersion == 0 && requestId == this.mPendingRegisterRequestId && serviceVersion >= 1) {
                this.mPendingRegisterRequestId = 0;
                this.mServiceVersion = serviceVersion;
                RegisteredMediaRouteProvider.this.onConnectionDescriptorChanged(this, MediaRouteProviderDescriptor.fromBundle(descriptorBundle));
                RegisteredMediaRouteProvider.this.onConnectionReady(this);
                return true;
            }
            return false;
        }

        public boolean onDescriptorChanged(Bundle descriptorBundle) {
            if (this.mServiceVersion != 0) {
                RegisteredMediaRouteProvider.this.onConnectionDescriptorChanged(this, MediaRouteProviderDescriptor.fromBundle(descriptorBundle));
                return true;
            }
            return false;
        }

        public boolean onControlRequestSucceeded(int requestId, Bundle data) {
            MediaRouter.ControlRequestCallback callback = (MediaRouter.ControlRequestCallback)this.mPendingCallbacks.get(requestId);
            if (callback != null) {
                this.mPendingCallbacks.remove(requestId);
                callback.onResult(data);
                return true;
            }
            return false;
        }

        public boolean onControlRequestFailed(int requestId, String error, Bundle data) {
            MediaRouter.ControlRequestCallback callback = (MediaRouter.ControlRequestCallback)this.mPendingCallbacks.get(requestId);
            if (callback != null) {
                this.mPendingCallbacks.remove(requestId);
                callback.onError(error, data);
                return true;
            }
            return false;
        }

        public void binderDied() {
            RegisteredMediaRouteProvider.this.mPrivateHandler.post(new Runnable(){

                public void run() {
                    RegisteredMediaRouteProvider.this.onConnectionDied(Connection.this);
                }
            });
        }

        public int createRouteController(String routeId) {
            int controllerId = this.mNextControllerId++;
            Bundle data = new Bundle();
            data.putString("routeId", routeId);
            this.sendRequest(3, this.mNextRequestId++, controllerId, null, data);
            return controllerId;
        }

        public void releaseRouteController(int controllerId) {
            this.sendRequest(4, this.mNextRequestId++, controllerId, null, null);
        }

        public void selectRoute(int controllerId) {
            this.sendRequest(5, this.mNextRequestId++, controllerId, null, null);
        }

        public void unselectRoute(int controllerId) {
            this.sendRequest(6, this.mNextRequestId++, controllerId, null, null);
        }

        public void setVolume(int controllerId, int volume) {
            Bundle data = new Bundle();
            data.putInt("volume", volume);
            this.sendRequest(7, this.mNextRequestId++, controllerId, null, data);
        }

        public void updateVolume(int controllerId, int delta) {
            Bundle data = new Bundle();
            data.putInt("volume", delta);
            this.sendRequest(8, this.mNextRequestId++, controllerId, null, data);
        }

        public boolean sendControlRequest(int controllerId, Intent intent, MediaRouter.ControlRequestCallback callback) {
            int requestId;
            if (this.sendRequest(9, requestId = this.mNextRequestId++, controllerId, intent, null)) {
                if (callback != null) {
                    this.mPendingCallbacks.put(requestId, (Object)callback);
                }
                return true;
            }
            return false;
        }

        public void setDiscoveryRequest(MediaRouteDiscoveryRequest request) {
            this.sendRequest(10, this.mNextRequestId++, 0, request != null ? request.asBundle() : null, null);
        }

        private boolean sendRequest(int what, int requestId, int arg, Object obj, Bundle data) {
            block3: {
                Message msg = Message.obtain();
                msg.what = what;
                msg.arg1 = requestId;
                msg.arg2 = arg;
                msg.obj = obj;
                msg.setData(data);
                msg.replyTo = this.mReceiveMessenger;
                try {
                    this.mServiceMessenger.send(msg);
                    return true;
                }
                catch (DeadObjectException ex) {
                }
                catch (RemoteException ex) {
                    if (what == 2) break block3;
                    Log.e((String)RegisteredMediaRouteProvider.TAG, (String)"Could not send message to service.", (Throwable)ex);
                }
            }
            return false;
        }
    }

    private final class Controller
    extends MediaRouteProvider.RouteController {
        private final String mRouteId;
        private boolean mSelected;
        private int mPendingSetVolume = -1;
        private int mPendingUpdateVolumeDelta;
        private Connection mConnection;
        private int mControllerId;

        public Controller(String routeId) {
            this.mRouteId = routeId;
        }

        public void attachConnection(Connection connection) {
            this.mConnection = connection;
            this.mControllerId = connection.createRouteController(this.mRouteId);
            if (this.mSelected) {
                connection.selectRoute(this.mControllerId);
                if (this.mPendingSetVolume >= 0) {
                    connection.setVolume(this.mControllerId, this.mPendingSetVolume);
                    this.mPendingSetVolume = -1;
                }
                if (this.mPendingUpdateVolumeDelta != 0) {
                    connection.updateVolume(this.mControllerId, this.mPendingUpdateVolumeDelta);
                    this.mPendingUpdateVolumeDelta = 0;
                }
            }
        }

        public void detachConnection() {
            if (this.mConnection != null) {
                this.mConnection.releaseRouteController(this.mControllerId);
                this.mConnection = null;
                this.mControllerId = 0;
            }
        }

        public void onRelease() {
            RegisteredMediaRouteProvider.this.onControllerReleased(this);
        }

        public void onSelect() {
            this.mSelected = true;
            if (this.mConnection != null) {
                this.mConnection.selectRoute(this.mControllerId);
            }
        }

        public void onUnselect() {
            this.mSelected = false;
            if (this.mConnection != null) {
                this.mConnection.unselectRoute(this.mControllerId);
            }
        }

        public void onSetVolume(int volume) {
            if (this.mConnection != null) {
                this.mConnection.setVolume(this.mControllerId, volume);
            } else {
                this.mPendingSetVolume = volume;
                this.mPendingUpdateVolumeDelta = 0;
            }
        }

        public void onUpdateVolume(int delta) {
            if (this.mConnection != null) {
                this.mConnection.updateVolume(this.mControllerId, delta);
            } else {
                this.mPendingUpdateVolumeDelta += delta;
            }
        }

        public boolean onControlRequest(Intent intent, MediaRouter.ControlRequestCallback callback) {
            if (this.mConnection != null) {
                return this.mConnection.sendControlRequest(this.mControllerId, intent, callback);
            }
            return false;
        }
    }
}

