/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

import android.app.ActionBar;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.ActionBar;
import android.view.View;
import android.view.ViewGroup;
import android.widget.SpinnerAdapter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

class ActionBarImplICS
extends ActionBar {
    final Activity mActivity;
    final ActionBar.Callback mCallback;
    final android.app.ActionBar mActionBar;
    FragmentTransaction mActiveTransaction;
    private ArrayList<WeakReference<OnMenuVisibilityListenerWrapper>> mAddedMenuVisWrappers = new ArrayList();

    public ActionBarImplICS(Activity activity, ActionBar.Callback callback) {
        this(activity, callback, true);
    }

    ActionBarImplICS(Activity activity, ActionBar.Callback callback, boolean checkHomeAsUpOption) {
        this.mActivity = activity;
        this.mCallback = callback;
        this.mActionBar = activity.getActionBar();
        if (checkHomeAsUpOption && (this.getDisplayOptions() & 4) != 0) {
            this.setHomeButtonEnabled(true);
        }
    }

    private OnMenuVisibilityListenerWrapper findAndRemoveMenuVisWrapper(ActionBar.OnMenuVisibilityListener compatListener) {
        for (int i = 0; i < this.mAddedMenuVisWrappers.size(); ++i) {
            OnMenuVisibilityListenerWrapper wrapper = (OnMenuVisibilityListenerWrapper)this.mAddedMenuVisWrappers.get(i).get();
            if (wrapper == null) {
                this.mAddedMenuVisWrappers.remove(i--);
                continue;
            }
            if (wrapper.mWrappedListener != compatListener) continue;
            this.mAddedMenuVisWrappers.remove(i);
            return wrapper;
        }
        return null;
    }

    public void setCustomView(View view) {
        this.mActionBar.setCustomView(view);
    }

    public void setCustomView(View view, ActionBar.LayoutParams layoutParams) {
        ActionBar.LayoutParams lp = new ActionBar.LayoutParams((ViewGroup.LayoutParams)layoutParams);
        lp.gravity = layoutParams.gravity;
        this.mActionBar.setCustomView(view, lp);
    }

    public void setCustomView(int resId) {
        this.mActionBar.setCustomView(resId);
    }

    public void setIcon(int resId) {
        this.mActionBar.setIcon(resId);
    }

    public void setIcon(Drawable icon) {
        this.mActionBar.setIcon(icon);
    }

    public void setLogo(int resId) {
        this.mActionBar.setLogo(resId);
    }

    public void setLogo(Drawable logo) {
        this.mActionBar.setLogo(logo);
    }

    public void setListNavigationCallbacks(SpinnerAdapter adapter, ActionBar.OnNavigationListener callback) {
        this.mActionBar.setListNavigationCallbacks(adapter, (ActionBar.OnNavigationListener)(callback != null ? new OnNavigationListenerWrapper(callback) : null));
    }

    public void setSelectedNavigationItem(int position) {
        this.mActionBar.setSelectedNavigationItem(position);
    }

    public int getSelectedNavigationIndex() {
        return this.mActionBar.getSelectedNavigationIndex();
    }

    public int getNavigationItemCount() {
        return this.mActionBar.getNavigationItemCount();
    }

    public void setTitle(CharSequence title) {
        this.mActionBar.setTitle(title);
    }

    public void setTitle(int resId) {
        this.mActionBar.setTitle(resId);
    }

    public void setSubtitle(CharSequence subtitle) {
        this.mActionBar.setSubtitle(subtitle);
    }

    public void setSubtitle(int resId) {
        this.mActionBar.setSubtitle(resId);
    }

    public void setDisplayOptions(int options) {
        this.mActionBar.setDisplayOptions(options);
    }

    public void setDisplayOptions(int options, int mask) {
        this.mActionBar.setDisplayOptions(options, mask);
    }

    public void setDisplayUseLogoEnabled(boolean useLogo) {
        this.mActionBar.setDisplayUseLogoEnabled(useLogo);
    }

    public void setDisplayShowHomeEnabled(boolean showHome) {
        this.mActionBar.setDisplayShowHomeEnabled(showHome);
    }

    public void setDisplayHomeAsUpEnabled(boolean showHomeAsUp) {
        this.mActionBar.setDisplayHomeAsUpEnabled(showHomeAsUp);
    }

    public void setDisplayShowTitleEnabled(boolean showTitle) {
        this.mActionBar.setDisplayShowTitleEnabled(showTitle);
    }

    public void setDisplayShowCustomEnabled(boolean showCustom) {
        this.mActionBar.setDisplayShowCustomEnabled(showCustom);
    }

    public void setBackgroundDrawable(Drawable d) {
        this.mActionBar.setBackgroundDrawable(d);
    }

    public View getCustomView() {
        return this.mActionBar.getCustomView();
    }

    public CharSequence getTitle() {
        return this.mActionBar.getTitle();
    }

    public CharSequence getSubtitle() {
        return this.mActionBar.getSubtitle();
    }

    public int getNavigationMode() {
        return this.mActionBar.getNavigationMode();
    }

    public void setNavigationMode(int mode) {
        this.mActionBar.setNavigationMode(mode);
    }

    public int getDisplayOptions() {
        return this.mActionBar.getDisplayOptions();
    }

    public ActionBar.Tab newTab() {
        ActionBar.Tab realTab = this.mActionBar.newTab();
        TabWrapper result = new TabWrapper(realTab);
        realTab.setTag((Object)result);
        return result;
    }

    public void addTab(ActionBar.Tab tab) {
        this.mActionBar.addTab(((TabWrapper)tab).mWrappedTab);
    }

    public void addTab(ActionBar.Tab tab, boolean setSelected) {
        this.mActionBar.addTab(((TabWrapper)tab).mWrappedTab, setSelected);
    }

    public void addTab(ActionBar.Tab tab, int position) {
        this.mActionBar.addTab(((TabWrapper)tab).mWrappedTab, position);
    }

    public void addTab(ActionBar.Tab tab, int position, boolean setSelected) {
        this.mActionBar.addTab(((TabWrapper)tab).mWrappedTab, position, setSelected);
    }

    public void removeTab(ActionBar.Tab tab) {
        this.mActionBar.removeTab(((TabWrapper)tab).mWrappedTab);
    }

    public void removeTabAt(int position) {
        this.mActionBar.removeTabAt(position);
    }

    public void removeAllTabs() {
        this.mActionBar.removeAllTabs();
    }

    public void selectTab(ActionBar.Tab tab) {
        this.mActionBar.selectTab(((TabWrapper)tab).mWrappedTab);
    }

    public ActionBar.Tab getSelectedTab() {
        return (ActionBar.Tab)this.mActionBar.getSelectedTab().getTag();
    }

    public ActionBar.Tab getTabAt(int index) {
        return (ActionBar.Tab)this.mActionBar.getTabAt(index).getTag();
    }

    public int getTabCount() {
        return this.mActionBar.getTabCount();
    }

    public Context getThemedContext() {
        return this.mActionBar.getThemedContext();
    }

    public int getHeight() {
        return this.mActionBar.getHeight();
    }

    public void show() {
        this.mActionBar.show();
    }

    public void hide() {
        this.mActionBar.hide();
    }

    public boolean isShowing() {
        return this.mActionBar.isShowing();
    }

    public void addOnMenuVisibilityListener(ActionBar.OnMenuVisibilityListener listener) {
        if (listener != null) {
            OnMenuVisibilityListenerWrapper w = new OnMenuVisibilityListenerWrapper(listener);
            this.mAddedMenuVisWrappers.add(new WeakReference<OnMenuVisibilityListenerWrapper>(w));
            this.mActionBar.addOnMenuVisibilityListener((ActionBar.OnMenuVisibilityListener)w);
        }
    }

    public void removeOnMenuVisibilityListener(ActionBar.OnMenuVisibilityListener listener) {
        OnMenuVisibilityListenerWrapper l = this.findAndRemoveMenuVisWrapper(listener);
        this.mActionBar.removeOnMenuVisibilityListener((ActionBar.OnMenuVisibilityListener)l);
    }

    public void setHomeButtonEnabled(boolean enabled) {
        this.mActionBar.setHomeButtonEnabled(enabled);
    }

    FragmentTransaction getActiveTransaction() {
        if (this.mActiveTransaction == null) {
            this.mActiveTransaction = this.mCallback.getSupportFragmentManager().beginTransaction().disallowAddToBackStack();
        }
        return this.mActiveTransaction;
    }

    void commitActiveTransaction() {
        if (this.mActiveTransaction != null && !this.mActiveTransaction.isEmpty()) {
            this.mActiveTransaction.commit();
        }
        this.mActiveTransaction = null;
    }

    class TabWrapper
    extends ActionBar.Tab
    implements ActionBar.TabListener {
        final ActionBar.Tab mWrappedTab;
        private Object mTag;
        private CharSequence mContentDescription;
        private ActionBar.TabListener mTabListener;

        public TabWrapper(ActionBar.Tab tab) {
            this.mWrappedTab = tab;
        }

        public int getPosition() {
            return this.mWrappedTab.getPosition();
        }

        public Drawable getIcon() {
            return this.mWrappedTab.getIcon();
        }

        public CharSequence getText() {
            return this.mWrappedTab.getText();
        }

        public ActionBar.Tab setIcon(Drawable icon) {
            this.mWrappedTab.setIcon(icon);
            return this;
        }

        public ActionBar.Tab setIcon(int resId) {
            this.mWrappedTab.setIcon(resId);
            return this;
        }

        public ActionBar.Tab setText(CharSequence text) {
            this.mWrappedTab.setText(text);
            return this;
        }

        public ActionBar.Tab setText(int resId) {
            this.mWrappedTab.setText(resId);
            return this;
        }

        public ActionBar.Tab setCustomView(View view) {
            this.mWrappedTab.setCustomView(view);
            return this;
        }

        public ActionBar.Tab setCustomView(int layoutResId) {
            this.mWrappedTab.setCustomView(layoutResId);
            return this;
        }

        public View getCustomView() {
            return this.mWrappedTab.getCustomView();
        }

        public ActionBar.Tab setTag(Object obj) {
            this.mTag = obj;
            return this;
        }

        public Object getTag() {
            return this.mTag;
        }

        public ActionBar.Tab setTabListener(ActionBar.TabListener listener) {
            this.mTabListener = listener;
            this.mWrappedTab.setTabListener((ActionBar.TabListener)(listener != null ? this : null));
            return this;
        }

        public void select() {
            this.mWrappedTab.select();
        }

        public ActionBar.Tab setContentDescription(int resId) {
            this.mContentDescription = ActionBarImplICS.this.mActivity.getText(resId);
            return this;
        }

        public ActionBar.Tab setContentDescription(CharSequence contentDesc) {
            this.mContentDescription = contentDesc;
            return this;
        }

        public CharSequence getContentDescription() {
            return this.mContentDescription;
        }

        public void onTabSelected(ActionBar.Tab tab, android.app.FragmentTransaction ft) {
            this.mTabListener.onTabSelected(this, ft != null ? ActionBarImplICS.this.getActiveTransaction() : null);
            ActionBarImplICS.this.commitActiveTransaction();
        }

        public void onTabUnselected(ActionBar.Tab tab, android.app.FragmentTransaction ft) {
            this.mTabListener.onTabUnselected(this, ft != null ? ActionBarImplICS.this.getActiveTransaction() : null);
        }

        public void onTabReselected(ActionBar.Tab tab, android.app.FragmentTransaction ft) {
            this.mTabListener.onTabReselected(this, ft != null ? ActionBarImplICS.this.getActiveTransaction() : null);
            ActionBarImplICS.this.commitActiveTransaction();
        }
    }

    static class OnMenuVisibilityListenerWrapper
    implements ActionBar.OnMenuVisibilityListener {
        final ActionBar.OnMenuVisibilityListener mWrappedListener;

        public OnMenuVisibilityListenerWrapper(ActionBar.OnMenuVisibilityListener l) {
            this.mWrappedListener = l;
        }

        public void onMenuVisibilityChanged(boolean isVisible) {
            this.mWrappedListener.onMenuVisibilityChanged(isVisible);
        }
    }

    static class OnNavigationListenerWrapper
    implements ActionBar.OnNavigationListener {
        private final ActionBar.OnNavigationListener mWrappedListener;

        public OnNavigationListenerWrapper(ActionBar.OnNavigationListener l) {
            this.mWrappedListener = l;
        }

        public boolean onNavigationItemSelected(int itemPosition, long itemId) {
            return this.mWrappedListener.onNavigationItemSelected(itemPosition, itemId);
        }
    }
}

