/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xjavadoc.AbstractClass;
import xjavadoc.AbstractExecutableMember;
import xjavadoc.ReturnType;
import xjavadoc.Type;
import xjavadoc.XClass;
import xjavadoc.XMethod;
import xjavadoc.XParameter;
import xjavadoc.XProgramElement;
import xjavadoc.XTagFactory;

final class MethodImpl
extends AbstractExecutableMember
implements XMethod {
    public static int instanceCount = 0;
    private String methodNameWithSignatureAndModifiers = null;
    private String methodNameWithSignatureWithoutModifiers = null;
    private ReturnType _returnType = new ReturnType(this);

    public MethodImpl(AbstractClass containingClass, XTagFactory tagFactory) {
        super(containingClass, tagFactory);
        if (containingClass.isInterface()) {
            this.addModifier(1);
        }
        ++instanceCount;
    }

    public final boolean isConstructor() {
        return false;
    }

    public final Type getReturnType() {
        return this._returnType;
    }

    public XProgramElement getSuperElement() {
        return this.getSuperElement(true);
    }

    public List getSuperInterfaceElements() {
        Iterator interfaces = this.getContainingClass().getInterfaces().iterator();
        ArrayList<XMethod> result = new ArrayList<XMethod>();
        while (interfaces.hasNext()) {
            XClass superinterface = (XClass)interfaces.next();
            XMethod superExecutableMember = superinterface.getMethod(this.getNameWithSignature(false));
            if (superExecutableMember == null) continue;
            result.add(superExecutableMember);
        }
        return result;
    }

    public XMethod getAccessor() {
        XMethod result = null;
        if (this.isPropertyMutator()) {
            Type requiredType = (Type)this.getParameters().iterator().next();
            String getterNameWithSignature = "get" + this.getNameWithoutPrefix() + "()";
            String isserNameWithSignature = "is" + this.getNameWithoutPrefix() + "()";
            XMethod getter = this.getContainingClass().getMethod(getterNameWithSignature, true);
            XMethod isser = this.getContainingClass().getMethod(isserNameWithSignature, true);
            if (getter == null && isser != null) {
                result = isser;
            } else if (getter != null && isser == null) {
                result = getter;
            }
            if (!requiredType.equals(result.getReturnType())) {
                result = null;
            }
        }
        return result;
    }

    public XMethod getMutator() {
        XMethod result = null;
        if (this.isPropertyAccessor()) {
            Type requiredType = this.getReturnType();
            String argument = requiredType.getType().getQualifiedName() + requiredType.getDimensionAsString();
            String setterNameWithSignature = "set" + this.getNameWithoutPrefix() + "(" + argument + ")";
            result = this.getContainingClass().getMethod(setterNameWithSignature, true);
        }
        return result;
    }

    public boolean isPropertyAccessor() {
        boolean signatureOk = false;
        boolean nameOk = false;
        if (this.getName().startsWith("is")) {
            signatureOk = this.getReturnType().getType().getQualifiedName().equals("boolean") || this.getReturnType().getType().getQualifiedName().equals("java.lang.Boolean");
            boolean bl = signatureOk = signatureOk && this.getReturnType().getDimension() == 0;
            if (this.getName().length() > 2) {
                nameOk = Character.isUpperCase(this.getName().charAt(2));
            }
        }
        if (this.getName().startsWith("get")) {
            signatureOk = true;
            if (this.getName().length() > 3) {
                nameOk = Character.isUpperCase(this.getName().charAt(3));
            }
        }
        boolean noParams = this.getParameters().size() == 0;
        return signatureOk && nameOk && noParams;
    }

    public boolean isPropertyMutator() {
        boolean nameOk = false;
        if (this.getName().startsWith("set") && this.getName().length() > 3) {
            nameOk = Character.isUpperCase(this.getName().charAt(3));
        }
        boolean oneParam = this.getParameters().size() == 1;
        return nameOk && oneParam;
    }

    public String getPropertyName() {
        String result = null;
        if (this.getName().startsWith("get") || this.getName().startsWith("set")) {
            result = Introspector.decapitalize(this.getName().substring(3));
        } else if (this.getName().startsWith("is")) {
            result = Introspector.decapitalize(this.getName().substring(2));
        }
        return result;
    }

    public Type getPropertyType() {
        Type result = null;
        if (this.isPropertyMutator()) {
            XParameter parameter = (XParameter)this.getParameters().iterator().next();
            result = parameter;
        } else if (this.isPropertyAccessor()) {
            result = this.getReturnType();
        }
        return result;
    }

    public String getNameWithoutPrefix() {
        for (int i = 0; i < this.getName().length(); ++i) {
            if (!Character.isUpperCase(this.getName().charAt(i))) continue;
            return this.getName().substring(i);
        }
        return null;
    }

    public final void setReturnType(String returnType) {
        this._returnType.setType(returnType);
    }

    public final void setReturnDimension(int d) {
        this._returnType.setDimension(d);
    }

    public boolean equals(Object o) {
        MethodImpl other = (MethodImpl)o;
        return this.getMethodNameWithSignatureWithoutModifiers().equals(other.getMethodNameWithSignatureWithoutModifiers());
    }

    public int hashCode() {
        return this.toString(false).hashCode();
    }

    public String toString() {
        return this.getMethodNameWithSignatureAndModifiers();
    }

    protected String buildStringId() {
        return this.getMethodNameWithSignatureWithoutModifiers();
    }

    private String getMethodNameWithSignatureAndModifiers() {
        if (this.methodNameWithSignatureAndModifiers == null) {
            this.methodNameWithSignatureAndModifiers = this.toString(true);
        }
        return this.methodNameWithSignatureAndModifiers;
    }

    private String getMethodNameWithSignatureWithoutModifiers() {
        if (this.methodNameWithSignatureWithoutModifiers == null) {
            this.methodNameWithSignatureWithoutModifiers = this.toString(false);
        }
        return this.methodNameWithSignatureWithoutModifiers;
    }

    private String toString(boolean modifiers) {
        StringBuffer sb;
        if (modifiers) {
            sb = new StringBuffer(this.getModifiers());
            if (sb.length() > 0) {
                sb.append(' ');
            }
        } else {
            sb = new StringBuffer();
        }
        sb.append(this.getReturnType().getType().getQualifiedName());
        sb.append(this.getReturnType().getDimensionAsString());
        sb.append(' ');
        sb.append(this.getNameWithSignature(false));
        return sb.toString();
    }
}

