/*
 * Decompiled with CFR 0.152.
 */
package us.springett.parsers.cpe.util;

import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.exceptions.CpeEncodingException;
import us.springett.parsers.cpe.exceptions.CpeParsingException;
import us.springett.parsers.cpe.internal.util.Cpe23PartIterator;
import us.springett.parsers.cpe.util.Convert;
import us.springett.parsers.cpe.util.Status;
import us.springett.parsers.cpe.values.Part;

public final class Validate {
    private static final Logger LOG = LoggerFactory.getLogger(Validate.class);
    private static final Pattern CPE_URI = Pattern.compile("^[c][pP][eE]:/[AHOaho]?(:[A-Za-z0-9._~%-]*){0,6}$");

    private Validate() {
    }

    public static Status component(String value) {
        if (value != null && !value.isEmpty()) {
            if ("\\-".equals(value)) {
                return Status.SINGLE_QUOTED_HYPHEN;
            }
            for (int x = 0; x < value.length(); ++x) {
                char c = value.charAt(x);
                if (c == '?' && x > 0 && x < value.length() - 1 && value.charAt(x - 1) != '?' && value.charAt(x - 1) != '*' && value.charAt(x - 1) != '\\' && (x >= value.length() - 1 || value.charAt(x + 1) != '?' && value.charAt(x + 1) != '*')) {
                    return Status.UNQUOTED_QUESTION_MARK;
                }
                if (Character.isWhitespace(c)) {
                    return Status.WHITESPACE;
                }
                if (c < ' ' || c > '\u007f') {
                    return Status.NON_PRINTABLE;
                }
                if (c == '*' && x != 0 && value.charAt(x - 1) == '*') {
                    return Status.ASTERISK_SEQUENCE;
                }
                if (c != '*' || x == 0 || x == value.length() - 1 || x > 0 && '\\' == value.charAt(x - 1)) continue;
                return Status.UNQUOTED_ASTERISK;
            }
            return Status.VALID;
        }
        return Status.EMPTY;
    }

    public static Status formattedString(String value) {
        boolean result = true;
        try {
            Cpe23PartIterator instance;
            try {
                instance = new Cpe23PartIterator(value);
            }
            catch (CpeParsingException ex) {
                LOG.warn("The CPE ({}) is invalid as it is not in the formatted string format", (Object)value);
                return Status.INVALID;
            }
            try {
                Part.getEnum(instance.next());
            }
            catch (CpeParsingException ex) {
                LOG.warn("The CPE ({}) is invalid as it has an invalid part attribute", (Object)value);
                return Status.INVALID_PART;
            }
            Status status = Validate.component(instance.next());
            if (!status.isValid()) {
                LOG.warn("The CPE ({}) has an invalid vendor - {}", (Object)value, (Object)status.getMessage());
                return status;
            }
            status = Validate.component(instance.next());
            if (!status.isValid()) {
                LOG.warn("The CPE ({}) has an invalid product - {}", (Object)value, (Object)status.getMessage());
                return status;
            }
            status = Validate.component(instance.next());
            if (!status.isValid()) {
                LOG.warn("The CPE ({}) has an version version - {}", (Object)value, (Object)status.getMessage());
                return status;
            }
            status = Validate.component(instance.next());
            if (!status.isValid()) {
                LOG.warn("The CPE ({}) has an invalid update - {}", (Object)value, (Object)status.getMessage());
                return status;
            }
            status = Validate.component(instance.next());
            if (!status.isValid()) {
                LOG.warn("The CPE ({}) has an invalid edition - {}", (Object)value, (Object)status.getMessage());
                return status;
            }
            status = Validate.component(instance.next());
            if (!status.isValid()) {
                LOG.warn("The CPE ({}) has an invalid language - {}", (Object)value, (Object)status.getMessage());
                return status;
            }
            status = Validate.component(instance.next());
            if (!status.isValid()) {
                LOG.warn("The CPE ({}) has an invalid swEdition - {}", (Object)value, (Object)status.getMessage());
                return status;
            }
            status = Validate.component(instance.next());
            if (!status.isValid()) {
                LOG.warn("The CPE ({}) has an invalid targetSw - {}", (Object)value, (Object)status.getMessage());
                return status;
            }
            status = Validate.component(instance.next());
            if (!status.isValid()) {
                LOG.warn("The CPE ({}) has an invalid targetHw - {}", (Object)value, (Object)status.getMessage());
                return status;
            }
            status = Validate.component(instance.next());
            if (!status.isValid()) {
                LOG.warn("The CPE ({}) has an invalid other attribute - {}", (Object)value, (Object)status.getMessage());
                return status;
            }
            if (instance.hasNext()) {
                LOG.warn(Status.TOO_MANY_ELEMENTS.getMessage());
                return Status.TOO_MANY_ELEMENTS;
            }
        }
        catch (NoSuchElementException ex) {
            LOG.warn(Status.TOO_FEW_ELEMENTS.getMessage());
            return Status.TOO_FEW_ELEMENTS;
        }
        return Status.VALID;
    }

    public static Status cpeUri(String value) {
        try {
            String[] parts = value.split(":");
            if (parts.length > 8 || parts.length == 1 || !"cpe".equalsIgnoreCase(parts[0])) {
                LOG.warn("The CPE ({}) is invalid as it is not in the CPE 2.2 URI format", (Object)value);
                return Status.INVALID;
            }
            if (parts.length >= 2 && parts[1].length() == 2) {
                boolean found = false;
                String a = parts[1].substring(1);
                for (Part p : Part.values()) {
                    if (!p.getAbbreviation().equals(a)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    LOG.warn("The CPE ({}) is invalid as it has an invalid part attribute", (Object)value);
                    return Status.INVALID_PART;
                }
            } else {
                LOG.warn("The CPE ({}) is invalid as it has an invalid part attribute", (Object)value);
                return Status.INVALID_PART;
            }
            if (parts.length > 2) {
                if ("*".equals(parts[2])) {
                    LOG.warn("The CPE ({}) has an invalid vendor - asterisk", (Object)value);
                    return Status.INVALID;
                }
                Status s = Validate.component(Convert.cpeUriToWellFormed(parts[2]));
                if (!s.isValid() || "*".equals(parts[2])) {
                    LOG.warn("The CPE ({}) has an invalid vendor - {}", (Object)value, (Object)s.getMessage());
                    return s;
                }
            }
            if (parts.length > 3) {
                if ("*".equals(parts[3])) {
                    LOG.warn("The CPE ({}) has an invalid product - asterisk", (Object)value);
                    return Status.INVALID;
                }
                Status s = Validate.component(Convert.cpeUriToWellFormed(parts[3]));
                if (!s.isValid()) {
                    LOG.warn("The CPE ({}) has an invalid product - {}", (Object)value, (Object)s.getMessage());
                    return s;
                }
            }
            if (parts.length > 4) {
                if ("*".equals(parts[4])) {
                    LOG.warn("The CPE ({}) has an invalid version - asterisk", (Object)value);
                    return Status.INVALID;
                }
                Status s = Validate.component(Convert.cpeUriToWellFormed(parts[4]));
                if (!s.isValid()) {
                    LOG.warn("The CPE ({}) has an invalid version - {}", (Object)value, (Object)s.getMessage());
                    return s;
                }
            }
            if (parts.length > 5) {
                if ("*".equals(parts[5])) {
                    LOG.warn("The CPE ({}) has an invalid update - asterisk", (Object)value);
                    return Status.INVALID;
                }
                Status s = Validate.component(Convert.cpeUriToWellFormed(parts[5]));
                if (!s.isValid()) {
                    LOG.warn("The CPE ({}) has an invalid update - {}", (Object)value, (Object)s.getMessage());
                    return s;
                }
            }
            if (parts.length > 6) {
                if (parts[6].startsWith("~")) {
                    Status s;
                    if (Validate.countCharacter(parts[6], '~') != 5L) {
                        LOG.warn("The CPE ({}) has an invalid packed edition - too many entries", (Object)value);
                        return Status.INVALID;
                    }
                    String[] unpacked = parts[6].split("~");
                    if (unpacked.length > 1) {
                        if ("*".equals(unpacked[1])) {
                            LOG.warn("The CPE ({}) has an invalid packed edition - asterisk", (Object)value);
                            return Status.INVALID;
                        }
                        s = Validate.component(Convert.cpeUriToWellFormed(unpacked[1]));
                        if (!s.isValid()) {
                            LOG.warn("The CPE ({}) has an invalid packed edition - {}", (Object)value, (Object)s.getMessage());
                            return s;
                        }
                    }
                    if (unpacked.length > 2) {
                        if ("*".equals(unpacked[2])) {
                            LOG.warn("The CPE ({}) has an invalid packed sw_edition - asterisk", (Object)value);
                            return Status.INVALID;
                        }
                        s = Validate.component(Convert.cpeUriToWellFormed(unpacked[2]));
                        if (!s.isValid()) {
                            LOG.warn("The CPE ({}) has an invalid packed sw_edition - {}", (Object)value, (Object)s.getMessage());
                            return s;
                        }
                    }
                    if (unpacked.length > 3) {
                        if ("*".equals(unpacked[3])) {
                            LOG.warn("The CPE ({}) has an invalid packed target_sw - asterisk", (Object)value);
                            return Status.INVALID;
                        }
                        s = Validate.component(Convert.cpeUriToWellFormed(unpacked[3]));
                        if (!s.isValid()) {
                            LOG.warn("The CPE ({}) has an invalid packed target_sw - {}", (Object)value, (Object)s.getMessage());
                            return s;
                        }
                    }
                    if (unpacked.length > 4) {
                        if ("*".equals(unpacked[4])) {
                            LOG.warn("The CPE ({}) has an invalid packed target_hw - asterisk", (Object)value);
                            return Status.INVALID;
                        }
                        s = Validate.component(Convert.cpeUriToWellFormed(unpacked[4]));
                        if (!s.isValid()) {
                            LOG.warn("The CPE ({}) has an invalid packed target_hw - {}", (Object)value, (Object)s.getMessage());
                            return s;
                        }
                    }
                    if (unpacked.length > 5) {
                        if ("*".equals(unpacked[5])) {
                            LOG.warn("The CPE ({}) has an invalid packed other - asterisk", (Object)value);
                            return Status.INVALID;
                        }
                        s = Validate.component(Convert.cpeUriToWellFormed(unpacked[5]));
                        if (!s.isValid()) {
                            LOG.warn("The CPE ({}) has an invalid packed other - {}", (Object)value, (Object)s.getMessage());
                            return s;
                        }
                    }
                } else {
                    if ("*".equals(parts[6])) {
                        LOG.warn("The CPE ({}) has an invalid edition - asterisk", (Object)value);
                        return Status.INVALID;
                    }
                    Status s = Validate.component(Convert.cpeUriToWellFormed(parts[6]));
                    if (!s.isValid()) {
                        LOG.warn("The CPE ({}) has an invalid edition - {}", (Object)value, (Object)s.getMessage());
                        return s;
                    }
                }
            }
            if (parts.length > 7) {
                if ("*".equals(parts[7])) {
                    LOG.warn("The CPE ({}) has an invalid language - asterisk", (Object)value);
                    return Status.INVALID;
                }
                Status s = Validate.component(Convert.cpeUriToWellFormed(parts[7]));
                if (!s.isValid()) {
                    LOG.warn("The CPE ({}) has an invalid language - {}", (Object)value, (Object)s.getMessage());
                    return s;
                }
            }
        }
        catch (CpeEncodingException ex) {
            LOG.warn("The CPE ({}) has an unencoded special characters", (Object)value);
            return Status.INVALID;
        }
        return Status.VALID;
    }

    private static long countCharacter(String value, char c) {
        return value.chars().filter(s -> s == c).count();
    }

    public static Status cpe(String value) {
        if ("cpe:2.3:".regionMatches(0, value, 0, 8)) {
            return Validate.formattedString(value);
        }
        return Validate.cpeUri(value);
    }
}

