/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.test.AbstractActionApp;

public class TestAction
extends AbstractActionApp
implements WrapperListener {
    private ActionRunner m_actionRunner;

    private TestAction() {
    }

    public Integer start(String[] args) {
        System.out.println("start()");
        if (args.length <= 0) {
            TestAction.printHelp("Missing action parameter.");
        }
        this.prepareSystemOutErr();
        this.m_actionRunner = new ActionRunner(args[0]);
        Thread actionThread = new Thread(this.m_actionRunner);
        actionThread.start();
        return null;
    }

    public int stop(int exitCode) {
        System.out.println("stop(" + exitCode + ")");
        if (this.isNestedExit()) {
            System.out.println("calling System.exit(" + exitCode + ") within stop.");
            System.exit(exitCode);
        }
        return exitCode;
    }

    public void controlEvent(int event) {
        System.out.println("controlEvent(" + event + ")");
        if (event == 200 && this.m_actionRunner != null) {
            this.m_actionRunner.endThread();
        }
    }

    private static void printHelp(String error_msg) {
        System.err.println("USAGE");
        System.err.println("");
        System.err.println("TestAction <action>");
        System.err.println("");
        System.err.println("[ACTIONS]");
        System.err.println("  Actions which should cause the Wrapper to exit cleanly:");
        System.err.println("   stop0                    : Calls WrapperManager.stop(0)");
        System.err.println("   exit0                    : Calls System.exit(0)");
        System.err.println("   stopimmediate0           : Calls WrapperManager.stopImmediate(0)");
        System.err.println("   stopandreturn0           : Calls WrapperManager.stopAndReturn(0)");
        System.err.println("  Actions which should cause the Wrapper to exit in an error state:");
        System.err.println("   stop1                    : Calls WrapperManager.stop(1)");
        System.err.println("   exit1                    : Calls System.exit(1)");
        System.err.println("   nestedexit1              : Calls System.exit(1) within WrapperListener.stop(1) callback");
        System.err.println("   stopimmediate1           : Calls WrapperManager.stopImmediate(1)");
        System.err.println("  Actions which should cause the Wrapper to restart the JVM:");
        System.err.println("   access_violation         : Calls WrapperManager.accessViolation");
        System.err.println("   access_violation_native  : Calls WrapperManager.accessViolationNative()");
        System.err.println("   appear_hung              : Calls WrapperManager.appearHung()");
        System.err.println("   halt0                    : Calls Runtime.getRuntime().halt(0)");
        System.err.println("   halt1                    : Calls Runtime.getRuntime().halt(1)");
        System.err.println("   restart                  : Calls WrapperManager.restart()");
        System.err.println("   restartandreturn         : Calls WrapperManager.restartAndReturn()");
        System.err.println("  Additional Tests:");
        System.err.println("   dump                     : Calls WrapperManager.requestThreadDump()");
        System.err.println("   deadlock_out             : Deadlocks the JVM's System.out and err streams.");
        System.err.println("   users                    : Start polling the current and interactive users.");
        System.err.println("   groups                   : Start polling the current and interactive users with groups.");
        System.err.println("   console                  : Prompt for actions in the console.");
        System.err.println("   idle                     : Do nothing just run in idle mode.");
        System.err.println("   properties               : Dump all System Properties to the console.");
        System.err.println("   configuration            : Dump all Wrapper Configuration Properties to the console.");
        System.err.println("");
        System.err.println("[EXAMPLE]");
        System.err.println("   TestAction access_violation_native ");
        System.err.println("");
        System.err.println("ERROR: " + error_msg);
        System.err.println("");
        System.exit(-1);
    }

    public static void main(String[] args) {
        System.out.println("Initializing...");
        WrapperManager.start((WrapperListener)new TestAction(), (String[])args);
    }

    static /* synthetic */ void access$000(String x0) {
        TestAction.printHelp(x0);
    }

    private class ActionRunner
    implements Runnable {
        private String m_action;
        private boolean m_alive;

        public ActionRunner(String action) {
            this.m_action = action;
            this.m_alive = true;
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (TestAction.this.doAction(this.m_action)) ** GOTO lbl15
            TestAction.access$000("\"" + this.m_action + "\" is an unknown action.");
            WrapperManager.stop((int)0);
            return;
lbl-1000:
            // 1 sources

            {
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
lbl15:
                // 3 sources

                ** while (this.m_alive)
            }
lbl16:
            // 1 sources

        }

        public void endThread() {
            this.m_alive = false;
        }
    }
}

