/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Memory
implements Runnable {
    private Writer m_writer;
    private Thread m_runner;
    private static final String PADDING = "                ";
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$Runtime;

    public void run() {
        long startTime;
        if (this.m_runner != null) {
            System.out.println("Stopping...");
            this.m_runner = null;
            return;
        }
        this.m_runner = Thread.currentThread();
        long lastTest = startTime = System.currentTimeMillis();
        try {
            this.m_writer.write("--> Starting Memory Log\n");
            this.m_writer.flush();
            while (this.m_runner != null) {
                long now = System.currentTimeMillis();
                System.out.println("Running for " + (now - startTime) + "ms...");
                if (now - lastTest > 15000L) {
                    Runtime rt = Runtime.getRuntime();
                    System.gc();
                    long totalMemory = rt.totalMemory();
                    long freeMemory = rt.freeMemory();
                    long usedMemory = totalMemory - freeMemory;
                    this.m_writer.write("total memory=" + this.pad(totalMemory, 10) + ", used=" + this.pad(usedMemory, 10) + ", free=" + this.pad(freeMemory, 10) + "\n");
                    this.m_writer.flush();
                    lastTest = now;
                }
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            this.m_writer.write("<-- Stopping Memory Log\n");
            this.m_writer.flush();
            this.m_writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String pad(long n, int len) {
        String s = Long.toString(n);
        int sLen = s.length();
        if (sLen < len) {
            s = s + PADDING.substring(0, len - sLen);
        }
        return s;
    }

    public static void main(String[] args) {
        Method addShutdownHookMethod;
        System.out.println("Memory Tester Running...");
        try {
            addShutdownHookMethod = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = Memory.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("addShutdownHook", class$java$lang$Thread == null ? (class$java$lang$Thread = Memory.class$("java.lang.Thread")) : class$java$lang$Thread);
        }
        catch (NoSuchMethodException e) {
            System.out.println("Shutdown hooks not supported by current JVM.");
            addShutdownHookMethod = null;
        }
        Memory app = new Memory();
        try {
            app.m_writer = new FileWriter("memory.log");
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (addShutdownHookMethod != null) {
            Runtime runtime = Runtime.getRuntime();
            Thread hook = new Thread((Runnable)app, "shutdown-hook");
            try {
                addShutdownHookMethod.invoke((Object)runtime, hook);
            }
            catch (IllegalAccessException e) {
                System.out.println("Unable to register shutdown hook: " + e.getMessage());
            }
            catch (InvocationTargetException e) {
                System.out.println("Unable to register shutdown hook: " + e.getMessage());
            }
        }
        new Thread((Runnable)app, "runner").start();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

