/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import org.tanukisoftware.wrapper.WrapperActionServer;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.test.AbstractActionApp;
import org.tanukisoftware.wrapper.test.DeadlockPrintStream;

public class Main
extends AbstractActionApp
implements WrapperListener {
    private MainFrame m_frame;
    private DeadlockPrintStream m_out;
    private DeadlockPrintStream m_err;
    private Thread m_userRunner;
    private List m_listenerFlags;
    private TextField m_serviceName;

    private Main() {
    }

    public Integer start(String[] args) {
        System.out.println("start()");
        this.prepareSystemOutErr();
        try {
            this.m_frame = new MainFrame();
            this.m_frame.setVisible(true);
        }
        catch (InternalError e) {
            System.out.println();
            System.out.println("ERROR - Unable to display the Swing GUI:");
            System.out.println("          " + e.toString());
            System.out.println("Exiting");
            System.out.println();
            return new Integer(1);
        }
        try {
            int port = 9999;
            WrapperActionServer server = new WrapperActionServer(port);
            server.enableShutdownAction(true);
            server.enableHaltExpectedAction(true);
            server.enableRestartAction(true);
            server.enableThreadDumpAction(true);
            server.enableHaltUnexpectedAction(true);
            server.enableAccessViolationAction(true);
            server.enableAppearHungAction(true);
            server.start();
            System.out.println("ActionServer Enabled. ");
            System.out.println("  Telnet localhost 9999");
            System.out.println("  Commands: ");
            System.out.println("    S: Shutdown");
            System.out.println("    H: Expected Halt");
            System.out.println("    R: Restart");
            System.out.println("    D: Thread Dump");
            System.out.println("    U: Unexpected Halt (Simulate crash)");
            System.out.println("    V: Access Violation (Actual crash)");
            System.out.println("    G: Make the JVM appear to be hung.");
        }
        catch (IOException e) {
            System.out.println("Unable to open the action server socket: " + e.getMessage());
        }
        return null;
    }

    public int stop(int exitCode) {
        System.out.println("stop(" + exitCode + ")");
        if (this.m_frame != null) {
            if (!WrapperManager.hasShutdownHookBeenTriggered()) {
                this.m_frame.setVisible(false);
                this.m_frame.dispose();
            }
            this.m_frame = null;
        }
        if (this.isNestedExit()) {
            System.out.println("calling System.exit(" + exitCode + ") within stop.");
            System.exit(exitCode);
        }
        return exitCode;
    }

    public void controlEvent(int event) {
        System.out.println("controlEvent(" + event + ")");
        if (event == 202 && WrapperManager.isLaunchedAsService()) {
            System.out.println("  Ignoring logoff event");
        } else {
            WrapperManager.stop((int)0);
        }
    }

    public static void main(String[] args) {
        System.out.println("Initializing...");
        WrapperManager.start((WrapperListener)new Main(), (String[])args);
    }

    private class MainFrame
    extends Frame
    implements ActionListener {
        MainFrame() {
            super("Wrapper Test Application");
            this.init();
            this.setLocation(10, 10);
            this.setSize(750, 480);
            this.setResizable(true);
        }

        private void init() {
            GridBagLayout gridBag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            Panel panel = new Panel();
            panel.setLayout(gridBag);
            ScrollPane scrollPane = new ScrollPane();
            scrollPane.add(panel);
            scrollPane.getHAdjustable().setUnitIncrement(20);
            scrollPane.getVAdjustable().setUnitIncrement(20);
            this.setLayout(new BorderLayout());
            this.add((Component)scrollPane, "Center");
            this.buildCommand(panel, gridBag, c, "Stop(0)", "stop0", "Calls WrapperManager.stop( 0 ) to shutdown the JVM and Wrapper with a success exit code.");
            this.buildCommand(panel, gridBag, c, "Stop(1)", "stop1", "Calls WrapperManager.stop( 1 ) to shutdown the JVM and Wrapper with a failure exit code.");
            this.buildCommand(panel, gridBag, c, "Exit(0)", "exit0", "Calls System.exit( 0 ) to shutdown the JVM and Wrapper with a success exit code.");
            this.buildCommand(panel, gridBag, c, "Exit(1)", "exit1", "Calls System.exit( 1 ) to shutdown the JVM and Wrapper with a failure exit code.");
            this.buildCommand(panel, gridBag, c, "StopImmediate(0)", "stopimmediate0", "Calls WrapperManager.stopImmediate( 0 ) to immediately shutdown the JVM and Wrapper with a success exit code.");
            this.buildCommand(panel, gridBag, c, "StopImmediate(1)", "stopimmediate1", "Calls WrapperManager.stopImmediate( 1 ) to immediately shutdown the JVM and Wrapper with a failure exir code.");
            this.buildCommand(panel, gridBag, c, "StopAndReturn(0)", "stopandreturn0", "Calls WrapperManager.stopAndReturn( 0 ) to shutdown the JVM and Wrapper with a success exit code.");
            this.buildCommand(panel, gridBag, c, "Nested Exit(1)", "nestedexit1", "Calls System.exit(1) within WrapperListener.stop(1) callback.");
            this.buildCommand(panel, gridBag, c, "Halt(0)", "halt0", "Calls Runtime.getRuntime().halt(0) to kill the JVM, the Wrapper will restart it.");
            this.buildCommand(panel, gridBag, c, "Halt(1)", "halt1", "Calls Runtime.getRuntime().halt(1) to kill the JVM, the Wrapper will restart it.");
            this.buildCommand(panel, gridBag, c, "Restart()", "restart", "Calls WrapperManager.restart() to shutdown the current JVM and start a new one.");
            this.buildCommand(panel, gridBag, c, "RestartAndReturn()", "restartandreturn", "Calls WrapperManager.restartAndReturn() to shutdown the current JVM and start a new one.");
            this.buildCommand(panel, gridBag, c, "Access Violation", "access_violation", "Attempts to cause an access violation within the JVM, relies on a JVM bug and may not work.");
            this.buildCommand(panel, gridBag, c, "Native Access Violation", "access_violation_native", "Causes an access violation using native code, the JVM will crash and be restarted.");
            this.buildCommand(panel, gridBag, c, "Simulate JVM Hang", "appear_hung", "Makes the JVM appear to be hung as viewed from the Wrapper, it will be killed and restarted.");
            this.buildCommand(panel, gridBag, c, "Request Thread Dump", "dump", "Calls WrapperManager.requestThreadDump() to cause the JVM to dump its current thread state.");
            this.buildCommand(panel, gridBag, c, "System.out Deadlock", "deadlock_out", "Simulates a failure mode where the System.out object has become deadlocked.");
            this.buildCommand(panel, gridBag, c, "Poll Users", "users", "Begins calling WrapperManager.getUser() and getInteractiveUser() to monitor the current and interactive users.");
            this.buildCommand(panel, gridBag, c, "Poll Users with Groups", "groups", "Same as above, but includes information about the user's groups.");
            this.buildCommand(panel, gridBag, c, "Console", "console", "Prompt for Actions in the console.");
            this.buildCommand(panel, gridBag, c, "Idle", "idle", "Run idly.");
            this.buildCommand(panel, gridBag, c, "Dump Properties", "properties", "Dumps all System Properties to the console.");
            this.buildCommand(panel, gridBag, c, "Dump Configuration", "configuration", "Dumps all Wrapper Configuration Properties to the console.");
            Main.this.m_listenerFlags = new List(2, true);
            Main.this.m_listenerFlags.add("Service");
            Main.this.m_listenerFlags.add("Control");
            Main.this.m_listenerFlags.add("Core");
            Panel flagPanel = new Panel();
            flagPanel.setLayout(new BorderLayout());
            flagPanel.add((Component)new Label("Event Flags: "), "West");
            flagPanel.add((Component)Main.this.m_listenerFlags, "Center");
            flagPanel.setSize(100, 10);
            Panel flagPanel2 = new Panel();
            flagPanel2.setLayout(new BorderLayout());
            flagPanel2.add((Component)flagPanel, "West");
            this.buildCommand(panel, gridBag, c, "Update Event Listener", "listener", flagPanel2);
            this.buildCommand(panel, gridBag, c, "Service List", "service_list", "Displays a list of registered services on Windows.");
            Main.this.m_serviceName = new TextField("testwrapper");
            Panel servicePanel = new Panel();
            servicePanel.setLayout(new BorderLayout());
            servicePanel.add((Component)new Label("Interrogate Service.  Service name: "), "West");
            servicePanel.add((Component)Main.this.m_serviceName, "Center");
            Panel servicePanel2 = new Panel();
            servicePanel2.setLayout(new BorderLayout());
            servicePanel2.add((Component)servicePanel, "West");
            this.buildCommand(panel, gridBag, c, "Service Interrogate", "service_interrogate", servicePanel2);
            this.buildCommand(panel, gridBag, c, "Service Start", "service_start", "Starts the above service.");
            this.buildCommand(panel, gridBag, c, "Service Stop", "service_stop", "Stops the above service.");
            this.buildCommand(panel, gridBag, c, "Service User Code", "service_user", "Sends a series of user codes to the above service.");
        }

        private void buildCommand(Container container, GridBagLayout gridBag, GridBagConstraints c, String label, String command, Object description) {
            Button button = new Button(label);
            button.setActionCommand(command);
            c.fill = 1;
            c.gridwidth = 1;
            gridBag.setConstraints(button, c);
            container.add(button);
            button.addActionListener(this);
            c.gridwidth = 0;
            Component desc = description instanceof String ? new Label((String)description) : (description instanceof Component ? (Component)description : new Label(description.toString()));
            gridBag.setConstraints(desc, c);
            container.add(desc);
        }

        public void actionPerformed(ActionEvent event) {
            String action = event.getActionCommand();
            if (action.equals("listener")) {
                long mask = 0L;
                String[] flags = Main.this.m_listenerFlags.getSelectedItems();
                int i = 0;
                while (i < flags.length) {
                    String flag = flags[i];
                    if (flag.equals("Service")) {
                        mask |= 1L;
                    } else if (flag.equals("Control")) {
                        mask |= 2L;
                    } else if (flag.equals("Core")) {
                        mask |= 0xF000000000000000L;
                    }
                    ++i;
                }
                Main.this.setEventMask(mask);
            }
            Main.this.setServiceName(Main.this.m_serviceName.getText());
            Main.this.doAction(action);
        }
    }
}

