/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.Properties;
import org.tanukisoftware.wrapper.WrapperManager;

public class EnvironmentVariables {
    private static Properties _env = null;

    public static void main(String[] args) {
        System.out.println("user.language=" + System.getProperty("user.language"));
        System.out.println("user.region=" + System.getProperty("user.region"));
        System.out.println("Locale=" + Locale.getDefault());
        System.out.println("Looking for environment variables...");
        try {
            EnvironmentVariables.getEnvironmentVariables();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        boolean passed = false;
        if (_env != null) {
            System.out.println();
            passed = EnvironmentVariables.check("ENV_VAR_1", "a");
            passed = EnvironmentVariables.check("ENV_VAR_2", "b");
            passed = EnvironmentVariables.check("ENV_VAR_3", "c");
            passed = EnvironmentVariables.check("ENV_VAR_4", "d");
            System.out.println();
        }
        if (passed) {
            System.out.println("Environment variables test passed.");
        } else {
            System.out.println("Environment variables test FAILED.");
        }
        System.out.println("Request a JVM restart.");
        WrapperManager.restart();
    }

    private static boolean check(String variable, String expected) {
        String actual = _env.getProperty(variable);
        System.out.print(variable + " = " + actual + ": ");
        if (expected.equals(actual)) {
            System.out.println("OK");
            return true;
        }
        System.out.println("FAILED (expected: " + expected + ")");
        return false;
    }

    private static void getEnvironmentVariables() throws IOException {
        String os = System.getProperty("os.name").toLowerCase();
        System.out.println("Platform is " + os + ".");
        Process p = null;
        if (os.indexOf("windows 9") > -1) {
            p = Runtime.getRuntime().exec("command.com /c set");
        } else if (os.indexOf("unix") > -1) {
            p = Runtime.getRuntime().exec("/bin/env");
        } else if (os.indexOf("nt") > -1 || os.indexOf("windows 2000") > -1 || os.indexOf("windows xp") > -1 || os.indexOf("windows 2003") > -1) {
            p = Runtime.getRuntime().exec("cmd.exe /c set");
        } else if (os.indexOf("unix") > -1) {
            p = Runtime.getRuntime().exec("/bin/env");
        } else if (os.indexOf("linux") > -1 || os.indexOf("mac os x") > -1) {
            p = Runtime.getRuntime().exec("/usr/bin/env");
        }
        if (p == null) {
            System.out.println("Don't know how to read environment variables on this platform: " + os);
            return;
        }
        _env = new Properties();
        BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String line = null;
        while ((line = br.readLine()) != null) {
            int idx = line.indexOf(61);
            if (idx <= -1) continue;
            String key = line.substring(0, idx);
            String value = line.substring(idx + 1);
            _env.setProperty(key, value);
        }
    }
}

