/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.io.IOException;
import java.io.PrintStream;

public class DeadlockPrintStream
extends PrintStream {
    private PrintStream m_out;
    private boolean m_deadlock;

    public DeadlockPrintStream(PrintStream out) {
        super(out);
        this.m_out = out;
    }

    public void write(int b) {
        this.deadlock();
        this.m_out.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.deadlock();
        this.m_out.write(b);
    }

    public void write(byte[] b, int off, int len) {
        this.deadlock();
        this.m_out.write(b, off, len);
    }

    public void flush() {
        this.deadlock();
        this.m_out.flush();
    }

    public void close() {
        this.deadlock();
        this.m_out.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deadlock() {
        if (!this.m_deadlock) return;
        DeadlockPrintStream deadlockPrintStream = this;
        synchronized (deadlockPrintStream) {
            while (this.m_deadlock) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public void setDeadlock(boolean deadlock) {
        this.m_deadlock = deadlock;
        if (!this.m_deadlock) {
            DeadlockPrintStream deadlockPrintStream = this;
            synchronized (deadlockPrintStream) {
                this.notifyAll();
            }
        }
    }
}

