/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperServiceException;
import org.tanukisoftware.wrapper.WrapperWin32Service;
import org.tanukisoftware.wrapper.event.WrapperControlEvent;
import org.tanukisoftware.wrapper.event.WrapperEvent;
import org.tanukisoftware.wrapper.event.WrapperEventListener;
import org.tanukisoftware.wrapper.test.DeadlockPrintStream;

public abstract class AbstractActionApp
implements WrapperEventListener {
    private DeadlockPrintStream m_out;
    private DeadlockPrintStream m_err;
    private Thread m_runner = new Thread("WrapperActionTest_Runner"){
        static /* synthetic */ Class class$org$tanukisoftware$wrapper$test$AbstractActionApp;

        public void run() {
            while (true) {
                if (AbstractActionApp.this.m_users) {
                    System.out.println("The current user is: " + WrapperManager.getUser((boolean)AbstractActionApp.this.m_groups));
                    System.out.println("The current interactive user is: " + WrapperManager.getInteractiveUser((boolean)AbstractActionApp.this.m_groups));
                }
                Class clazz = class$org$tanukisoftware$wrapper$test$AbstractActionApp == null ? 1.class$("org.tanukisoftware.wrapper.test.AbstractActionApp") : class$org$tanukisoftware$wrapper$test$AbstractActionApp;
                synchronized (clazz) {
                    try {
                        (class$org$tanukisoftware$wrapper$test$AbstractActionApp == null ? 1.class$("org.tanukisoftware.wrapper.test.AbstractActionApp") : class$org$tanukisoftware$wrapper$test$AbstractActionApp).wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    };
    private Thread m_consoleRunner;
    private boolean m_users;
    private boolean m_groups;
    private boolean m_nestedExit;
    private long m_eventMask = -1L;
    private String m_serviceName = "testWrapper";
    static /* synthetic */ Class class$java$lang$Runtime;
    static /* synthetic */ Class class$org$tanukisoftware$wrapper$test$AbstractActionApp;

    protected AbstractActionApp() {
        this.m_runner.setDaemon(true);
        this.m_runner.start();
    }

    public void fired(WrapperEvent event) {
        System.out.println("Received event: " + event);
        if (event instanceof WrapperControlEvent) {
            System.out.println("  Consume and ignore.");
            ((WrapperControlEvent)event).consume();
        }
    }

    protected boolean isNestedExit() {
        return this.m_nestedExit;
    }

    protected void setEventMask(long eventMask) {
        this.m_eventMask = eventMask;
    }

    protected void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    protected void prepareSystemOutErr() {
        this.m_out = new DeadlockPrintStream(System.out);
        System.setOut(this.m_out);
        this.m_err = new DeadlockPrintStream(System.err);
        System.setErr(this.m_err);
    }

    protected boolean doAction(String action) {
        if (action.equals("stop0")) {
            WrapperManager.stop((int)0);
        } else if (action.equals("stop1")) {
            WrapperManager.stop((int)1);
        } else if (action.equals("exit0")) {
            System.exit(0);
        } else if (action.equals("exit1")) {
            System.exit(1);
        } else if (action.equals("nestedexit1")) {
            this.m_nestedExit = true;
            WrapperManager.stop((int)1);
        } else if (action.equals("stopimmediate0")) {
            WrapperManager.stopImmediate((int)0);
        } else if (action.equals("stopimmediate1")) {
            WrapperManager.stopImmediate((int)1);
        } else if (action.equals("stopandreturn0")) {
            WrapperManager.stopAndReturn((int)0);
        } else if (action.equals("halt0")) {
            Method haltMethod;
            try {
                haltMethod = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = AbstractActionApp.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("halt", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                System.out.println("halt not supported by current JVM.");
                haltMethod = null;
            }
            if (haltMethod != null) {
                Runtime runtime = Runtime.getRuntime();
                try {
                    haltMethod.invoke((Object)runtime, new Integer(0));
                }
                catch (IllegalAccessException e) {
                    System.out.println("Unable to call runitme.halt: " + e.getMessage());
                }
                catch (InvocationTargetException e) {
                    System.out.println("Unable to call runitme.halt: " + e.getMessage());
                }
            }
        } else if (action.equals("halt1")) {
            Method haltMethod;
            try {
                haltMethod = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = AbstractActionApp.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("halt", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                System.out.println("halt not supported by current JVM.");
                haltMethod = null;
            }
            if (haltMethod != null) {
                Runtime runtime = Runtime.getRuntime();
                try {
                    haltMethod.invoke((Object)runtime, new Integer(1));
                }
                catch (IllegalAccessException e) {
                    System.out.println("Unable to call runitme.halt: " + e.getMessage());
                }
                catch (InvocationTargetException e) {
                    System.out.println("Unable to call runitme.halt: " + e.getMessage());
                }
            }
        } else if (action.equals("restart")) {
            WrapperManager.restart();
        } else if (action.equals("restartandreturn")) {
            WrapperManager.restartAndReturn();
        } else if (action.equals("access_violation")) {
            WrapperManager.accessViolation();
        } else if (action.equals("access_violation_native")) {
            WrapperManager.accessViolationNative();
        } else if (action.equals("appear_hung")) {
            WrapperManager.appearHung();
        } else if (action.equals("dump")) {
            WrapperManager.requestThreadDump();
        } else if (action.equals("deadlock_out")) {
            System.out.println("Deadlocking System.out and System.err ...");
            this.m_out.setDeadlock(true);
            this.m_err.setDeadlock(true);
        } else {
            if (action.equals("users")) {
                if (!this.m_users) {
                    System.out.println("Begin polling the current and interactive users.");
                    this.m_users = true;
                } else if (this.m_groups) {
                    System.out.println("Stop polling for group info.");
                    this.m_groups = false;
                } else {
                    System.out.println("Stop polling the current and interactive users.");
                    this.m_users = false;
                }
                Class haltMethod = class$org$tanukisoftware$wrapper$test$AbstractActionApp == null ? (class$org$tanukisoftware$wrapper$test$AbstractActionApp = AbstractActionApp.class$("org.tanukisoftware.wrapper.test.AbstractActionApp")) : class$org$tanukisoftware$wrapper$test$AbstractActionApp;
                synchronized (haltMethod) {
                    (class$org$tanukisoftware$wrapper$test$AbstractActionApp == null ? (class$org$tanukisoftware$wrapper$test$AbstractActionApp = AbstractActionApp.class$("org.tanukisoftware.wrapper.test.AbstractActionApp")) : class$org$tanukisoftware$wrapper$test$AbstractActionApp).notifyAll();
                }
            }
            if (action.equals("groups")) {
                if (!this.m_users || !this.m_groups) {
                    System.out.println("Begin polling the current and interactive users with group info.");
                    this.m_users = true;
                    this.m_groups = true;
                } else {
                    System.out.println("Stop polling for group info.");
                    this.m_groups = false;
                }
                Class haltMethod = class$org$tanukisoftware$wrapper$test$AbstractActionApp == null ? (class$org$tanukisoftware$wrapper$test$AbstractActionApp = AbstractActionApp.class$("org.tanukisoftware.wrapper.test.AbstractActionApp")) : class$org$tanukisoftware$wrapper$test$AbstractActionApp;
                synchronized (haltMethod) {
                    (class$org$tanukisoftware$wrapper$test$AbstractActionApp == null ? (class$org$tanukisoftware$wrapper$test$AbstractActionApp = AbstractActionApp.class$("org.tanukisoftware.wrapper.test.AbstractActionApp")) : class$org$tanukisoftware$wrapper$test$AbstractActionApp).notifyAll();
                }
            }
            if (action.equals("console")) {
                if (this.m_consoleRunner == null) {
                    this.m_consoleRunner = new Thread("console-runner"){

                        public void run() {
                            System.out.println();
                            System.out.println("Start prompting for actions.");
                            try {
                                BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
                                try {
                                    String line;
                                    do {
                                        System.out.println("Input an action (return stops prompting):");
                                        line = r.readLine();
                                        if (line == null || line.equals("")) continue;
                                        System.out.println("Read action: " + line);
                                        if (AbstractActionApp.this.doAction(line)) continue;
                                        System.out.println("Unknown action: " + line);
                                    } while (line != null && !line.equals(""));
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                Object var5_4 = null;
                                System.out.println("Stop prompting for actions.");
                                System.out.println();
                            }
                            catch (Throwable throwable) {
                                Object var5_5 = null;
                                System.out.println("Stop prompting for actions.");
                                System.out.println();
                                AbstractActionApp.this.m_consoleRunner = null;
                                throw throwable;
                            }
                            AbstractActionApp.this.m_consoleRunner = null;
                        }
                    };
                    this.m_consoleRunner.setDaemon(true);
                    this.m_consoleRunner.start();
                }
            } else {
                if (action.equals("idle")) {
                    System.out.println("Run idle.");
                    this.m_users = false;
                    this.m_groups = false;
                    Class haltMethod = class$org$tanukisoftware$wrapper$test$AbstractActionApp == null ? (class$org$tanukisoftware$wrapper$test$AbstractActionApp = AbstractActionApp.class$("org.tanukisoftware.wrapper.test.AbstractActionApp")) : class$org$tanukisoftware$wrapper$test$AbstractActionApp;
                    synchronized (haltMethod) {
                        (class$org$tanukisoftware$wrapper$test$AbstractActionApp == null ? (class$org$tanukisoftware$wrapper$test$AbstractActionApp = AbstractActionApp.class$("org.tanukisoftware.wrapper.test.AbstractActionApp")) : class$org$tanukisoftware$wrapper$test$AbstractActionApp).notifyAll();
                    }
                }
                if (action.equals("properties")) {
                    System.out.println("Dump System Properties:");
                    Properties props = System.getProperties();
                    Enumeration<?> en = props.propertyNames();
                    while (en.hasMoreElements()) {
                        String name = (String)en.nextElement();
                        System.out.println("  " + name + "=" + props.getProperty(name));
                    }
                    System.out.println();
                } else if (action.equals("configuration")) {
                    System.out.println("Dump Wrapper Properties:");
                    Properties props = WrapperManager.getProperties();
                    Enumeration<?> en = props.propertyNames();
                    while (en.hasMoreElements()) {
                        String name = (String)en.nextElement();
                        System.out.println("  " + name + "=" + props.getProperty(name));
                    }
                    System.out.println();
                } else if (action.equals("listener")) {
                    System.out.println("Updating Event Listeners:");
                    WrapperManager.removeWrapperEventListener((WrapperEventListener)this);
                    WrapperManager.addWrapperEventListener((WrapperEventListener)this, (long)this.m_eventMask);
                } else if (action.equals("service_list")) {
                    WrapperWin32Service[] services = WrapperManager.listServices();
                    if (services == null) {
                        System.out.println("Services not supported by current platform.");
                    } else {
                        System.out.println("Registered Services:");
                        int i = 0;
                        while (i < services.length) {
                            System.out.println("  " + services[i]);
                            ++i;
                        }
                    }
                } else if (action.equals("service_interrogate")) {
                    try {
                        WrapperWin32Service service = WrapperManager.sendServiceControlCode((String)this.m_serviceName, (int)4);
                        System.out.println("Service after interrogate: " + service);
                    }
                    catch (WrapperServiceException e) {
                        e.printStackTrace();
                    }
                } else if (action.equals("service_start")) {
                    try {
                        WrapperWin32Service service = WrapperManager.sendServiceControlCode((String)this.m_serviceName, (int)65536);
                        System.out.println("Service after start: " + service);
                    }
                    catch (WrapperServiceException e) {
                        e.printStackTrace();
                    }
                } else if (action.equals("service_stop")) {
                    try {
                        WrapperWin32Service service = WrapperManager.sendServiceControlCode((String)this.m_serviceName, (int)1);
                        System.out.println("Service after stop: " + service);
                    }
                    catch (WrapperServiceException e) {
                        e.printStackTrace();
                    }
                } else if (action.equals("service_user")) {
                    try {
                        int i = 128;
                        while (i < 256) {
                            WrapperWin32Service service = WrapperManager.sendServiceControlCode((String)this.m_serviceName, (int)i);
                            System.out.println("Service after user code " + i + ": " + service);
                            i += 10;
                        }
                    }
                    catch (WrapperServiceException e) {
                        e.printStackTrace();
                    }
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

