/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.string;

import javax.servlet.jsp.JspException;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.taglibs.string.StringTagSupport;

public class RandomStringTag
extends StringTagSupport {
    public static String NUMERIC = "numeric";
    public static String ALPHANUMERIC = "alphanumeric";
    public static String ALPHABET = "alphabet";
    public static String UNICODE = "unicode";
    private String count;
    private String start;
    private String end;
    private String type;

    public String getCount() {
        return this.count;
    }

    public void setCount(String count) {
        this.count = count;
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String changeString(String text) throws JspException {
        int st = 0;
        int ed = 0;
        int ct = 0;
        boolean letters = false;
        boolean numbers = false;
        letters = ALPHABET.equals(this.type);
        numbers = NUMERIC.equals(this.type);
        if (ALPHANUMERIC.equals(this.type)) {
            letters = true;
            numbers = true;
        }
        char[] setChrs = null;
        if (!StringUtils.isBlank((String)text)) {
            setChrs = text.toCharArray();
        }
        if (!StringUtils.isEmpty((String)this.start)) {
            try {
                st = NumberUtils.isNumber((String)this.start) ? NumberUtils.createNumber((String)this.start).intValue() : (int)this.start.charAt(0);
            }
            catch (NumberFormatException nfe) {
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty((String)this.end)) {
            try {
                ed = NumberUtils.isNumber((String)this.end) ? NumberUtils.createNumber((String)this.end).intValue() : (int)this.end.charAt(0);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
            }
        }
        if (setChrs != null) {
            if (st > setChrs.length - 1) {
                st = 0;
            }
            if (ed == 0 || ed > setChrs.length - 1) {
                ed = setChrs.length - 1;
            }
        }
        try {
            ct = NumberUtils.createNumber((String)this.count).intValue();
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        String randomString = null;
        try {
            randomString = RandomStringUtils.random((int)ct, (int)st, (int)ed, (boolean)letters, (boolean)numbers, (char[])setChrs);
        }
        catch (Exception exc) {
            randomString = letters && numbers ? RandomStringUtils.randomAlphanumeric((int)ct) : (letters ? RandomStringUtils.randomNumeric((int)ct) : (numbers ? RandomStringUtils.randomNumeric((int)ct) : RandomStringUtils.random((int)ct)));
            StringBuffer msg = new StringBuffer();
            msg.append("Exception on RandomStringTag: " + exc);
            msg.append("\nCT: " + ct);
            msg.append("\nST: " + st);
            msg.append("\nED: " + ed);
            msg.append("\nletters: " + letters);
            msg.append("\nnumbers: " + numbers);
            msg.append("\nset: " + (setChrs == null ? "null" : "" + setChrs.length + " characters"));
            msg.append("\nreturning " + randomString);
            System.err.println(msg.toString());
        }
        return randomString;
    }

    public void initAttributes() {
        this.count = null;
        this.start = null;
        this.end = null;
        this.type = UNICODE;
    }
}

