/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.internal.util;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkInternalApi
public final class RegionScope
implements ToCopyableBuilder<Builder, RegionScope> {
    public static final RegionScope GLOBAL;
    private static final Pattern REGION_SCOPE_PATTERN;
    private final String regionScope;

    private RegionScope(Builder b) {
        this.regionScope = (String)Validate.paramNotBlank((CharSequence)b.regionScope, (String)"regionScope");
        this.validateFormat(this.regionScope);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String id() {
        return this.regionScope;
    }

    public static RegionScope of(String value) {
        return RegionScope.builder().regionScope(value).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegionScope that = (RegionScope)o;
        return this.regionScope.equals(that.regionScope);
    }

    public int hashCode() {
        return 31 * (1 + (this.regionScope != null ? this.regionScope.hashCode() : 0));
    }

    public Builder toBuilder() {
        return RegionScope.builder().regionScope(this.regionScope);
    }

    private void validateFormat(String regionScope) {
        Matcher matcher = REGION_SCOPE_PATTERN.matcher(regionScope);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Incorrect region scope '" + regionScope + "'. Region scope must be a string that either is a complete region string, such as 'us-east-1', or uses the wildcard '*' to represent any region that starts with the preceding parts. Wildcards must appear as a separate segment after a '-' dash, for example 'us-east-*'. A global scope of '*' is allowed.");
        }
        List<String> segments = Arrays.asList(regionScope.split("-"));
        String lastSegment = segments.get(segments.size() - 1);
        if (lastSegment.contains("*") && lastSegment.length() != 1) {
            throw new IllegalArgumentException("Incorrect region scope '" + regionScope + "'. A wildcard must only appear on its own at the end of the expression after a '-' dash. A global scope of '*' is allowed.");
        }
    }

    static {
        REGION_SCOPE_PATTERN = Pattern.compile("^([a-z0-9-])*([*]?)$");
        GLOBAL = RegionScope.of("*");
    }

    public static final class Builder
    implements CopyableBuilder<Builder, RegionScope> {
        private String regionScope;

        private Builder() {
        }

        public void setRegionScope(String regionScope) {
            this.regionScope(regionScope);
        }

        public Builder regionScope(String regionScope) {
            this.regionScope = regionScope;
            return this;
        }

        public RegionScope build() {
            return new RegionScope(this);
        }
    }
}

