/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.util.DOMUtils;
import org.apache.util.DOMWriter;
import org.apache.webdav.lib.WebdavState;
import org.apache.webdav.lib.methods.DepthSupport;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class LockMethod
extends XMLResponseMethodBase
implements DepthSupport {
    public static final short SCOPE_EXCLUSIVE = 0;
    public static final short SCOPE_SHARED = 1;
    public static final short TYPE_WRITE = 0;
    public static final int TIMEOUT_INFINITY = Integer.MAX_VALUE;
    private short scope = 0;
    private int depth = Integer.MAX_VALUE;
    private String refreshOpaqueToken = null;
    private int timeout = Integer.MAX_VALUE;
    private String owner = null;
    private String lockToken = null;

    public LockMethod() {
    }

    public LockMethod(String path) {
        super(path);
    }

    public LockMethod(String path, String refreshOpaqueToken, int timeout) {
        this(path);
        this.refreshOpaqueToken = refreshOpaqueToken;
        this.setTimeout(timeout);
    }

    public LockMethod(String path, String owner, short scope, int timeout) {
        this(path);
        this.setOwner(owner);
        this.setScope(scope);
        this.setTimeout(timeout);
    }

    public LockMethod(String path, String refreshOpaqueToken, long timeout) {
        this(path, refreshOpaqueToken, (int)timeout);
    }

    public LockMethod(String path, String owner, short scope, long timeout) {
        this(path, owner, scope, (int)timeout);
    }

    public void setRequestHeader(String headerName, String headerValue) {
        if (headerName.equalsIgnoreCase("Depth")) {
            int depth = -1;
            if (headerValue.equals("0")) {
                depth = 0;
            }
            if (headerValue.equals("1")) {
                depth = 1;
            } else if (headerValue.equalsIgnoreCase("infinity")) {
                depth = Integer.MAX_VALUE;
            }
            this.setDepth(depth);
        } else if (headerName.equalsIgnoreCase("Timeout")) {
            if (headerValue.startsWith("Second-")) {
                headerValue = headerValue.substring("Second-".length());
            }
            try {
                this.setTimeout(Integer.parseInt(headerValue));
            }
            catch (NumberFormatException e) {}
        } else if (headerName.equalsIgnoreCase("Owner")) {
            this.setOwner(headerValue);
        } else {
            super.setRequestHeader(headerName, headerValue);
        }
    }

    public void setDepth(int depth) {
        this.checkNotUsed();
        if (depth != 0 && depth != Integer.MAX_VALUE) {
            throw new IllegalArgumentException("invalid depth value for lock method " + depth);
        }
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public String getLockToken() {
        this.checkUsed();
        return this.lockToken;
    }

    public boolean isRefresh() {
        return this.refreshOpaqueToken != null && !this.refreshOpaqueToken.equals("");
    }

    public short getScope() {
        return this.scope;
    }

    public void setOwner(String owner) {
        this.checkNotUsed();
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setScope(short scope) {
        this.checkNotUsed();
        if (scope != 1 && scope != 0) {
            throw new IllegalArgumentException("invalid scope value");
        }
        this.scope = scope;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.checkNotUsed();
        if (timeout < 0) {
            throw new IllegalArgumentException("invalid timeout value: " + timeout);
        }
        this.timeout = timeout;
    }

    public void setTimeout(long timeout) {
        this.setTimeout((int)timeout);
    }

    public String getName() {
        return "LOCK";
    }

    public void recycle() {
        super.recycle();
        this.refreshOpaqueToken = null;
        this.depth = Integer.MAX_VALUE;
        this.scope = 0;
        this.timeout = Integer.MAX_VALUE;
    }

    public void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        if (this.getRequestHeader("Content-Type") == null) {
            super.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
        }
        super.addRequestHeaders(state, conn);
        switch (this.depth) {
            case 0: {
                super.setRequestHeader("Depth", "0");
                break;
            }
            case 0x7FFFFFFF: {
                super.setRequestHeader("Depth", "infinity");
                break;
            }
        }
        if (this.timeout == Integer.MAX_VALUE) {
            super.setRequestHeader("Timeout", "Infinite, Second-2147483647");
        } else {
            super.setRequestHeader("Timeout", "Second-" + this.timeout);
        }
        if (this.isRefresh()) {
            super.setRequestHeader("If", "(<" + this.refreshOpaqueToken + ">)");
        }
    }

    protected String generateRequestBody() {
        String result;
        block6: {
            result = "";
            if (this.isRefresh()) break block6;
            if (this.owner == null || this.owner.equals("")) {
                throw new IllegalStateException("The owner property has not been set");
            }
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.newDocument();
                Element lockinfo = document.createElement("DAV:lockinfo");
                document.appendChild(lockinfo);
                lockinfo.setAttribute("xmlns:DAV", "DAV:");
                Element lockscope = document.createElement("DAV:lockscope");
                lockinfo.appendChild(lockscope);
                if (this.scope == 0) {
                    Element exclusive = document.createElement("DAV:exclusive");
                    lockscope.appendChild(exclusive);
                } else {
                    Element shared = document.createElement("DAV:shared");
                    lockscope.appendChild(shared);
                }
                Element locktype = document.createElement("DAV:locktype");
                lockinfo.appendChild(locktype);
                Element write = document.createElement("DAV:write");
                locktype.appendChild(write);
                Element owner = document.createElement("DAV:owner");
                lockinfo.appendChild(owner);
                Text text = document.createTextNode(this.owner);
                owner.appendChild(text);
                StringWriter stringWriter = new StringWriter();
                DOMWriter domWriter = new DOMWriter(stringWriter, false);
                domWriter.print(document);
                result = stringWriter.getBuffer().toString();
            }
            catch (DOMException e) {
            }
            catch (ParserConfigurationException e) {}
        }
        return result;
    }

    public void parseResponse(InputStream input, HttpState state, HttpConnection conn) throws IOException, HttpException {
        int status = this.getStatusLine().getStatusCode();
        if (status == 200 || status == 201 || status == 207) {
            this.parseXMLResponse(input);
            if (status == 200 && state instanceof WebdavState) {
                Element locktoken;
                NodeList list2;
                String prefix = DOMUtils.findDavPrefix(this.getResponseDocument());
                NodeList list = this.getResponseDocument().getDocumentElement().getElementsByTagName(prefix + "locktoken");
                if (list.getLength() == 1 && (list2 = (locktoken = (Element)list.item(0)).getElementsByTagName(prefix + "href")).getLength() == 1) {
                    this.lockToken = DOMUtils.getTextValue(list2.item(0));
                    ((WebdavState)state).addLock(this.getPath(), this.lockToken);
                }
                if ((list = this.getResponseDocument().getDocumentElement().getElementsByTagName(prefix + "owner")).getLength() == 1) {
                    Element owner = (Element)list.item(0);
                    this.owner = DOMUtils.getTextValue(owner);
                }
            }
        }
    }
}

